/**
 * \file multi_filesel.h
 * \brief Header file for multi file selection dialog object
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __MULTI_FILESEL_H__
#define __MULTI_FILESEL_H__

#include <gdk/gdk.h>
#include <gtk/gtkfilesel.h>

#define MULTI_FILESEL(obj)	GTK_CHECK_CAST(obj, multi_filesel_get_type(), MultiFileSel)
#define MULTI_FILESEL_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, multi_filesel_get_type(), MultiFileSel)
#define IS_MULTI_FILESEL(obj)	GTK_CHECK_TYPE(obj, multi_filesel_get_type())

typedef struct _MultiFileSel MultiFileSel;
typedef struct _MultiFileSelClass MultiFileSelClass;

/** Multi File Selection object */
struct _MultiFileSel
{
  GtkFileSelection parent;	/* derived from GtkFileSelection widget */
  GtkWidget *button_box;	/* additonal button box under file list */
  GtkWidget *add_button;	/* "Add Selected Files" button */
};

/** Mult File Selection class */
struct _MultiFileSelClass
{
  GtkFileSelectionClass parent_class; /* parent class */
};

guint multi_filesel_get_type (void);
GtkWidget *multi_filesel_new (const char *title);
char *multi_filesel_get_path (MultiFileSel *multisel);
GList *multi_filesel_get_selected_files (MultiFileSel *multisel);

#endif
