/* ScummVM - Scumm Interpreter
 * Copyright (C) 2003-2004 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/sky/compacts/Attic/5compact.h,v 1.12 2004/01/06 12:45:32 fingolfin Exp $ 
 *
 */

#ifndef SKY5COMPACT_H
#define SKY5COMPACT_H


#include "14comp.h"
#include "9compact.h"
#include "18comp.h"
#include "12comp.h"
#include "13comp.h"
#include "15comp.h"
#include "16comp.h"
#include "17comp.h"


namespace Sky {

namespace SkyCompact {

Compact copter = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	8,	// screen
	0,	// place
	0,	// getToTable
	228,	// xcood
	208,	// ycood
	0,	// frame
	8252,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	MEGA_CLICK,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	389-228,	// mouseSize_x
	287-208,	// mouseSize_y
	COPTER_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 rs_joey_29_7[] = {
	C_XCOOD,
	256,
	C_YCOOD,
	232,
	C_SCREEN,
	7,
	C_PLACE,
	ID_S7_FLOOR,
	C_LOGIC,
	L_SCRIPT,
	C_BASE_SUB,
	JOEY_OUT_OF_LIFT7,
	C_BASE_SUB+2,
	0,
	65535
};

uint16 rs_joey_to_6[] = {
	C_XCOOD,
	208,
	C_YCOOD,
	256,
	C_PLACE,
	ID_S6_FLOOR,
	C_SCREEN,
	6,
	C_MODE,
	0,
	C_BASE_SUB,
	JOEY_LOGIC,
	C_BASE_SUB+2,
	0,
	C_STATUS,
	ST_SORT+ST_RECREATE+ST_LOGIC+ST_GRID_PLOT+ST_COLLISION+ST_MOUSE,
	C_DIR,
	RIGHT,
	65535
};

Compact lift_notice = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	238,	// xcood
	201,	// ycood
	0,	// frame
	8251,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	6,	// mouseSize_x
	8,	// mouseSize_y
	LIFT_NOTICE_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 mid_up_get[] = {
	153*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	5,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 jostair1_seq[] = {
	28*64,
	195,
	316,
	0,
	195,
	316,
	1,
	195,
	316,
	2,
	195,
	315,
	3,
	195,
	314,
	4,
	195,
	314,
	5,
	195,
	314,
	6,
	195,
	314,
	7,
	195,
	314,
	8,
	195,
	314,
	9,
	195,
	314,
	10,
	195,
	314,
	11,
	195,
	314,
	12,
	196,
	314,
	13,
	197,
	314,
	14,
	198,
	314,
	15,
	199,
	314,
	16,
	200,
	314,
	17,
	201,
	314,
	18,
	202,
	314,
	19,
	203,
	314,
	12,
	204,
	314,
	13,
	205,
	314,
	14,
	206,
	314,
	15,
	207,
	314,
	16,
	208,
	314,
	17,
	209,
	314,
	18,
	210,
	314,
	19,
	211,
	314,
	20,
	212,
	314,
	21,
	213,
	314,
	22,
	214,
	315,
	23,
	215,
	316,
	24,
	216,
	316,
	25,
	217,
	316,
	26,
	218,
	316,
	27,
	219,
	316,
	28,
	220,
	316,
	29,
	221,
	316,
	30,
	222,
	316,
	31,
	223,
	316,
	32,
	224,
	316,
	33,
	0
};

uint16 grd_watch_seq[] = {
	115*64,
	306,
	228,
	0,
	306,
	228,
	0,
	306,
	228,
	1,
	306,
	228,
	1,
	306,
	228,
	2,
	306,
	228,
	2,
	306,
	228,
	3,
	306,
	228,
	3,
	306,
	228,
	4,
	306,
	228,
	4,
	306,
	228,
	5,
	306,
	228,
	5,
	306,
	228,
	6,
	306,
	228,
	6,
	306,
	228,
	7,
	306,
	228,
	7,
	306,
	228,
	7,
	306,
	228,
	7,
	306,
	228,
	5,
	306,
	228,
	5,
	306,
	228,
	4,
	306,
	228,
	4,
	306,
	228,
	3,
	306,
	228,
	3,
	306,
	228,
	2,
	306,
	228,
	2,
	306,
	228,
	1,
	306,
	228,
	1,
	306,
	228,
	0,
	306,
	228,
	0,
	306,
	228,
	0,
	306,
	228,
	0,
	0
};

uint32 *grid18 = 0;

uint16 s7_floor_table[] = {
	ID_S7_FLOOR,
	RET_OK,
	ID_JOEY_PARK,
	GET_TO_JP2,
	0,
	S7_WALK_ON,
	1,
	S7_RIGHT_ON,
	3,
	S12_WALK_ON,
	ID_LEFT_EXIT_S7,
	GET_TO_L_EXIT_S7,
	ID_S7_RIGHT_EXIT,
	GET_TO_R_EXIT_S7,
	ID_FACTORY_ENTRY,
	GET_TO_FACTORY,
	ID_S7_CARD_SLOT,
	GT_S7_SLOT,
	ID_LIFT_NOTICE,
	GT_LIFT_NOTICE,
	ID_LIFT_S7,
	GT_S7_LIFT,
	ID_LINC_S7,
	GT_S7_LINC,
	ID_STD_LEFT_TALK,
	GT_L_TALK_7,
	ID_STD_RIGHT_TALK,
	GT_R_TALK_7,
	ID_CABLE_7,
	GT_CABLE_7,
	65535
};

uint16 lamb_card_seq[] = {
	147*64,
	338,
	183,
	0,
	338,
	183,
	1,
	338,
	183,
	2,
	338,
	183,
	3,
	338,
	183,
	4,
	338,
	183,
	5,
	338,
	183,
	6,
	338,
	183,
	1,
	338,
	183,
	0,
	0
};

uint16 joey_list_s6[] = {
	176,
	384,
	272,
	287,
	1,
	0
};

uint16 s6_chip_list[] = {
	173,
	111,
	136+DISK_2,
	137+DISK_2,
	28+DISK_2,
	29+DISK_2,
	30+DISK_2,
	74+DISK_2,
	92+DISK_2,
	26+DISK_2+0X8000,
	27+DISK_2+0X8000,
	20+DISK_2,
	21+DISK_2,
	22+DISK_2,
	0
};

uint16 s6_pal[] = {
	0,
	512,
	0,
	516,
	1024,
	514,
	518,
	2050,
	516,
	1032,
	2564,
	1542,
	1548,
	2564,
	2056,
	1552,
	3588,
	1544,
	2064,
	3078,
	2570,
	2066,
	3076,
	3082,
	2070,
	4612,
	1546,
	2580,
	3590,
	3084,
	3088,
	4620,
	2060,
	2584,
	5636,
	2060,
	2588,
	4612,
	3598,
	3602,
	5136,
	3086,
	4114,
	7182,
	1548,
	4114,
	6672,
	2574,
	4116,
	8464,
	1548,
	3612,
	7176,
	2574,
	4122,
	8972,
	1550,
	4630,
	9490,
	1550,
	4632,
	7186,
	3602,
	4133,
	6662,
	4116,
	5146,
	5650,
	5142,
	4641,
	9484,
	3088,
	4641,
	7182,
	5140,
	4135,
	6156,
	5656,
	5658,
	8984,
	3604,
	5665,
	10514,
	2580,
	5163,
	6666,
	6170,
	5669,
	10002,
	4118,
	6179,
	8466,
	5658,
	5677,
	8462,
	6682,
	6185,
	8976,
	6170,
	6187,
	10002,
	5148,
	7207,
	11030,
	5146,
	7205,
	8476,
	7201,
	7215,
	10002,
	7198,
	8997,
	11030,
	5665,
	7727,
	10004,
	6179,
	8491,
	13082,
	5150,
	8493,
	10520,
	7715,
	9509,
	10529,
	8483,
	9515,
	12570,
	6179,
	10029,
	11548,
	8997,
	9525,
	12056,
	7719,
	11051,
	14625,
	5671,
	11057,
	13084,
	5677,
	11057,
	13601,
	7721,
	11569,
	15134,
	6185,
	11065,
	13084,
	9517,
	12085,
	14108,
	8493,
	12085,
	12577,
	10543,
	11581,
	13594,
	7729,
	13111,
	15640,
	5681,
	12597,
	15655,
	7729,
	12599,
	14635,
	9011,
	13117,
	15644,
	9523,
	14139,
	15646,
	10035,
	14143,
	15128,
	11571,
	14139,
	15655,
	11573,
	14143,
	16163,
	12087,
	14651,
	16177,
	10553,
	15167,
	16167,
	9533,
	15679,
	16177,
	14143,
	4126,
	6155,
	2317,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	11267,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	63,
	0,
	0,
	0,
	0,
	0,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint16 rs_foster_8_7[] = {
	C_XCOOD,
	456,
	C_YCOOD,
	264,
	C_SCREEN,
	7,
	C_PLACE,
	ID_S7_FLOOR,
	C_DIR,
	LEFT,
	C_FRAME,
	12*64,
	65535
};

Compact joey_fly_6 = {
	L_SCRIPT,	// logic
	0,	// status
	0,	// sync
	6,	// screen
	0,	// place
	0,	// getToTable
	0,	// xcood
	0,	// ycood
	209*64,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	0,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	0,	// mouseSize_x
	0,	// mouseSize_y
	0,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	JOEY_FLY_TO_6,	// baseSub
	0,	// baseSub_off
	0
};

uint16 s7_chip_list[] = {
	173,
	111,
	133+DISK_2,
	136+DISK_2,
	137+DISK_2,
	131+DISK_2,
	132+DISK_2,
	145+DISK_2,
	31+DISK_2,
	32+DISK_2,
	43+DISK_2,
	147+DISK_2,
	148+DISK_2,
	0
};

uint16 s8_logic[] = {
	ID_FOSTER,
	ID_JOEY,
	ID_WRECK_GUARD,
	ID_CABLE_7,
	0XFFFF,
	ID_MENU_LOGIC
};

uint16 s7_lift_open[] = {
	134*64,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	4,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	12,
	0
};

uint16 skorl_anim[] = {
	113*64,
	1,
	1,
	5,
	1,
	1,
	6,
	1,
	1,
	7,
	1,
	1,
	8,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	13,
	1,
	1,
	14,
	1,
	1,
	15,
	1,
	1,
	14,
	1,
	1,
	13,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	8,
	1,
	1,
	4,
	0
};

uint16 card_slot_anim[] = {
	133*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 dwn_stair1_seq[] = {
	26*64,
	206,
	192,
	0,
	207,
	194,
	1,
	207,
	197,
	2,
	208,
	200,
	3,
	209,
	202,
	4,
	210,
	203,
	5,
	210,
	205,
	6,
	211,
	208,
	7,
	212,
	210,
	8,
	212,
	212,
	9,
	213,
	213,
	10,
	214,
	214,
	11,
	214,
	217,
	12,
	215,
	219,
	13,
	215,
	221,
	14,
	216,
	221,
	15,
	217,
	223,
	16,
	216,
	226,
	17,
	217,
	227,
	18,
	217,
	229,
	19,
	218,
	229,
	20,
	218,
	231,
	21,
	224,
	233,
	22,
	225,
	235,
	23,
	226,
	236,
	24,
	226,
	237,
	25,
	227,
	238,
	26,
	0
};

Compact s7_floor = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	s7_floor_table,	// getToTable
	128,	// xcood
	241,	// ycood
	0,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	320,	// mouseSize_x
	63,	// mouseSize_y
	FLOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 rs_foster_9_6[] = {
	C_XCOOD,
	368,
	C_YCOOD,
	232,
	C_SCREEN,
	6,
	C_PLACE,
	ID_S6_FLOOR,
	65535
};

uint16 s6_mouse[] = {
	ID_JOEY,
	ID_S6_STAIRS,
	ID_LEFT_EXIT_S6,
	ID_RIGHT_EXIT_S6,
	ID_SECURITY_EXIT,
	ID_MONITOR,
	ID_S6_FLOOR,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint16 rs_foster_to_5[] = {
	C_XCOOD,
	456,
	C_SCREEN,
	5,
	C_PLACE,
	ID_S5_FLOOR,
	65535
};

uint16 s8_chip_list[] = {
	130+DISK_2,
	13,
	114+DISK_2,
	0
};

uint16 weld_7_seq[] = {
	149*64,
	369,
	148,
	0,
	369,
	148,
	1,
	369,
	148,
	2,
	369,
	148,
	3,
	369,
	148,
	4,
	369,
	148,
	5,
	369,
	148,
	6,
	369,
	148,
	7,
	0
};

uint16 grd_blink_seq[] = {
	129*64,
	379,
	228,
	0,
	379,
	228,
	0,
	379,
	228,
	1,
	379,
	228,
	1,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	1,
	379,
	228,
	1,
	379,
	228,
	0,
	379,
	228,
	0,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	0,
	379,
	228,
	0,
	379,
	228,
	0,
	379,
	228,
	0,
	379,
	228,
	1,
	379,
	228,
	1,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	1,
	379,
	228,
	1,
	379,
	228,
	0,
	379,
	228,
	0,
	379,
	228,
	2,
	379,
	228,
	2,
	379,
	228,
	0,
	379,
	228,
	0,
	0
};

Compact down_exit_s8 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	8,	// screen
	0,	// place
	0,	// getToTable
	232,	// xcood
	319,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_DOWN_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	338-232,	// mouseSize_x
	42,	// mouseSize_y
	ED8_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 jostair3_seq[] = {
	30*64,
	192,
	230,
	0,
	192,
	230,
	1,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	1,
	192,
	230,
	4,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	1,
	192,
	230,
	4,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	1,
	192,
	230,
	4,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	1,
	192,
	230,
	4,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	1,
	192,
	230,
	4,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	1,
	192,
	230,
	1,
	192,
	230,
	4,
	192,
	230,
	4,
	192,
	230,
	2,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	3,
	192,
	230,
	1,
	192,
	230,
	1,
	192,
	230,
	4,
	192,
	230,
	4,
	192,
	230,
	2,
	192,
	230,
	2,
	192,
	230,
	3,
	192,
	230,
	3,
	192,
	229,
	5,
	192,
	227,
	6,
	192,
	227,
	7,
	192,
	228,
	8,
	192,
	229,
	9,
	192,
	232,
	10,
	192,
	237,
	11,
	192,
	236,
	12,
	192,
	237,
	13,
	192,
	238,
	14,
	0
};

uint16 s5_chip_list[] = {
	173,
	111,
	136+DISK_2,
	137+DISK_2,
	115+DISK_2,
	116+DISK_2,
	129+DISK_2,
	74+DISK_2,
	92+DISK_2,
	14+DISK_2,
	15+DISK_2,
	16+DISK_2,
	0
};

Compact left_exit_s7 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	126,	// xcood
	136,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_LEFT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	11,	// mouseSize_x
	300,	// mouseSize_y
	EL7_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint32 *grid7 = 0;

uint16 rs_foster_18_5[] = {
	C_XCOOD,
	168,
	C_YCOOD,
	224,
	C_SCREEN,
	5,
	C_PLACE,
	ID_S5_FLOOR,
	65535
};

uint16 upstairs1_seq[] = {
	24*64,
	195,
	302,
	0,
	195,
	302,
	1,
	195,
	302,
	2,
	195,
	302,
	3,
	197,
	302,
	4,
	200,
	302,
	5,
	201,
	302,
	6,
	201,
	302,
	7,
	203,
	302,
	8,
	207,
	302,
	9,
	210,
	302,
	10,
	211,
	302,
	11,
	211,
	302,
	12,
	213,
	302,
	13,
	217,
	302,
	14,
	220,
	302,
	15,
	221,
	302,
	16,
	221,
	302,
	17,
	223,
	302,
	18,
	0
};

uint16 rs_foster_6_7[] = {
	C_XCOOD,
	120,
	C_YCOOD,
	280,
	C_SCREEN,
	7,
	C_PLACE,
	ID_S7_FLOOR,
	65535
};

Compact s7_card_slot = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	273,	// xcood
	200,	// ycood
	0,	// frame
	50,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	6,	// mouseSize_x
	10,	// mouseSize_y
	S7_SLOT_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 rs_joey_fly[] = {
	C_STATUS,
	ST_BACKGROUND+ST_LOGIC+ST_RECREATE,
	65535
};

uint16 s7_mouse[] = {
	ID_JOEY,
	ID_LEFT_EXIT_S7,
	ID_S7_RIGHT_EXIT,
	ID_FACTORY_ENTRY,
	ID_S7_CARD_SLOT,
	ID_LIFT_NOTICE,
	ID_LIFT_S7,
	ID_LINC_S7,
	ID_LAMB,
	ID_CABLE_7,
	ID_S7_FLOOR,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint16 s7_logic[] = {
	ID_FOSTER,
	ID_JOEY,
	ID_LAMB,
	ID_LIFT_S7,
	ID_LIFT7_LIGHT,
	ID_CABLE_7,
	ID_S6_JOEY_FLY,
	0XFFFF,
	ID_MENU_LOGIC
};

ExtCompact wreck_guard_ext = {
	0,	// actionSub
	0,	// actionSub_off
	0,	// getToSub
	0,	// getToSub_off
	0,	// extraSub
	0,	// extraSub_off
	DOWN,	// dir
	STD_MEGA_STOP,	// stopScript
	STD_MINI_BUMP,	// miniBump
	0,	// leaving
	0,	// atWatch
	0,	// atWas
	0,	// alt
	0,	// request
	96,	// spWidth_xx
	SP_COL_WRECK,	// spColour
	0,	// spTextId
	0,	// spTime
	0,	// arAnimIndex
	0,	// turnProg
	0,	// waitingFor
	0,	// arTarget_x
	0,	// arTarget_y
	0,	// animScratch
	0,	// megaSet
	0,
	0,
	0,
	0
};

Compact wreck_guard = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_RECREATE+ST_LOGIC+ST_MOUSE,	// status
	0,	// sync
	8,	// screen
	0,	// place
	0,	// getToTable
	304,	// xcood
	288,	// ycood
	130*64+32,	// frame
	38+T7,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65532,	// mouseRel_x
	(int16) 65516,	// mouseRel_y
	8,	// mouseSize_x
	28,	// mouseSize_y
	WRECK_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	0,	// mode
	WRECK_LOGIC,	// baseSub
	0,	// baseSub_off
	&wreck_guard_ext
};

uint16 rs_foster_5_6[] = {
	C_XCOOD,
	120,
	C_SCREEN,
	6,
	C_PLACE,
	ID_S6_FLOOR,
	65535
};

uint16 rs_foster_7_8[] = {
	C_XCOOD,
	292,
	C_YCOOD,
	324,
	C_SCREEN,
	8,
	C_PLACE,
	ID_S8_FLOOR,
	C_DIR,
	UP,
	C_FRAME,
	44+13*64,
	65535
};

uint16 upstairs2_seq[] = {
	25*64,
	227,
	239,
	0,
	226,
	237,
	1,
	226,
	236,
	2,
	225,
	235,
	3,
	225,
	234,
	4,
	218,
	232,
	5,
	218,
	230,
	6,
	217,
	228,
	7,
	217,
	228,
	8,
	216,
	226,
	9,
	216,
	225,
	10,
	216,
	222,
	11,
	215,
	220,
	12,
	215,
	220,
	13,
	214,
	218,
	14,
	214,
	216,
	15,
	213,
	213,
	16,
	212,
	211,
	17,
	212,
	210,
	18,
	211,
	209,
	19,
	210,
	207,
	20,
	210,
	204,
	21,
	209,
	201,
	22,
	208,
	200,
	23,
	207,
	198,
	24,
	207,
	196,
	25,
	206,
	199,
	26,
	206,
	200,
	27,
	206,
	198,
	28,
	0
};

Compact security_exit = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	5,	// screen
	0,	// place
	0,	// getToTable
	343,	// xcood
	171,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	6,	// mouseSize_x
	235-171,	// mouseSize_y
	SECURITY_EXIT_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 s6_logic[] = {
	ID_FOSTER,
	ID_SKORL_GUARD,
	ID_S6_JOEY_FLY,
	ID_JOEY,
	ID_MONITOR,
	ID_LAMB,
	ID_LIFT_S7,
	ID_LIFT7_LIGHT,
	ID_CABLE_7,
	0XFFFF,
	ID_MENU_LOGIC
};

Compact right_exit_s5 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	5,	// screen
	0,	// place
	0,	// getToTable
	447-11,	// xcood
	136,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	11,	// mouseSize_x
	300,	// mouseSize_y
	ER5_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact cable_7 = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_LOGIC+ST_RECREATE+ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	410,	// xcood
	225,	// ycood
	148*64,	// frame
	49,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	4,	// mouseSize_x
	260-225,	// mouseSize_y
	CABLE_7_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	CABLE_7_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 rs_foster_29_7[] = {
	C_XCOOD,
	256,
	C_YCOOD,
	224,
	C_SCREEN,
	7,
	C_PLACE,
	ID_S7_FLOOR,
	65535
};

uint16 s8_mouse[] = {
	ID_DOWN_EXIT_S8,
	ID_WRECK_GUARD,
	ID_COPTER,
	ID_S8_FLOOR,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint16 s8_pal[] = {
	0,
	3072,
	0,
	532,
	7170,
	3602,
	8226,
	7186,
	6682,
	8224,
	8222,
	3096,
	6688,
	7182,
	4630,
	8738,
	4626,
	518,
	4642,
	9994,
	7205,
	528,
	9472,
	1558,
	7712,
	8222,
	8224,
	7717,
	8728,
	5146,
	6174,
	7702,
	2576,
	5152,
	6666,
	2576,
	8745,
	7700,
	4630,
	7710,
	5658,
	1548,
	4114,
	11026,
	2588,
	7710,
	11026,
	3610,
	6680,
	11544,
	10031,
	8226,
	6684,
	3100,
	3082,
	7692,
	3090,
	6168,
	10008,
	7200,
	5152,
	9478,
	5658,
	6178,
	7188,
	6168,
	3084,
	1550,
	2056,
	6695,
	5138,
	5140,
	1558,
	8706,
	6170,
	4122,
	7176,
	7708,
	4624,
	6674,
	1040,
	6181,
	9992,
	2588,
	5669,
	11022,
	4638,
	2070,
	10500,
	2074,
	4628,
	530,
	0,
	5154,
	9998,
	1560,
	2066,
	8712,
	8224,
	5154,
	11532,
	11571,
	4114,
	1036,
	2566,
	11053,
	6690,
	3090,
	516,
	6656,
	1548,
	6174,
	9496,
	9509,
	4114,
	5642,
	2062,
	4634,
	8718,
	4116,
	7714,
	11550,
	10545,
	2064,
	9988,
	4636,
	4630,
	4626,
	5138,
	4645,
	8202,
	5142,
	3096,
	2570,
	2570,
	2570,
	3596,
	3596,
	5146,
	10002,
	10023,
	4128,
	10506,
	6178,
	10537,
	8233,
	4116,
	2584,
	3076,
	2,
	3614,
	7686,
	2574,
	1550,
	3586,
	1030,
	3594,
	3088,
	516,
	3088,
	4618,
	2570,
	4126,
	4104,
	1544,
	6181,
	4114,
	4112,
	11565,
	8226,
	2064,
	2582,
	8200,
	3088,
	1028,
	5638,
	5140,
	1544,
	6664,
	3088,
	5673,
	8720,
	8738,
	1026,
	6150,
	5142,
	5656,
	7190,
	1548,
	5654,
	5134,
	4112,
	5658,
	6168,
	1546,
	4632,
	11024,
	10537,
	1030,
	8196,
	6172,
	2062,
	7688,
	3088,
	4130,
	522,
	514,
	2066,
	7172,
	2062,
	1546,
	11014,
	7207,
	514,
	4,
	512,
	3088,
	2572,
	4,
	1046,
	2,
	1538,
	3098,
	3080,
	3082,
	5140,
	6678,
	6170,
	5150,
	11024,
	5669,
	2574,
	1544,
	514,
	1034,
	5634,
	3086,
	1032,
	6148,
	5140,
	4,
	10496,
	5148,
	2058,
	3592,
	4110,
	2056,
	9482,
	3604,
	2054,
	8202,
	2062,
	2074,
	11524,
	14131,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	16191,
	16128,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	11267,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	16191,
	16128,
	63,
	16191,
	16128,
	63,
	13887,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

Compact security_exit_s6 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	6,	// screen
	0,	// place
	0,	// getToTable
	346,	// xcood
	167,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	10,	// mouseSize_x
	230-167,	// mouseSize_y
	S6_DOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint32 *grid5 = 0;

uint16 jostair2_seq[] = {
	29*64,
	217,
	238,
	0,
	215,
	237,
	1,
	215,
	235,
	2,
	213,
	233,
	3,
	213,
	231,
	4,
	212,
	230,
	5,
	211,
	228,
	6,
	210,
	226,
	7,
	209,
	224,
	8,
	208,
	223,
	9,
	207,
	221,
	10,
	206,
	218,
	11,
	206,
	216,
	12,
	204,
	214,
	13,
	204,
	212,
	14,
	202,
	209,
	15,
	202,
	207,
	16,
	199,
	204,
	17,
	199,
	203,
	18,
	197,
	200,
	19,
	197,
	197,
	20,
	194,
	195,
	21,
	194,
	192,
	22,
	191,
	189,
	23,
	191,
	186,
	22,
	189,
	185,
	23,
	189,
	184,
	22,
	189,
	185,
	24,
	191,
	186,
	25,
	191,
	187,
	24,
	189,
	187,
	26,
	190,
	188,
	27,
	191,
	188,
	26,
	192,
	187,
	27,
	192,
	186,
	26,
	192,
	185,
	27,
	192,
	185,
	26,
	192,
	186,
	27,
	192,
	186,
	26,
	192,
	186,
	27,
	192,
	186,
	26,
	192,
	187,
	27,
	192,
	189,
	26,
	192,
	190,
	27,
	192,
	192,
	26,
	192,
	195,
	27,
	192,
	197,
	26,
	192,
	200,
	27,
	192,
	202,
	26,
	192,
	205,
	27,
	192,
	207,
	26,
	192,
	210,
	27,
	192,
	212,
	26,
	192,
	215,
	27,
	192,
	217,
	26,
	192,
	219,
	28,
	192,
	221,
	26,
	192,
	223,
	28,
	192,
	224,
	26,
	192,
	225,
	28,
	192,
	226,
	26,
	192,
	227,
	28,
	192,
	228,
	26,
	192,
	229,
	28,
	0
};

uint16 s6_floor_table[] = {
	ID_S6_FLOOR,
	RET_OK,
	ID_S6_STAIRS,
	GET_TO_STAIRS6,
	ID_JOEY_PARK,
	GET_TO_JP2,
	ID_LEFT_EXIT_S6,
	GET_TO_L_EXIT_S6,
	ID_RIGHT_EXIT_S6,
	GET_TO_R_EXIT_S6,
	ID_SECURITY_EXIT,
	GET_SECURITY_S6,
	0,
	S6_WALK_ON,
	1,
	S6_RWALK_ON,
	42,
	S6_SEC_WALK_ON,
	65535
};

Compact lift_s7 = {
	L_SCRIPT,	// logic
	ST_SORT+ST_LOGIC+ST_RECREATE+ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	0XF5,	// xcood
	0XB5,	// ycood
	134*64,	// frame
	45+T7,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	268-0XF5,	// mouseSize_x
	236-0XB5,	// mouseSize_y
	LIFT_S7_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	S7_LIFT_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

uint16 s5_mouse[] = {
	ID_JOEY,
	ID_MONITOR,
	ID_RIGHT_EXIT_S5,
	ID_LEFT_EXIT_S5,
	ID_SKORL_GUARD,
	S5_SECURITY_EXIT,
	ID_S5_FLOOR,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint16 s5_logic[] = {
	ID_FOSTER,
	ID_SKORL_GUARD,
	ID_JOEY,
	ID_MONITOR,
	ID_LAMB,
	ID_LIFT_S7,
	ID_LIFT7_LIGHT,
	ID_S6_JOEY_FLY,
	0XFFFF,
	ID_MENU_LOGIC
};

uint16 dwn_stair2_seq[] = {
	27*64,
	223,
	302,
	0,
	220,
	302,
	1,
	220,
	302,
	2,
	220,
	302,
	3,
	218,
	302,
	4,
	213,
	302,
	5,
	210,
	302,
	6,
	210,
	302,
	7,
	210,
	302,
	8,
	208,
	302,
	9,
	203,
	302,
	10,
	200,
	302,
	11,
	200,
	302,
	12,
	200,
	302,
	13,
	198,
	302,
	14,
	195,
	302,
	15,
	195,
	302,
	16,
	195,
	302,
	17,
	195,
	302,
	18,
	0
};

uint32 *grid9 = 0;

uint16 s8_fast_list[] = {
	12,
	51,
	52,
	53,
	54,
	135,
	0
};

Compact right_exit_s7 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	428,	// xcood
	175,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	30,	// mouseSize_x
	296-175,	// mouseSize_y
	ER7_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 s5_floor_table[] = {
	ID_S5_FLOOR,
	RET_OK,
	ID_JOEY_PARK,
	GET_TO_JP2,
	0,
	S5_WALK_ON,
	1,
	S5_STROLL_ON,
	ID_RIGHT_EXIT_S5,
	GET_TO_R_EXIT_S5,
	ID_LEFT_EXIT_S5,
	GET_TO_L_EXIT_S5,
	ID_SKORL_GUARD,
	GET_TO_SKORL,
	S5_SECURITY_EXIT,
	GET_TO_SECURITY_EXIT,
	65535
};

Compact s5_floor = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	5,	// screen
	0,	// place
	s5_floor_table,	// getToTable
	128,	// xcood
	224,	// ycood
	0,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	320,	// mouseSize_x
	63,	// mouseSize_y
	FLOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 s8_floor_table[] = {
	ID_S8_FLOOR,
	RET_OK,
	0,
	S8_WALK_ON,
	ID_WRECK_GUARD,
	GET_TO_WRECK,
	ID_DOWN_EXIT_S8,
	GET_TO_EXIT_S8,
	65535
};

uint16 lamblook_seq[] = {
	145*64,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	1,
	266,
	224,
	2,
	266,
	224,
	2,
	266,
	224,
	2,
	266,
	224,
	1,
	266,
	224,
	3,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	1,
	266,
	224,
	2,
	266,
	224,
	2,
	266,
	224,
	2,
	266,
	224,
	2,
	266,
	224,
	5,
	266,
	224,
	5,
	266,
	224,
	5,
	266,
	224,
	5,
	266,
	224,
	5,
	266,
	224,
	5,
	266,
	224,
	5,
	266,
	224,
	5,
	266,
	224,
	2,
	266,
	224,
	1,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	0,
	266,
	224,
	3,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	4,
	266,
	224,
	3,
	0
};

uint16 s5_pal[] = {
	0,
	512,
	0,
	516,
	1024,
	514,
	518,
	2050,
	516,
	1032,
	2564,
	1542,
	1548,
	2564,
	2056,
	1552,
	3588,
	1544,
	2064,
	3078,
	2570,
	2066,
	3076,
	3082,
	2070,
	4612,
	1546,
	2580,
	3590,
	3084,
	3088,
	4620,
	2060,
	2584,
	5636,
	2060,
	2588,
	4612,
	3598,
	3602,
	5136,
	3086,
	4114,
	7182,
	1548,
	4114,
	6672,
	2574,
	4116,
	8464,
	1548,
	3612,
	7176,
	2574,
	4122,
	8972,
	1550,
	4630,
	9490,
	1550,
	4632,
	7186,
	3602,
	4133,
	6662,
	4116,
	5146,
	5650,
	5142,
	4641,
	9484,
	3088,
	4641,
	7182,
	5140,
	4135,
	6156,
	5656,
	5658,
	8984,
	3604,
	5665,
	10514,
	2580,
	5163,
	6666,
	6170,
	5669,
	10002,
	4118,
	6179,
	8466,
	5658,
	5677,
	8462,
	6682,
	6185,
	8976,
	6170,
	6187,
	10002,
	5148,
	7207,
	11030,
	5146,
	7205,
	8476,
	7201,
	7215,
	10002,
	7198,
	8997,
	11030,
	5665,
	7727,
	10004,
	6179,
	8491,
	13082,
	5150,
	8493,
	10520,
	7715,
	9509,
	10529,
	8483,
	9515,
	12570,
	6179,
	10029,
	11548,
	8997,
	9525,
	12056,
	7719,
	11051,
	14625,
	5671,
	11057,
	13084,
	5677,
	11057,
	13601,
	7721,
	11569,
	15134,
	6185,
	11065,
	13084,
	9517,
	12085,
	14108,
	8493,
	12085,
	12577,
	10543,
	11581,
	13594,
	7729,
	13111,
	15640,
	5681,
	12597,
	15655,
	7729,
	12599,
	14635,
	9011,
	13117,
	15644,
	9523,
	14139,
	15646,
	10035,
	14143,
	15128,
	11571,
	14139,
	15655,
	11573,
	14143,
	16163,
	12087,
	14651,
	16177,
	10553,
	15167,
	16167,
	9533,
	15679,
	16177,
	14143,
	4126,
	6155,
	2317,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	11267,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	63,
	0,
	0,
	0,
	0,
	0,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint32 *z2 = (uint32*)data_2;

uint32 *grid6 = 0;

uint32 *grid8 = 0;

Compact left_exit_s5 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	5,	// screen
	0,	// place
	0,	// getToTable
	177,	// xcood
	172,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_LEFT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	189-177,	// mouseSize_x
	232-172,	// mouseSize_y
	LDOOR_5_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact right_exit_s6 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	6,	// screen
	0,	// place
	0,	// getToTable
	447-11,	// xcood
	136,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	11,	// mouseSize_x
	300,	// mouseSize_y
	ER6_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact s6_floor = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	6,	// screen
	0,	// place
	s6_floor_table,	// getToTable
	128,	// xcood
	216,	// ycood
	0,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	320,	// mouseSize_x
	71,	// mouseSize_y
	FLOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 rs_foster_to_6[] = {
	C_XCOOD,
	128,
	C_YCOOD,
	128,
	C_SCREEN,
	6,
	C_PLACE,
	ID_S6_FLOOR,
	C_FRAME,
	12*64,
	C_DIR,
	1,
	65535
};

uint16 use_linc_anim[] = {
	151*64,
	269,
	223,
	0,
	269,
	223,
	1,
	269,
	223,
	2,
	269,
	223,
	2,
	269,
	223,
	2,
	269,
	223,
	2,
	269,
	223,
	2,
	269,
	223,
	1,
	269,
	223,
	0,
	0
};

Compact stairs6 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	6,	// screen
	0,	// place
	0,	// getToTable
	201,	// xcood
	238,	// ycood
	0,	// frame
	37+T7,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	238-201,	// mouseSize_x
	246-238,	// mouseSize_y
	STAIR6_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 rs_foster_6_3[] = {
	C_XCOOD,
	424,
	C_YCOOD,
	280,
	C_SCREEN,
	3,
	C_PLACE,
	ID_S3_FLOOR,
	C_DIR,
	LEFT,
	C_FRAME,
	12*64,
	65535
};

Compact left_exit_s6 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	6,	// screen
	0,	// place
	0,	// getToTable
	126,	// xcood
	136,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_LEFT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	11,	// mouseSize_x
	300,	// mouseSize_y
	EL6_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 s7_pal[] = {
	0,
	512,
	0,
	516,
	1024,
	514,
	518,
	2050,
	516,
	1032,
	2564,
	1542,
	1548,
	2564,
	2056,
	1552,
	3588,
	1544,
	2064,
	3078,
	2570,
	2066,
	3076,
	3082,
	2070,
	4612,
	1546,
	2580,
	3590,
	3084,
	3088,
	4620,
	2060,
	2584,
	5636,
	2060,
	2588,
	4612,
	3598,
	3602,
	5136,
	3086,
	4114,
	7182,
	1548,
	4114,
	6672,
	2574,
	4116,
	8464,
	1548,
	3612,
	7176,
	2574,
	4122,
	8972,
	1550,
	4630,
	9490,
	1550,
	4632,
	7186,
	3602,
	4133,
	6662,
	4116,
	5146,
	5650,
	5142,
	4641,
	9484,
	3088,
	4641,
	7182,
	5140,
	4135,
	6156,
	5656,
	5658,
	8984,
	3604,
	5665,
	10514,
	2580,
	5163,
	6666,
	6170,
	5669,
	10002,
	4118,
	6179,
	8466,
	5658,
	5677,
	8462,
	6682,
	6185,
	8976,
	6170,
	6187,
	10002,
	5148,
	7207,
	11030,
	5146,
	7205,
	8476,
	7201,
	7215,
	10002,
	7198,
	8997,
	11030,
	5665,
	7727,
	10004,
	6179,
	8491,
	13082,
	5150,
	8493,
	10520,
	7715,
	9509,
	10529,
	8483,
	9515,
	12570,
	6179,
	10029,
	11548,
	8997,
	9525,
	12056,
	7719,
	11051,
	14625,
	5671,
	11057,
	13084,
	5677,
	11057,
	13601,
	7721,
	11569,
	15134,
	6185,
	11065,
	13084,
	9517,
	12085,
	14108,
	8493,
	12085,
	12577,
	10543,
	11581,
	13594,
	7729,
	13111,
	15640,
	5681,
	12597,
	15655,
	7729,
	12599,
	14635,
	9011,
	13117,
	15644,
	9523,
	14139,
	15646,
	10035,
	14143,
	15128,
	11571,
	14139,
	15655,
	11573,
	14143,
	16163,
	12087,
	14651,
	16177,
	10553,
	15167,
	16167,
	9533,
	15679,
	16177,
	14143,
	4126,
	6155,
	2317,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	14336,
	13364,
	11569,
	9261,
	8481,
	6687,
	6681,
	4626,
	2578,
	1803,
	770,
	519,
	13571,
	9517,
	9778,
	11805,
	5151,
	5926,
	8205,
	1808,
	2586,
	11267,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	8751,
	9506,
	10024,
	8242,
	10527,
	6174,
	5927,
	7698,
	3600,
	2325,
	2308,
	11573,
	12837,
	7462,
	7982,
	9748,
	3351,
	4128,
	6663,
	778,
	9533,
	13100,
	9244,
	5162,
	8476,
	5390,
	2072,
	3855,
	2308,
	2865,
	9995,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	63,
	0,
	0,
	0,
	0,
	0,
	13824,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint16 rs_foster_7_6[] = {
	C_XCOOD,
	456,
	C_YCOOD,
	256,
	C_SCREEN,
	6,
	C_PLACE,
	ID_S6_FLOOR,
	65535
};

ExtCompact skorl_guard_ext = {
	0,	// actionSub
	0,	// actionSub_off
	0,	// getToSub
	0,	// getToSub_off
	0,	// extraSub
	0,	// extraSub_off
	DOWN,	// dir
	STD_MEGA_STOP,	// stopScript
	STD_MINI_BUMP,	// miniBump
	0,	// leaving
	0,	// atWatch
	0,	// atWas
	0,	// alt
	0,	// request
	96,	// spWidth_xx
	SP_COL_SKORL,	// spColour
	0,	// spTextId
	0,	// spTime
	0,	// arAnimIndex
	0,	// turnProg
	0,	// waitingFor
	0,	// arTarget_x
	0,	// arTarget_y
	0,	// animScratch
	0,	// megaSet
	0,
	0,
	0,
	0
};

Compact skorl_guard = {
	L_SCRIPT,	// logic
	ST_BACKGROUND+ST_RECREATE+ST_LOGIC+ST_MOUSE,	// status
	0,	// sync
	5,	// screen
	0,	// place
	0,	// getToTable
	336,	// xcood
	224,	// ycood
	113*64+4,	// frame
	38+T7,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65520,	// mouseRel_x
	(int16) 65488,	// mouseRel_y
	32,	// mouseSize_x
	48,	// mouseSize_y
	SKORL_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	0,	// mode
	SKORL_LOGIC,	// baseSub
	0,	// baseSub_off
	&skorl_guard_ext
};

Compact s8_floor = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	8,	// screen
	0,	// place
	s8_floor_table,	// getToTable
	224,	// xcood
	311,	// ycood
	0,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	336-224,	// mouseSize_x
	32,	// mouseSize_y
	FLOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact factory_entry = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	356,	// xcood
	177,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	6,	// mouseSize_x
	240-177,	// mouseSize_y
	FACTORY_ENTRY_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 s7_lift_close[] = {
	134*64,
	1,
	1,
	11,
	1,
	1,
	10,
	1,
	1,
	9,
	1,
	1,
	8,
	1,
	1,
	7,
	1,
	1,
	6,
	1,
	1,
	5,
	1,
	1,
	4,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 linc_table[] = {
	ID_STD_RIGHT_TALK,
	GT_R_TALK_7,
	ID_S7_CARD_SLOT,
	GT_S7_SLOT,
	65535
};

Compact linc_s7 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	linc_table,	// getToTable
	295,	// xcood
	228,	// ycood
	0,	// frame
	51,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	316-295,	// mouseSize_x
	267-228,	// mouseSize_y
	LINC_S7_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact lift7_light = {
	L_SCRIPT,	// logic
	ST_RECREATE,	// status
	0,	// sync
	7,	// screen
	0,	// place
	0,	// getToTable
	0XFF,	// xcood
	0XAC,	// ycood
	146*64,	// frame
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 cable_cut_seq[] = {
	148*64,
	410,
	225,
	0,
	410,
	225,
	1,
	410,
	225,
	2,
	408,
	225,
	3,
	410,
	225,
	4,
	410,
	225,
	5,
	410,
	225,
	6,
	410,
	225,
	7,
	410,
	225,
	7,
	0
};

uint16 rs_foster_0_5[] = {
	C_XCOOD,
	360,
	C_YCOOD,
	224,
	C_SCREEN,
	5,
	C_PLACE,
	ID_S5_FLOOR,
	C_FRAME,
	42+12*64,
	C_MEGA_SET,
	1*NEXT_MEGA_SET,
	65535
};

uint16 lamb_talk_right[] = {
	132*64,
	131*64+46,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	9,
	1,
	1,
	9,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	10,
	1,
	1,
	11,
	1,
	1,
	12,
	1,
	1,
	12,
	1,
	1,
	9,
	0
};

void *data_2[] = {
	s5_logic,
	s5_mouse,
	0,
	s5_chip_list,
	s6_logic,
	s6_mouse,
	0,
	s6_chip_list,
	&s6_floor,
	upstairs1_seq,
	upstairs2_seq,
	rs_foster_to_6,
	&cable_7,
	&radman,
	0,
	0,
	use_linc_anim,
	&copter,
	&stairs6,
	&son,
	dwn_stair2_seq,
	rs_foster_6_3,
	rs_joey_fly,
	&joey_fly_6,
	jostair1_seq,
	jostair2_seq,
	jostair3_seq,
	rs_joey_to_6,
	joey_list_s6,
	&left_exit_s6,
	rs_foster_to_5,
	&s5_floor,
	&right_exit_s5,
	rs_foster_5_6,
	&right_exit_s6,
	s7_logic,
	s7_mouse,
	0,
	s7_chip_list,
	&s7_floor,
	s7_pal,
	rs_foster_6_7,
	&left_exit_s7,
	rs_foster_7_6,
	s5_pal,
	s6_pal,
	&left_exit_s5,
	s18_logic,
	s18_mouse,
	s18_fast_list,
	s18_chip_list,
	&s18_floor,
	s18_pal,
	rs_foster_to_18,
	&right_exit_s18,
	rs_foster_18_5,
	&security_exit_s6,
	s9_logic,
	s9_mouse,
	0,
	s9_chip_list,
	&s9_floor,
	s9_pal,
	rs_foster_to_9,
	&left_exit_s9,
	rs_foster_9_6,
	joey_list_s18,
	&steam,
	steam1_seq,
	steam2_seq,
	steam3_seq,
	steam4_seq,
	&power_door,
	door_blast_seq,
	&power_motor,
	power_stop_seq,
	power_start_seq,
	power_spin_seq,
	&socket,
	&power_switch,
	&power_chair,
	&left_skull,
	&right_skull,
	&power_bang,
	power_bang_seq,
	push_but_seq,
	unpush_but_seq,
	spanner_seq,
	high_push_seq,
	high_unpush_seq,
	blowoff_seq,
	0,
	sleep_seq,
	monhit_seq,
	joey_push_seq,
	joey_unpush_seq,
	steam_alert_seq,
	rs_gordon_start,
	&left_lever,
	&right_lever,
	&fans,
	fans_seq,
	0,
	&lobby_door,
	lobby_up_seq,
	lobby_down_seq,
	&scanner,
	&lobby_slot,
	card_in_seq,
	&dad,
	dad_work_seq,
	dad_work2_seq,
	dad_work3_seq,
	dwn_stair1_seq,
	son_work_seq,
	scan_seq,
	scandie_seq,
	&skorl_guard,
	&security_exit,
	skorl_anim,
	s8_logic,
	s8_mouse,
	s8_fast_list,
	s8_chip_list,
	&s8_floor,
	&right_exit_s7,
	s8_pal,
	rs_foster_7_8,
	&down_exit_s8,
	rs_foster_8_7,
	grd_watch_seq,
	grd_blink_seq,
	&wreck_guard,
	grid5,
	grid6,
	grid7,
	grid8,
	grid9,
	grid18,
	&factory_entry,
	s12_chip_list,
	s12_fast_list,
	grid12,
	s12_pal,
	&s12_floor,
	s12_mouse,
	s12_logic,
	rs_foster_7_12,
	joey_list_12,
	&factory_exit,
	rs_foster_12_7,
	rs_joey_start_12,
	&fact1_right_exit,
	s13_chip_list,
	s13_fast_list,
	grid13,
	s13_pal,
	&s13_floor,
	s13_mouse,
	s13_logic,
	rs_foster_12_13,
	&fact2_exit_left,
	rs_foster_13_12,
	&fact2_exit_right,
	s14_chip_list,
	s14_fast_list,
	grid14,
	s14_pal,
	&s14_floor,
	s14_mouse,
	s14_logic,
	rs_foster_13_14,
	&fact3_exit_left,
	rs_foster_14_13,
	&fact2_store_exit,
	s15_chip_list,
	s15_fast_list,
	grid15,
	s15_pal,
	&s15_flooor,
	s15_mouse,
	s15_logic,
	rs_foster_13_15,
	&store_exit,
	rs_foster_15_13,
	joey_list_15,
	anita_work_seq,
	&topbelt,
	topbelt_seq,
	&botbelt,
	botbelt_seq,
	&pipes,
	pipes_seq,
	&anita_spy,
	anita_turn_seq,
	anita_turn_back,
	&welder,
	welder_seq,
	factory_spanner_seq,
	0,
	anita_walk_seq,
	&cogs,
	cogs_seq,
	&gears,
	gears_seq,
	&belts1,
	belts1_seq,
	&belts2,
	belts2_seq,
	&pipe1,
	pipe1_seq,
	&pipe2,
	pipe2_seq,
	&pipe3,
	pipe3_seq,
	&pipe4,
	pipe4_seq,
	fost_cog_seq,
	&sensor,
	sensor_seq,
	&lite1,
	lite1_seq,
	&lite2,
	lite2_seq,
	0,
	foreman_work_seq,
	&fact2_spy_and_window,
	card_slot_anim,
	&s7_card_slot,
	&lift_notice,
	&lift_s7,
	s7_lift_open,
	s7_lift_close,
	&linc_s7,
	&junction_box,
	&whole_floor,
	s15_fake_mouse,
	swap1_seq,
	swap2_seq,
	swap3_seq,
	cant_lift_seq,
	s12_new_chip,
	weld_seq,
	&fact_console,
	fact_console_seq,
	fact_console_dead,
	&flap,
	flap_seq,
	flip_seq,
	&nu_floor,
	&skey,
	&wd40,
	shelf_get_seq,
	0,
	&floor_putty,
	rs_storeman,
	forfrisk_seq,
	armsup_seq,
	opencoat_seq,
	fsearch_seq,
	rs_foster,
	rs_foreman,
	closecoat,
	rs_joey_15_13,
	rs_anita_to_14,
	joey_list_14,
	0,
	&fact3_exit_right,
	&locker3,
	locker_open_seq,
	locker_close_seq,
	&locker2,
	&locker1,
	open_locker_seq,
	close_locker_seq,
	&machine,
	&stump,
	s16_chip_list,
	s16_fast_list,
	grid16,
	s16_pal,
	&s16_floor,
	s16_mouse,
	s16_logic,
	rs_foster_14_16,
	start_joey_14,
	&entrance_exit,
	rs_foster_16_14,
	&reactor_console,
	&reactor_door,
	&rad_screen,
	&console_14,
	&coat,
	change1_seq,
	change2_seq,
	change3_seq,
	change4_seq,
	change5_seq,
	change6_seq,
	nu_s13_chip,
	change_back1,
	change_back2,
	change_back3,
	change_back4,
	change_back5,
	change_back6,
	rad_open_locker,
	rad_close_locker,
	&sensors,
	nu_chip_18,
	&reactor_lower,
	s17_chip_list,
	s17_fast_list,
	grid17,
	s17_pal,
	&s17_floor,
	s17_mouse,
	s17_logic,
	rs_foster_16_17,
	&core_exit,
	rs_foster_17_16,
	&pulse,
	pulse_seq,
	&pulseb,
	pulseb_seq,
	&anita_card,
	get_putty_seq,
	lamblook_seq,
	fost_con_look,
	rad_con_look,
	get_card_seq,
	console_16_seq,
	&console_12,
	foster_die_seq,
	foster2_die_seq,
	foster_give_seq,
	anita_give_seq,
	&lift7_light,
	rs_foster_29_7,
	rs_joey_29_7,
	lamb_card_seq,
	weld_7_seq,
	cable_cut_seq,
	rs_foster_10_9,
	&fake_floor_9,
	rs_gordon_end,
	rs_foster_0_5,
	new_13_chip,
	rs_lamb_start_fact,
	0,
	lamb_talk_right,
	&linc_s9,
	&foreman
};

uint32 *table2 = (uint32*)data_2;

} // namespace SkyCompact

} // namespace Sky

#endif
