/* ScummVM - Scumm Interpreter
 * Copyright (C) 2004 The ScummVM project
 *
 * The ReInherit Engine is (C)2000-2003 by Daniel Balsom.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/saga/Attic/yslib.h,v 1.7 2004/07/31 12:37:36 khalek Exp $
 *
 */
#ifndef YSLIB_MAIN_H__
#define YSLIB_MAIN_H__

namespace Saga {

enum YS_ERROR_STATES {
	YS_E_SUCCESS = 0,
	YS_E_FAILURE,
	YS_E_MEM
};

enum YS_CONFIRM_STATES {
	YS_CONFIRM_NO = 0,
	YS_CONFIRM_YES,
	YS_CONFIRM_CANCEL
};

// General purpose quantity-comparison function
typedef int (YS_COMPARE_FUNC) (const void *, const void *);

// General-purpose utility macros 

//#define YS_ASSUME_2S_COMP

// Shared declarations for list modules
enum YS_WALK_DIRECTIONS {
	YS_WALK_BACKWARD = 0,
	YS_WALK_FORWARD
};

typedef struct ys_dl_node_tag YS_DL_NODE;
typedef struct ys_dl_node_tag YS_DL_LIST;

struct ys_dl_node_tag {
	void *data;
	struct ys_dl_node_tag *next;
	struct ys_dl_node_tag *prev;
};

YS_DL_LIST *ys_dll_create();
void ys_dll_destroy(YS_DL_LIST *);

void *ys_dll_get_data(YS_DL_NODE *);

YS_DL_NODE *ys_dll_head(YS_DL_LIST *);
YS_DL_NODE *ys_dll_tail(YS_DL_LIST *);
YS_DL_NODE *ys_dll_next(YS_DL_NODE *);
YS_DL_NODE *ys_dll_prev(YS_DL_NODE *);

YS_DL_NODE *ys_dll_add_head(YS_DL_LIST *, void *, size_t);
YS_DL_NODE *ys_dll_add_tail(YS_DL_LIST *, void *, size_t);

#define ys_dll_preinsert  ys_dll_add_tail
#define ys_dll_postinsert ys_dll_add_head

YS_DL_NODE *ys_dll_insert(YS_DL_LIST *, void *, size_t, YS_COMPARE_FUNC *);
int ys_dll_delete(YS_DL_NODE *);
void ys_dll_delete_all(YS_DL_LIST *);

YS_DL_NODE *ys_dll_replace(YS_DL_NODE *, void *, size_t);

int ys_dll_reorder_up(YS_DL_LIST *, YS_DL_NODE *, YS_COMPARE_FUNC *);
int ys_dll_reorder_down(YS_DL_LIST *, YS_DL_NODE *, YS_COMPARE_FUNC *);


} // End of namespace Saga

#endif
