/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "intincl.h"

/* This is formatted like the phone wants it
 * Needs to be converted according to the settings at time
 * of getting (e.g. charset in text).
 */
struct pbook_phone_entry {
  unsigned int slot;
  char* number;
  uint8_t numtype;
  char* text;
};
void struct_pbook_phone_entry_init (struct pbook_phone_entry* p);
void struct_pbook_phone_entry_delete (struct pbook_phone_entry* p);

/* return -1 on failure, else a slot number of the next empty slot
 */
int pbook_phone_find_empty (char* mem, int startslot);

/* The returned pointer is malloc'd, NULL-terminated list,
 * each list enty is malloc'd, too.
 */
struct pbook_phone_entry** pbook_phone_get (char* mem);
struct pbook_phone_entry** pbook_phone_get_range (char* mem,
						  unsigned int slot_min,
						  unsigned int slot_max,
						  int print_counter);

/* returns 1 on success, 0 on failure
 */
int pbook_phone_write (char* mem, struct pbook_phone_entry** entries);
int pbook_phone_write_entry (struct pbook_phone_entry* entry);
