
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RBUCKET_H__
#define __RBUCKET_H__

typedef struct _RBucketChunk__P RBucketChunk__P;

struct _RBucketChunk__P
{
    RBucketChunk__P *next;   
};


typedef struct _RBucket RBucket;

struct _RBucket
{
    RBucketChunk__P *buckets;
    RBucketChunk__P *tmpbucket;
    unsigned int size;
    RList *fills;
};

RBucket *
rbucket_new (unsigned int size);

void
rbucket_destroy (RBucket *bucket);

void
rbucket_empty (RBucket *bucket);

#define rbucket_alloc(bucket) (bucket->buckets ? \
                                (void *) bucket->tmpbucket = bucket->buckets, \
                                bucket->buckets = bucket->buckets->next, \
                                bucket->tmpbucket :  \
                                rbucket_fill__P(bucket))

#define rbucket_alloc0(bucket) (bucket->buckets ? \
                                (void *) bucket->tmpbucket = bucket->buckets, \
                                bucket->buckets = bucket->buckets->next, \
                                memset (bucket->tmpbucket, 0, bucket->size), \
                                bucket->tmpbucket :  \
                                rbucket_fill0__P(bucket))

#define rbucket_free(bucket, mem)  (bucket->tmpbucket = bucket->buckets, \
                                    bucket->buckets = (RBucketChunk__P *) mem, \
                                    bucket->buckets->next = bucket->tmpbucket)

void *
rbucket_fill__P (RBucket *bucket);

void *
rbucket_fill0__P (RBucket *bucket);



#endif /* __RBUCKET_H__ */


