#ifndef _weaponobject_h_
#define _weaponobject_h_

#include "allegro.h"
#include <vector>
#include "spaceobj.h"

using namespace std;

class WeaponObject{
public:

	//basic constructor
	WeaponObject( int direction, const char * name, int _worth, int _alignment, int _strength, int _max_strength );

	//Draw
	//process: draws onto bitmap (unused)
	virtual void Draw(BITMAP * less, int x, int y);

	//MakeShot
	//process: shoots a bullet, able to use enemy as target
	virtual void MakeShot(int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight );

	//if we dont shoot, we idle. yay!
	virtual void Idle( int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight );

	// increase strength by q, cannot excede max_power
	virtual void IncreasePower( int q );
	virtual int getPower();

	//return the name of this gun
	virtual const char * GetName() const;

	//how much the gun costs
	virtual int Worth();

	//returns the maximum strength of the gun
	virtual int maxPower();

	//returns a copy of this object
	virtual WeaponObject * copy();

	//destructor
	virtual ~WeaponObject();

	int shot_counter;	//how much time till next shot
	int strength;		//how strong this gun is
	int max_strength;	//how strong this gun can possibly be
	int dir;		//direction to shoot in, -1 or 1
	int gun_type;		//useless gun type number
	int worth;		//how much the gun is worth
	const char * gun_name;	//name of gun
	int alignment;		//which grouping gun makes bullets for
	SAMPLE * smp;		//played during Makeshot or Idle

};

#endif
