/***************************************
  $Header: /home/amb/procmeter/RCS/procmeter.h 2.17 1999/02/24 19:51:29 amb Exp $

  ProcMeter - A performance metering/logging program for Linux - Version 2.5.1.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1994,95,96,97,98,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef PROCMETER_H
#define PROCMETER_H    /*+ To stop multiple inclusions. +*/

#include <sys/types.h>

typedef enum { CPU,
               CPU_USER,
               CPU_NICE,
               CPU_SYS,
               CPU_IDLE,
               LOAD,
               PROC,
               FORK,
               CONTEXT,
               SWAP,
               SWAP_IN,
               SWAP_OUT,
               PAGE,
               PAGE_IN,
               PAGE_OUT,
               DISK,
               DISK_RD,
               DISK_WR,
               INTR,
               MEM_FREE,
               MEM_USED,
               MEM_BUFF,
               MEM_CACHE,
               MEM_AVAIL,
               MEM_SWAP,
               LPKT,
               LBYTE,
               FPKT,
               FBYTE,
               FPKT_RX,
               FBYTE_RX,
               FPKT_TX,
               FBYTE_TX,
               FPKT_COLL,
               SPKT,
               SBYTE,
               SPKT_RX,
               SBYTE_RX,
               SPKT_TX,
               SBYTE_TX,
               BATT_LIFE,
               BATT_LVL,
               NProcStats
              } ProcStatistics;

typedef struct _Statistics
{
 char   name[16];               /*+ The name of the statistic. +*/
 char   *file;                  /*+ The name of the file to get the statistics from. +*/
 char   units[8];               /*+ The name of the units. +*/
 char   avail;                  /*+ A true value if the statistic is available. +*/
 long   scale;                  /*+ The scaling factor to apply. +*/
 char   used;                   /*+ True if this statistic is being used. +*/
 double value;                  /*+ The current value of this statistic. +*/
}
Statistics;

extern Statistics ProcStats[NProcStats];
extern Statistics *OtherStats;

extern long NOtherStats;

/* In statistics.c */

void VerifyProcStatistics(void);
void VerifyOtherStatistics(char *filename);
void GetStatistics(void);
double CurrentValue(int type);

/* In xwindow.c */

void StartX(int *argc,char **argv);
void StopX(void);
void UpdateMetersX(void);
void AddRemoveMeterX(int type);
void SleepX(time_t until);

/* In log.c */

void StartLog(void);
void StopLog(void);
void UpdateMetersLog(time_t now);
void AddRemoveMeterLog(int type);
void SleepNotX(time_t until);

#endif /* PROCMETER_H */
