--TEST--
maxdb bind_result 1 
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
	$rc = maxdb_query($link,"DROP TABLE test_fetch_null");
        maxdb_report (MAXDB_REPORT_ERROR);

  	$rc = maxdb_query($link,"CREATE TABLE test_fetch_null(col1 integer, col2 smallint,
                                                       col3 integer, col4 fixed(20), 
                                                       col5 float, col6 fixed(10,4),
                                                       col7 date, col8 time, 
                                                       col9 varchar(10) byte, 
                                                       col10 varchar(50),
                                                       col11 char(20))");
  
	$rc = maxdb_query($link,"INSERT INTO test_fetch_null(col1,col10, col11) VALUES(1,'foo1', 1000)");
$rc = maxdb_query($link,"INSERT INTO test_fetch_null(col1,col10, col11) VALUES(2,'foo2', 88)");
$rc = maxdb_query($link,"INSERT INTO test_fetch_null(col1,col10, col11) VALUES(3,'foo3', 389789)");

	$stmt = maxdb_prepare($link, "SELECT col1, col2, col3, col4, col5, col6, col7, col8, col9, col10, col11 from test_fetch_null");
	maxdb_bind_result($stmt, $c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, $c9, $c10, $c11); 
	maxdb_execute($stmt);

	maxdb_fetch($stmt);

	$test = array($c1,$c2,$c3,$c4,$c5,$c6,$c7,$c8,$c9,$c10,$c11);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(11) {
  [0]=>
  int(1)
  [1]=>
  NULL
  [2]=>
  NULL
  [3]=>
  NULL
  [4]=>
  NULL
  [5]=>
  NULL
  [6]=>
  NULL
  [7]=>
  NULL
  [8]=>
  NULL
  [9]=>
  string(4) "foo1"
  [10]=>
  string(4) "1000"
}
