/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.lang.reflect.Method;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.View;
import org.javagroups.blocks.MethodCall;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.log.Trace;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RpcDispatcherSpeedTest
implements MembershipListener {
    static final int OLD = 1;
    static final int METHOD = 2;
    static final int TYPES = 3;
    static final int SIGNATURE = 4;
    static final long TIMEOUT = 10000L;
    static final Class LONG_CLASS = Long.TYPE;
    static final String LONG = Long.TYPE.getName();
    Channel channel;
    RpcDispatcher disp;
    String props;
    boolean server;
    int num;
    int mode;

    public long measure(long start_time) throws Exception {
        return System.currentTimeMillis() - start_time;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, (Object)this);
        this.channel.connect("RpcDispatcherSpeedTestGroup");
        try {
            try {
                if (this.server) {
                    System.out.println("-- Started as server. Press ctrl-c to kill");
                    while (true) {
                        Util.sleep(10000L);
                    }
                }
                this.invokeRpcs(this.num, this.mode);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            System.out.println("Closing channel");
            this.channel.close();
            System.out.println("Closing channel: -- done");
            System.out.println("Stopping dispatcher");
            this.disp.stop();
            System.out.println("Stopping dispatcher: -- done");
            throw throwable;
        }
        {
            Object var2_4 = null;
            System.out.println("Closing channel");
            this.channel.close();
            System.out.println("Closing channel: -- done");
            System.out.println("Stopping dispatcher");
        }
        this.disp.stop();
        System.out.println("Stopping dispatcher: -- done");
    }

    void invokeRpcs(int num, int mode) throws Exception {
        long total_time = 0L;
        int show = num / 10;
        if (show <= 0) {
            show = 1;
        }
        switch (mode) {
            case 1: {
                System.out.println("-- invoking " + num + " methods using mode=OLD");
                int i = 1;
                while (i <= num) {
                    Long start_time = new Long(System.currentTimeMillis());
                    RspList rsp_list = this.disp.callRemoteMethods(null, "measure", start_time, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show == 0) {
                        System.out.println(i);
                    }
                    ++i;
                }
                this.printStats(total_time, num);
                break;
            }
            case 2: {
                System.out.println("-- invoking " + num + " methods using mode=METHOD");
                Method method = this.getClass().getMethod("measure", Long.TYPE);
                int i = 1;
                while (i <= num) {
                    Long start_time = new Long(System.currentTimeMillis());
                    MethodCall method_call = new MethodCall(method, new Object[]{start_time});
                    RspList rsp_list = this.disp.callRemoteMethods(null, method_call, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show == 0) {
                        System.out.println(i);
                    }
                    ++i;
                }
                this.printStats(total_time, num);
                break;
            }
            case 3: {
                System.out.println("-- invoking " + num + " methods using mode=TYPES");
                int i = 1;
                while (i <= num) {
                    Long start_time = new Long(System.currentTimeMillis());
                    RspList rsp_list = this.disp.callRemoteMethods((Vector)null, "measure", new Object[]{start_time}, new Class[]{LONG_CLASS}, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show == 0) {
                        System.out.println(i);
                    }
                    ++i;
                }
                this.printStats(total_time, num);
                break;
            }
            case 4: {
                System.out.println("-- invoking " + num + " methods using mode=SIGNATURE");
                int i = 1;
                while (i <= num) {
                    Long start_time = new Long(System.currentTimeMillis());
                    RspList rsp_list = this.disp.callRemoteMethods((Vector)null, "measure", new Object[]{start_time}, new String[]{LONG}, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show == 0) {
                        System.out.println(i);
                    }
                    ++i;
                }
                this.printStats(total_time, num);
                break;
            }
        }
    }

    double getAverage(RspList rsps) {
        double retval = 0.0;
        int num = 0;
        if (rsps == null || rsps.size() == 0) {
            System.err.println("response list is empty");
            return 0.0;
        }
        int i = 0;
        while (i < rsps.size()) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            if (rsp.getValue() != null && rsp.getValue() instanceof Long) {
                retval += (double)((Long)rsp.getValue()).longValue();
                ++num;
            } else {
                System.err.println("response " + rsp.getValue() + " invalid");
            }
            ++i;
        }
        return retval / (double)num;
    }

    void printStats(long total_time, int num) {
        System.out.println("total_time for " + num + " remote calls was " + total_time + ", avg=" + (double)total_time / (double)num + "ms/invocation");
    }

    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String props = null;
        boolean server = false;
        int num = 1000;
        int mode = 1;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-props")) {
                props = args[++i];
            } else if (args[i].equals("-server")) {
                server = true;
            } else if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
            } else {
                String m;
                if (!args[i].equals("-mode")) {
                    RpcDispatcherSpeedTest.help();
                    return;
                }
                if ((m = args[++i].toLowerCase().trim()).equals("old")) {
                    mode = 1;
                } else if (m.equals("method")) {
                    mode = 2;
                } else if (m.equals("types")) {
                    mode = 3;
                } else {
                    if (!m.equals("signature")) {
                        System.err.println("mode " + m + " is invalid");
                        RpcDispatcherSpeedTest.help();
                        return;
                    }
                    mode = 4;
                }
            }
            ++i;
        }
        Trace.init();
        try {
            RpcDispatcherSpeedTest test = new RpcDispatcherSpeedTest(props, server, num, mode);
            test.start();
            return;
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherSpeedTest [-help] [-props <props>] [-server] [-num <number of calls>] [-mode <mode>]");
        System.out.println("mode can be either 'old', 'method', 'types' or 'signature'");
    }

    private final /* synthetic */ void this() {
        this.props = null;
        this.server = false;
        this.num = 1000;
        this.mode = 1;
    }

    public RpcDispatcherSpeedTest(String props, boolean server, int num, int mode) {
        this.this();
        this.props = props;
        this.server = server;
        this.num = num;
        this.mode = mode;
    }
}

