/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.Event;
import org.javagroups.JChannel;
import org.javagroups.UpHandler;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingRsp;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ping
implements UpHandler {
    Channel channel;
    boolean print_all_events;

    public void go(String groupname) {
        try {
            this.channel.connect(groupname);
            Trace.setIdentifier(this.channel.getLocalAddress().toString());
            this.channel.down(new Event(12));
        }
        catch (Exception e) {
            System.err.println("Ping.go(): " + e);
            System.exit(1);
        }
    }

    public void up(Event evt) {
        if (evt.getType() == 13) {
            Vector v = (Vector)evt.getArg();
            System.out.println("Found " + v.size() + " members");
            int i = 0;
            while (i < v.size()) {
                PingRsp rsp = (PingRsp)v.elementAt(i);
                System.out.println("Rsp #" + (i + 1) + ": " + rsp);
                ++i;
            }
            if (v.size() > 0) {
                Ping.verifyCoordinator(v);
            }
            System.exit(1);
        } else if (this.print_all_events) {
            System.out.println(">> " + evt);
        }
    }

    static void verifyCoordinator(Vector rsps) {
        Hashtable votes = new Hashtable();
        int i = 0;
        while (i < rsps.size()) {
            PingRsp rsp = (PingRsp)rsps.elementAt(i);
            Address coord = rsp.getCoordAddress();
            Address mbr = rsp.getAddress();
            Vector<Address> v = (Vector<Address>)votes.get(coord);
            if (v == null) {
                v = new Vector<Address>();
                votes.put(coord, v);
            }
            if (!v.contains(mbr)) {
                v.addElement(mbr);
            }
            ++i;
        }
        System.out.println("");
        if (votes.size() > 1) {
            System.err.println("*** Found more than 1 coordinator !");
        }
        Ping.printVotes(votes);
    }

    static void printVotes(Hashtable votes) {
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Vector val = (Vector)votes.get(key);
            System.out.println("\n\nCoord: " + key);
            System.out.println("Votes: " + val + '\n');
        }
    }

    public static void main(String[] args) {
        Ping ping = null;
        boolean trace = false;
        String groupname = Util.shortName(Util.getHostname());
        boolean printall = false;
        String props = "UDP(mcast_addr=224.0.0.200;mcast_port=7500;ip_ttl=0;ucast_send_buf_size=30000;ucast_recv_buf_size=60000):PING(timeout=5000;num_initial_members=30)";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                Ping.usage();
                return;
            }
            if (args[i].equals("-trace")) {
                trace = true;
            } else if (args[i].equals("-printall")) {
                printall = true;
            } else if (args[i].equals("-group")) {
                groupname = args[++i];
            } else if (args[i].equals("-props")) {
                props = args[++i];
            } else {
                Ping.usage();
                return;
            }
            ++i;
        }
        try {
            ping = new Ping(props, trace, printall);
            ping.go(groupname);
        }
        catch (Exception e) {
            System.err.println("Ping.main(): " + e);
            System.exit(0);
        }
    }

    static void usage() {
        System.out.println("Ping [-help] [-trace] [-group <groupname>] [-props <properties>] [-printall]");
    }

    private final /* synthetic */ void this() {
        this.channel = null;
        this.print_all_events = false;
    }

    public Ping(String props, boolean trace, boolean printall) throws Exception {
        this.this();
        this.print_all_events = printall;
        if (trace) {
            Trace.init();
        }
        this.channel = new JChannel(props);
        this.channel.setUpHandler(this);
    }
}

