/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.ArrayList;
import java.util.Vector;
import mlsub.typing.AtomicKind;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Interface;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Unsatisfiable;

public final class Variance
implements AtomicKind {
    private int[] signs;
    private static final ArrayList variances = new ArrayList(64);
    private static Variance empty = Variance.make(new int[0]);
    private Vector interfaces = new Vector(10);
    private int size;
    public static final int COVARIANT = 1;
    public static final int CONTRAVARIANT = -1;
    public static final int INVARIANT = 0;

    private Variance(int[] signs) {
        this.size = signs.length;
        this.signs = signs;
    }

    public static final Variance make(int[] signs) {
        int encoding = Variance.encoding(signs);
        Variance res = Variance.get(encoding);
        if (res == null) {
            return Variance.set(encoding, new Variance(signs));
        }
        return res;
    }

    public int getVariance(int rank) {
        return this.signs[rank];
    }

    private static int encoding(int[] signs) {
        int res = 0;
        int base = 1;
        for (int i = 0; i < signs.length; ++i) {
            res += (signs[i] + 2) * base;
            base *= 4;
        }
        return res;
    }

    private static Variance get(int index) {
        if (index >= variances.size()) {
            return null;
        }
        return (Variance)variances.get(index);
    }

    private static Variance set(int index, Variance v) {
        while (index >= variances.size()) {
            variances.add(null);
        }
        variances.set(index, v);
        return v;
    }

    public static Variance empty() {
        return empty;
    }

    public Engine.Constraint getConstraint() {
        return Engine.getConstraint(this);
    }

    public Monotype freshMonotype(boolean existential) {
        TypeConstructor tc = new TypeConstructor(this);
        Typing.introduce(tc);
        Element[] tp = MonotypeVar.news(this.size, existential);
        Typing.introduce(tp);
        return new MonotypeConstructor(tc, (Monotype[])tp);
    }

    public void register(Element e) {
    }

    int newInterface(Interface i) {
        int res = this.getConstraint().newInterface();
        if (res >= this.interfaces.size()) {
            this.interfaces.setSize(res + 1);
        }
        this.interfaces.set(res, i);
        return res;
    }

    public Interface getInterface(int iid) {
        return (Interface)this.interfaces.get(iid);
    }

    void subInterface(int i1, int i2) {
        this.getConstraint().subInterface(i1, i2);
    }

    void initialImplements(int x, int iid) {
        this.getConstraint().initialImplements(x, iid);
    }

    void initialAbstracts(int x, int iid) {
        this.getConstraint().initialAbstracts(x, iid);
    }

    void indexImplements(int x, int iid) throws Unsatisfiable {
        this.getConstraint().indexImplements(x, iid);
    }

    public void leq(Element e1, Element e2, boolean initial) throws Unsatisfiable {
        if (initial) {
            throw new InternalError("initial leq in Variance");
        }
        this.leq(e1, e2);
    }

    public void leq(Element e1, Element e2) throws Unsatisfiable {
        MonotypeConstructor m1 = this.mc(e1);
        MonotypeConstructor m2 = this.mc(e2);
        Engine.leq(m1.getTC(), m2.getTC());
        this.assertEq(m1.getTP(), m2.getTP());
    }

    private MonotypeConstructor mc(Element e) {
        try {
            return (MonotypeConstructor)((Monotype)e).equivalent();
        }
        catch (ClassCastException ex) {
            throw new InternalError(e + " was expected to be a monotype constructor, " + " it's a " + e.getClass());
        }
    }

    public void assertEq(Monotype[] tp1, Monotype[] tp2) throws Unsatisfiable {
        if (this.size == 0) {
            if (tp1 == null && tp2 == null) {
                return;
            }
            throw new InternalError("Incorrect sizes " + (tp1 == null ? "null" : Integer.toString(tp1.length)) + " and " + (tp2 == null ? "null" : Integer.toString(tp2.length)));
        }
        if (tp1 == null || tp1.length != this.size) {
            throw new BadSizeEx(this.size, tp1 == null ? 0 : tp1.length);
        }
        if (tp2 == null || tp2.length != this.size) {
            throw new BadSizeEx(this.size, tp2 == null ? 0 : tp2.length);
        }
        block5: for (int i = 0; i < this.size; ++i) {
            switch (this.signs[i]) {
                case 1: {
                    Engine.leq(tp1[i], tp2[i]);
                    continue block5;
                }
                case -1: {
                    Engine.leq(tp2[i], tp1[i]);
                    continue block5;
                }
                case 0: {
                    if (tp2[i].isUnknown()) {
                        return;
                    }
                    if (tp1[i].isUnknown()) {
                        tp2[i].setUnknown();
                        return;
                    }
                    Engine.leq(tp1[i], tp2[i]);
                    Engine.leq(tp2[i], tp1[i]);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            switch (this.signs[i]) {
                case 1: {
                    sb.append("+");
                    continue block5;
                }
                case -1: {
                    sb.append("-");
                    continue block5;
                }
                case 0: {
                    sb.append("=");
                }
            }
        }
        return "Variance (" + sb.toString() + ")";
    }

    public int arity() {
        return this.size;
    }

    void tag(Monotype[] monotypes, int variance) {
        if (monotypes == null) {
            return;
        }
        for (int i = 0; i < monotypes.length; ++i) {
            monotypes[i].tag(variance * this.signs[i]);
        }
    }
}

