#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  Released under the GNU GPL v2
#  Ref: Mindwarper <mindwarper at hush.com>
#

if (description)
{
 script_id(16315);
 script_bugtraq_id(6571,6572);
 script_version ("$Revision: 1.1 $");

 script_name(english:"Mambo Site Server XSS and remote arbitrary code execution");
 desc["english"] = "
Mambo Site Server is an open source Web Content Management System. An attacker 
may use it to perform a cross site scripting attack on this host or execute
arbitrary code threw the gallery image uploader under administrator directory.

Solution: Upgrade to the latest version of this software
Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Mambo Site Server is vulnerable to xss attack and remote flaw");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses : XSS");
 script_copyright(english:"This script is Copyright (C) 2005 David Maciejak");
 script_dependencie("find_service.nes", "http_version.nasl", "cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(get_kb_item(string("www/", port, "/generic_xss"))) exit(0);
if(!can_host_php(port:port)) exit(0);


foreach d (make_list(cgi_dirs(),  "/mambo"))
{
 url = string(d, "/themes/mambosimple.php?detection=detected&sitename=</title><script>foo</script>");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL ) exit(0);
 
 if ( '<a href="?detection=detected&sitename=</title><script>foo</script>' >< buf )
   {
    security_warning(port);
    exit(0);
   }
}
