// textwindow.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FramedWindow subclass for enclosing text editor -- currently only used for
// display and editing of text comment strings for data files.
// Note:  will be renamed CommentEditorWindow

#ifndef TEXTWINDOW_H
#ifdef __GNUG__
#pragma interface
#endif
#define TEXTWINDOW_H

#include "framedwindow.h"
#include "localdefs.h"

class Action;
class CommentEditor;
class Interactor;

class TextWindow : public FramedWindow {
	typedef FramedWindow Super;
public:
	TextWindow(const char* title, CommentEditor*);
	virtual ~TextWindow();
	int keyCommand(unsigned long);
private:
	redefined Interactor* makeMenuBar();
	redefined Action* makeMenuItemAction(const struct MenuInfo *);
	redefined CommandState *getCommandState();
private:
	void init();
private:
	CommentEditor* myEditor;
};

#endif

