// pvanalyzer.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
// Subclass of QueuedOutputFunction which resynthesizes sound from a set of
// Phase Vocoder data

#ifndef PVANALYZER_H
#ifdef __GNUG__
#pragma interface
#endif
#define PVANALYZER_H

#include "localdefs.h"
#include "arrayfunction.h"
#include "phasevocoder.h"

class PVAnalyzer : public ArrayFunction {
	typedef ArrayFunction Super;
	friend class PVAnalysisRequester;
public:
	PVAnalyzer(Data *, int N, int F, int W, int M, int D,
	    double T, double P, PhaseVocoder::Mode mode, boolean useKaiser);
	PVAnalyzer(Data *);
	static Modifier* create(class DataEditor*);
	virtual ~PVAnalyzer();
	redefined const char* message() { return "Phase Vocoder Analysis:  "; }
	redefined int operator () (double *input, Data *frame);
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
	redefined int initialOffset();
	redefined int analysisLength();
	redefined int maxFrameLength() { return int(1000000); }
private:
	PhaseVocoder::Info _pvocInfo;
	PhaseVocoder* _pvoc;
private:
	static PhaseVocoder::Info _savedPvocInfo;
};

#endif
