/*
 * Filter for displaying only twin primes.
 *
 * Copyright (C) 2004 George Gesslein II.
 *
 * Usage: matho-primes | matho-twin
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <math.h>
#include <assert.h>

#define	true	1
#define	false	0

char	*prog_name;

main(int argc, char *argv[])
{
	double		d1, d2;
	char		buf[50];

	prog_name = argv[0];
	if (isatty(0)) {
		usage();
	}
	d1 = -2.0;
	for (;;) {
		if (fgets(buf, sizeof(buf), stdin) == NULL)
			break;
		if (!get_double_int(buf, &d2)) {
			exit(1);
		}
		if ((d1 + 2.0) == d2) {
			printf("%.0f %.0f\n", d1, d2);
		}
		d1 = d2;
	}
	exit(0);
}

int
get_double_int(cp, dp)
char	*cp;
double	*dp;
{
	if (sscanf(cp, "%lf", dp) != 1) {
		fprintf(stderr, "That is not a number!\n");
		return false;
	}
	if (*dp < 0.0 || fmod(*dp, 1.0) != 0.0) {
		fprintf(stderr, "Number must be a positive integer!\n");
		return false;
	}
	return true;
}

usage()
{
	fprintf(stderr, "Usage: matho-primes | matho-twin\n");
	exit(1);
}
