=begin
  locale_table_win32.rb - Locale table for win32

  Copyright (C) 2002,2003 Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: locale_table_win32.rb,v 1.3 2003/07/05 15:47:25 mutoh Exp $
=end

module Locale
  LocaleTable = [
    [0x00, "C"], 
    [0x01, "ar",
      [[0x01, "ar_SA"],
        [0x02, "ar_IQ"],
        [0x03, "ar_EG"],
        [0x04, "ar_LY"],
        [0x05, "ar_DZ"],
        [0x06, "ar_MA"],
        [0x07, "ar_TN"],
        [0x08, "ar_OM"],
        [0x09, "ar_YE"],
        [0x0a, "ar_SY"],
        [0x0b, "ar_JO"],
        [0x0c, "ar_LB"],
        [0x0d, "ar_KW"],
        [0x0e, "ar_AE"],
        [0x0f, "ar_BH"],
        [0x10, "ar_QA"]]
    ], 
    [0x02, "bg_BG"], 
    [0x03, "ca_ES"], 
    [0x04, "zh",
      [[0x01, "zh_TW"],
        [0x02, "zh_CN"],
        [0x03, "zh_HK"],
        [0x04, "zh_SG"],
        [0x05, "zh_MO"]]
    ], 
    [0x05, "cs_CZ"], 
    [0x06, "da_DK"], 
    [0x07, "de",
      [[0x01, "de_DE"],
        [0x02, "de_CH"],
        [0x03, "de_AT"],
        [0x04, "de_LU"],
        [0x05, "de_LI"]]
    ], 
    [0x08, "el_GR"], 
    [0x09, "en",
      [[0x01, "en_US"],
        [0x02, "en_GB"],
        [0x03, "en_AU"],
        [0x04, "en_CA"],
        [0x05, "en_NZ"],
        [0x06, "en_IE"],
        [0x07, "en_ZA"],
        [0x08, "en_JM"],
        [0x09, "en_GD"],
        [0x0a, "en_BZ"],
        [0x0b, "en_TT"],
        [0x0c, "en_PH"],
        [0x0d, "en_ZW"]]
    ], 
    [0x0a, "es",
      [[0x01, "es_ES"],
        [0x02, "es_MX"],
        [0x03, "es_ES@modern"],
        [0x04, "es_GT"],
        [0x05, "es_CR"],
        [0x06, "es_PA"],
        [0x07, "es_DO"],
        [0x08, "es_VE"],
        [0x09, "es_CO"],
        [0x0a, "es_PE"],
        [0x0b, "es_AR"],
        [0x0c, "es_EC"],
        [0x0d, "es_CL"],
        [0x0e, "es_UY"],
        [0x0f, "es_PY"],
        [0x10, "es_BO"],
        [0x11, "es_SV"],
        [0x12, "es_HN"],
        [0x13, "es_NI"],
        [0x14, "es_PR"]]
    ], 
    [0x0b, "fi_FI"], 
    [0x0c, "fr",
      [[0x01, "fr_FR"],
        [0x02, "fr_BE"],
        [0x03, "fr_CA"],
        [0x04, "fr_CH"],
        [0x05, "fr_LU"],
        [0x06, "fr_MC"]]
    ], 
    [0x0d, "he_IL"], 
    [0x0e, "hu_HU"], 
    [0x0f, "is_IS"], 
    [0x10, "it",
      [[0x01, "it_IT"],
        [0x02, "it_CH"]]
    ], 
    [0x11, "ja_JP"], 
    [0x12, "ko_KR"], 
    [0x13, "nl",
      [[0x01, "nl_NL"],
        [0x02, "nl_BE"]]
    ], 
    [0x14, "no",
      [[0x01, "no_NO"],
        [0x02, "nn_NO"]]
    ], 
    [0x15, "pl_PL"], 
    [0x16, "pt",
      [[0x01, "pt_PT"],
        [0x02, "pt_BR"]]
    ], 
    [0x18, "ro_RO"], 
    [0x19, "ru"], 
    [0x1a, "hr_HR",
      [[0x02, "sr_YU"],
        [0x03, "sr_YU@cyrillic"]]
    ], 
    [0x1b, "sk_SK"], 
    [0x1c, "sq_AL"], 
    [0x1d, "sv",
      [[0x01, "sv_SE"],
        [0x02, "sv_FI"]]
    ], 
    [0x1e, "th_TH"], 
    [0x1f, "tr_TR"], 
    [0x20, "ur",
      [[0x01, "ur_PK"],
        [0x02, "ur_IN"]]
    ], 
    [0x21, "id_ID"], 
    [0x22, "uk_UA"], 
    [0x23, "be_BY"], 
    [0x24, "sl_SI"], 
    [0x25, "et_EE"], 
    [0x26, "lv_LV"], 
    [0x27, "lt_LT"], 
    [0x29, "fa_IR"], 
    [0x2a, "vi_VN"], 
    [0x2b, "hy_AM"], 
    [0x2c, "az",
      [[0x01, "az_AZ@cyrillic"],
        [0x02, "az_AZ@latin"]]
    ], 
    [0x2d, "eu"], 
    [0x2e, "wen_DE"], 
    [0x2f, "mk_MK"], 
    [0x36, "af_ZA"], 
    [0x37, "ka_GE"], 
    [0x38, "fo_FO"], 
    [0x39, "hi_IN"], 
    [0x3e, "ms",
      [[0x01, "ms_MY"],
        [0x02, "ms_BN"]]
    ], 
    [0x3f, "kk_KZ"], 
    [0x41, "sw"], 
    [0x43, "uz",
      [[0x01, "ux_UZ@latin"],
        [0x02, "uz_UZ@cyrillic"]]
    ], 
    [0x44, "tt"], 
    [0x45, "bn_IN"], 
    [0x46, "pa_IN"], 
    [0x47, "gu_IN"], 
    [0x48, "or_IN"], 
    [0x49, "ta"], 
    [0x4a, "te_IN"], 
    [0x4b, "kn_IN"], 
    [0x4c, "ml_IN"], 
    [0x4d, "as_IN"], 
    [0x4e, "mr_IN"], 
    [0x4f, "sa_IN"], 
    [0x57, "kok_IN"], 
    [0x58, "mni_IN"], 
    [0x59, "sd"], 
    [0x60, "ks",
      [[0x01, "ks_PK"],
        [0x02, "ks_IN"]]
    ], 
    [0x61, "ne",
      [[0x01, "ne_NP"],
        [0x02, "ne_IN"]]
    ]]
end
