/* 
 * $Id: ctkspinbutton.h,v 1.3 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTKSPINBUTTON_H__
# define __CTKSPINBUTTON_H__ 

#include "ctkadjustment.h"

typedef struct CtkSpinButton_S {
	CtkEntry entry;
	
	CtkAdjustment *adjustment;
	
	gfloat climb_rate;
	guint digits;
	
} CtkSpinButton;

#define CTK_SPIN_BUTTON(obj)	CTK_CHECK_CAST((obj),CtkSpinButton,CtkTypeSpinButton)

void ctk_spin_button_handle_up(CtkSpinButton *spinbutton);
void ctk_spin_button_handle_down(CtkSpinButton *spinbutton);
void ctk_spin_button_value_to_text(CtkSpinButton *spinbutton);
CtkWidget *ctk_spin_button_new(CtkAdjustment *adjustment, gfloat climb_rate, guint digits);
void ctk_spin_button_set_text(CtkSpinButton *spinbutton, const gchar *text);
void ctk_spin_button_set_visibility(CtkSpinButton *spinbutton, gboolean visible);
void ctk_spin_button_set_digits(CtkSpinButton *spin_button, guint digits);
void ctk_spin_button_set_value(CtkSpinButton *spin_button, gfloat value);
CtkAdjustment *ctk_spin_button_get_adjustment(CtkSpinButton *spin_button);
void ctk_spin_button_set_adjustment(CtkSpinButton *spin_button,
				    CtkAdjustment *adjustment);
gfloat ctk_spin_button_get_value_as_float(CtkSpinButton *spin_button);
#endif
