/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSRasterLayer.cpp,v 1.6 2002/04/23 09:28:18 com Exp $
*/

#include <iostream.h>
#include <stdlib.h>
#include <qpainter.h>

//int GRASSRasterLayer::GRASSRasterLayerID = 2;

#include <GRASSRasterLayer.h>

GRASSRasterLayer::GRASSRasterLayer(GRASSPainter* painter, 
				   char* name,
				   char* mapset)
  : 
  _painter(painter), _raster(NULL)
{
  _name = name;

  _overLayMode = GRASSLayer::nonTransparent;
  mapset = G_find_cell2 (name, "") ;
//    cerr << "location is " << buf << " mapset is " << mapset 
//         << " name is " << name << " G_location() " << G_location() << endl;
  
  char buf[256];
  if (mapset == NULL) {
    sprintf(buf,"Raster map [%s] not available", name);
    G_fatal_error(buf) ;
  } else {
    cerr << "mapset is [" << mapset << "]" << endl;
    _mapSet = mapset;
  }
  
  
  /* Make sure map is available */
  if ((cellfile = G_open_cell_old(name, mapset)) == -1) {
    sprintf(buf,"Not able to open cellfile for [%s]", name);
    G_fatal_error(buf) ;
  }
  
  data_type  = ( G_raster_map_is_fp(name, mapset) ? DCELL_TYPE : CELL_TYPE );

  if (G_read_colors(name, mapset, &colors) == -1) {
    fprintf(stderr,"Color file for [%s] not available", name) ;
    exit(1);
  }
  
  _colorMap.setColors(&colors);
  
}


GRASSRasterLayer::~GRASSRasterLayer() {
  G_close_cell(cellfile);
}


void GRASSRasterLayer::draw(QPainter* qPainter) {
  void* xarray = G_allocate_raster_buf(data_type);
  
  if (_raster) {
    free(_raster) ;
    _raster = NULL ;
  }

  cur_D_row = _painter->D_y_beg;

  for (int cur_A_row = 0; cur_A_row != -1; ) {
    /* Get window (array) row currently required */
    G_get_raster_row(cellfile, xarray, cur_A_row, data_type) ;
    /* there is no support for raster masks YET! */
    //mask_raster_array (xarray, ncols, invert, data_type);    
    /* Draw the cell row, and get the next row number */
    cur_A_row = drawCell(cur_A_row, xarray, qPainter);
  }
  free (xarray);
}
  

int GRASSRasterLayer::drawCell(int A_row, void *array, QPainter* p) {
  int D_row ;
  int repeat ;
  char send_raster ;
  int cur_A_row ;

  int D_x_beg = _painter->D_x_beg;
  int D_x_end = _painter->D_x_end;
  int D_y_beg = _painter->D_y_beg;
  int D_y_end = _painter->D_y_end;
  int* D_to_A_tab = _painter->D_to_A_tab;



  /* Allocate memory for raster */
  if(!_raster) 
    _raster = (void *)G_malloc((D_x_end-D_x_beg+1) * G_raster_size(data_type));

  /* If picture is done, return -1 */
  if (cur_D_row >= D_y_end)
    return(-1) ;

  /* Get window (array) row currently required */
  D_row = cur_D_row ;
  cur_A_row = (int)_painter->D.D_d_to_a_row((double)cur_D_row) ;

  /* If we need a row further down the array, return that row number */
  if (cur_A_row > A_row)
    return (cur_A_row) ;

  /* Find out how many screen lines the current A_row gets repeated */
  repeat = 1 ;
  for (cur_D_row++ ; cur_D_row < D_y_end; cur_D_row++) {
    if (A_row == (cur_A_row = (int)_painter->D.D_d_to_a_row((double)cur_D_row)))
      repeat++ ;
    else
      break ;
  }

  /* Make the screen _raster */
  {
    register int D_col ;
    void *rasptr, *arr_ptr;

    rasptr = _raster;

    for (D_col = D_x_beg; D_col<D_x_end; D_col++ )
      {
	/* copy array[[D_to_A_tab[D_col]] to *_raster, advance _raster by 1 */

	arr_ptr = G_incr_void_ptr(array, D_to_A_tab[D_col] * G_raster_size(data_type));
	G_raster_cpy(rasptr, arr_ptr, 1, data_type);
	rasptr = G_incr_void_ptr(rasptr, G_raster_size(data_type));
      }
  }

  /* Check to see if raster contains one category */
  {
    register int D_col ;
    void *rasptr, *first_val_ptr;

    first_val_ptr = (void *) G_malloc(G_raster_size(data_type));
    rasptr = _raster;
    G_raster_cpy(first_val_ptr, rasptr, 1, data_type);
    
    send_raster = 0 ;
    for (D_col = D_x_beg; D_col<D_x_end; D_col++ ) {
      if (G_raster_cmp(first_val_ptr, rasptr, data_type) != 0) {
	send_raster = 1 ;
	break ;
      }
      rasptr = G_incr_void_ptr(rasptr, G_raster_size(data_type));
    }
  }

  int D__overlay_mode = isOverLay();

  /* Send the raster */
  if (send_raster) {
    //R_move_abs(D_x_beg, D_row) ;
    p->moveTo(D_x_beg, D_row); 
    //???   D_raster_of_type(raster, D_x_end-D_x_beg, repeat, colors, data_type) ;
//      cerr << "raster print repeat " << repeat << " num " 
//  	 << D_x_end-D_x_beg << " D_y_end " << D_y_end 
//  	 << " cur_D_row " << cur_D_row << endl;
    
    void *arr = 0;
    CELL cat;
    int num = D_x_end-D_x_beg;

    QColor *c;//(0, (uint) *arr++);
    QColor col;//(0, (uint) *arr++);
    QColor blue("blue");
    QColor white("white");
    int colr;
    for (int i=0; i < repeat; i++) {
      arr = _raster;
      for (int j = 0; j < num; j++) {	
//  	if ( *arr++ != 1 ) {
//  //  	  c.setNamedColor("blue");
//  	  c = &blue;
//  	} else {
//  //  	  c.setNamedColor("white");
//  	  c = &white;
//  	}


//  //  	cerr << (uint) *arr << ",";


	if (_colorMap.fixed) {

	  ///!!! lookup_raster_colors is called way to many times... I think?
	  if ( j == 0 ) // only do this once per row (j==0) 
	    _colorMap.lookup_raster_colors(arr, num, data_type);  	

//  	  col.setRgb(_colorMap.RED[_colorMap.red[j]], 
//  		     _colorMap.GRN[_colorMap.grn[j]], 
//  		     _colorMap.BLU[_colorMap.blu[j]]);
	  col.setRgb(_colorMap.red[j], 
		     _colorMap.grn[j], 
		     _colorMap.blu[j]);

//  	  cerr << "RGB " << 
//  	    _colorMap.RED[_colorMap.red[j]]
//  	       << "," <<
//  	    _colorMap.GRN[_colorMap.grn[j]] << "," <<
//  	    _colorMap.BLU[_colorMap.blu[j]] << endl;
	} else {
	  colr = cat = G_get_raster_value_c(arr, data_type);
	  if(!G_is_null_value(arr, data_type)) {
	    if (cat < _colorMap.cmin || cat > _colorMap.cmax)
	      colr = _colorMap.cmax - _colorMap.cmin + 3;
	    else
	      colr -= _colorMap.cmin-1;
	  } else {
	    if(!D__overlay_mode)
	      colr = _colorMap.cmax - _colorMap.cmin + 2;
	    else
	      colr = 0;
	  }
	  col.setRgb(_colorMap.red[colr], 
		     _colorMap.grn[colr], 
		     _colorMap.blu[colr]);
//  	  cerr << "colr RGB " << colr << " r " <<  (int)_colorMap.red[colr] << ", " 
//  	       << "g " << (int) _colorMap.grn[colr] << ", " << "b " 
//  	       << (int) _colorMap.blu[colr] << endl;
	}
	if (! D__overlay_mode || !G_is_null_value(arr, data_type)) {
	//p->setBrush(col);
	  p->setPen(col);
	  p->drawPoint(p->pos().x()+j, p->pos().y()+i);
	  }
	arr = G_incr_void_ptr(arr, G_raster_size(data_type));
	}
//        cerr << endl;
    }
    
  } else {
    int draw;
    /* this really should be part of D_raster(); */
    //extern int D__overlay_mode;

    /* color with the color for first raster value */
    //D_color_of_type(raster, colors, data_type);
    draw = !D__overlay_mode || !G_is_null_value(_raster, data_type);
    //R_move_abs(D_x_beg, D_row) ;
    p->moveTo(D_x_beg, D_row); 
    if (draw) {
      //R_box_rel(D_x_end-D_x_beg, repeat);
      p->setBrush(Qt::red);
      p->drawRect(p->pos().x(), p->pos().y(), D_x_end-D_x_beg, repeat);
      p->moveTo(p->pos().x()+D_x_end-D_x_beg,  p->pos().y()+repeat);
    }
  }
  
  /* If picture is done, return -1 */
  if (cur_D_row >= D_y_end)
    return(-1) ;

  /* Return the array row of the next row needed */
  return (cur_A_row) ;
}









GRASSRasterLayer::GRASSRasterLayer(const GRASSRasterLayer& rhs) {}


GRASSRasterLayer& GRASSRasterLayer::operator=(const GRASSRasterLayer& rhs) {
  return *this;
}

