// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_mysqlclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include <hk_mysqlconnection.h>
#include <hk_mysqldatabase.h>
#include <dlfcn.h>
#include "hk_drivermanager.h"
#include "hk_actionquery.h"
#include <mysqld_error.h>

hk_mysqlconnection::hk_mysqlconnection(hk_drivermanager* c):hk_connection(c)
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqlconnection::hk_mysqlconnection");
#endif
    p_SQL_Connection=NULL;
    set_tcp_port(default_tcp_port());

}


hk_mysqlconnection::~hk_mysqlconnection()
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqlconnection::~hk_mysqlconnection");
#endif
//       driver_specific_disconnect();
    if (p_SQL_Connection) mysql_close(p_SQL_Connection);
    p_SQL_Connection=NULL;
}


bool  hk_mysqlconnection::driver_specific_connect()
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqlconnection::driver_specific_connect");
#endif

    char* db=0;
    char* xunix_port=0;
    if (!p_connected)
    {
        p_SQL_Connection=mysql_init(p_SQL_Connection);
//cout <<"MYSQL TCP PORT:" <<tcp_port()<<endl;
        p_connected=mysql_real_connect(p_SQL_Connection,host().c_str(),user().c_str(),password().c_str(),db,tcp_port(),xunix_port,0);
        if (!p_connected)
        {servermessage();
            mysql_close(p_SQL_Connection);
            p_SQL_Connection=NULL;
        }
    }
    if (!p_connected) servermessage();
    return p_connected;

}


MYSQL* hk_mysqlconnection::dbhandler()
{
    return p_SQL_Connection;
}


bool hk_mysqlconnection::driver_specific_disconnect()

{
#ifdef HK_DEBUG
    hkdebug("hk_mysqlconnection::driver_specific_disconnect");
#endif
    if (p_connected)
    {
        mysql_close(p_SQL_Connection);
        p_connected=false;
        p_SQL_Connection=NULL;

    }
    return p_connected;

}


vector<hk_string>* hk_mysqlconnection::driver_specific_dblist(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqlconnection::driver_specific_dblist");
#endif
    MYSQL_RES* Res;
    MYSQL_ROW row;
    char *wild=NULL;
    unsigned int i;
    p_databaselist.erase(p_databaselist.begin(),p_databaselist.end());

    if (p_connected)
    {
        Res=mysql_list_dbs(p_SQL_Connection,wild);
        if (Res==NULL)return &p_databaselist;
        while ((row=mysql_fetch_row(Res)))
        {
            for (i=0 ; i < mysql_num_fields(Res);i++)
            {
                p_databaselist.insert(p_databaselist.end(),(row[i]));
            }
        }
        mysql_free_result(Res);
    }
    ;
    return &p_databaselist;
}


hk_database* hk_mysqlconnection::driver_specific_new_database(void)
{
    hk_mysqldatabase* db;
    db = new hk_mysqldatabase(this);
    return db;
}



bool hk_mysqlconnection::server_supports(support_enum t) const
{
    switch (t)
    {
        case SUPPORTS_REFERENTIALINTEGRITY:
        case SUPPORTS_TRANSACTIONS:
	case SUPPORTS_RENAME_DATABASE:
	case SUPPORTS_LOCAL_FILEFORMAT:
	case SUPPORTS_VIEWS:
	case SUPPORTS_NEW_VIEW:
	case SUPPORTS_ALTER_VIEW:
	case SUPPORTS_DELETE_VIEW:
            return false;
        case SUPPORTS_BOOLCOLUMN : return booleanemulation();
        default : return true;
    }

}


hk_string hk_mysqlconnection::drivername(void) const
{

    return "mysql";
}



bool hk_mysqlconnection::server_needs(need_enum t) const
{
    switch (t)
    {
        case NEEDS_HOST:
        case NEEDS_USERNAME:
        case NEEDS_PASSWORD:
        case NEEDS_PORT:
	case NEEDS_BOOLEANEMULATION:
            return true;

        default: return false;
    }

}


bool hk_mysqlconnection::driver_specific_new_password(const hk_string& newpasswd)
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqlconnection::driver_specific_new_password");
#endif
    hk_mysqldatabase* db=new hk_mysqldatabase(this);
    hk_actionquery* p_q= db->driver_specific_new_actionquery();
    if (p_q==NULL)
       {
	return false;
       }
    hk_string pwdsql="SET PASSWORD = PASSWORD('";
    pwdsql+=newpasswd+"')";
    p_q->set_sql(pwdsql.c_str(),pwdsql.size());
    bool result= p_q->execute(); 
    delete p_q;
    delete db;
    return result;

}


void hk_mysqlconnection::servermessage(void)
{
    if (p_SQL_Connection)
    {
        set_last_servermessage(mysql_error(p_SQL_Connection));
        cerr<< "Mysql error message "<<mysql_errno(p_SQL_Connection)<<" : "<<last_servermessage()<<endl;
    }
}


unsigned int    hk_mysqlconnection::default_tcp_port(void) const
{
    return 3306;
}


//***********************************************************

hk_connection* create_connection(hk_drivermanager* cl)
{
    return new hk_mysqlconnection(cl);
}


hk_string hk_classesversion(void)
{
return (hk_string)HK_VERSION;
}
