# Release number can be specified with rpm --define 'rel SOMETHING' ...
# If no such --define is used, the release number is 1.
#
# Source archive's extension can be specified with rpm --define 'srcext .foo'
# where .foo is the source archive's actual extension.
# To compile an RPM from a .bz2 source archive, give the command
#   rpm -tb --define 'srcext .bz2' gnome-commander-1.0.1.tar.bz2
#

%if %{?rel:0}%{!?rel:1}
%define rel 1
%endif
%if %{?srcext:0}%{!?srcext:1}
%define srcext .gz
%endif

Summary:       A Gnome file manager similar to the Norton Commander (TM)
Summary(pl):   Menader plikw dla Gnome oparty o Norton Commander'a (TM)
Summary(sv):   En Norton Commander (TM)-liknande filhanterare fr Gnome.
Name:          gnome-commander
Version:       1.0.1
Release:       %{rel}
URL:           http://www.freesoftware.fsf.org/gcmd/
Source:        http://freesoftware.fsf.org/download/gcmd/gcmd.pkg/%{version}/%{name}-%{version}.tar%{srcext}
License:       GPL2
Group:         Applications/File
Prefix:        /usr
BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root
Docdir:        %{_docdir}
Requires:      gettext >= 0.10.36
Requires:      gnome-vfs >= 0.5
BuildRequires: gnome-vfs-devel >= 0.5
BuildRequires: glib2-devel intltool

Distribution:  Any

%description
Gnome Commander is a file manager that just like the classical Norton Commander (TM) lets you do everything with the keyboard. It can perform all standard file operations and some extra features like FTP support.

%description -l pl
Gnome Commander to menader plikw, ktry podobnie jak klasyczny Norton Commander (TM), umoliwia wykonywanie za pomoc klawiatury wszystkich standardowych operacji na plikach. Dostpne s rwnie dodatkowe funkcje jak np. obsuga FTP.

%description -l sv
Gnome Commander r en Gnome-baserad filhanterare som till stor del liknar den klassiska Norton Commander (TM). Programmet kan utfra alla de vanliga filoperationerna och har utver detta FTP funktioner samt std fr att anvnda ikonteman gjorda fr Nautilus.

%prep
%setup -q

%build
./configure --prefix=%{prefix}
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{prefix}/bin/*
%{prefix}/share/gnome/apps/Applications/gnome-commander.desktop
%{prefix}/share/pixmaps/gnome-commander/*.png
%{prefix}/share/pixmaps/gnome-commander/*.xpm
%{prefix}/share/pixmaps/gnome-commander/*/*.png
%{prefix}/share/pixmaps/gnome-commander/*/*.xpm
%{prefix}/share/locale/*/LC_MESSAGES/gnome-commander.mo
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README TODO doc/*.txt doc/*.png

%changelog
* Tue Mar 25 2003 Piotr Eljasiak <epiotr@idea.net.pl>
- updated Sources

* Mon Jan 20 2003 Piotr Eljasiak <epiotr@idea.net.pl>
- added build dependencies

* Fri Jan 10 2003 Piotr Eljasiak <epiotr@idea.net.pl>
- added localization

* Thu Jan 09 2003 Piotr Eljasiak <epiotr@idea.net.pl>
- added dependencies

* Mon Jun 24 2002 Piotr Eljasiak <epiotr@idea.net.pl>
- more cleanup in install section 

* Sat Jun 15 2002 Piotr Eljasiak <epiotr@idea.net.pl>
- simplified install and files sections

* Mon Jun 10 2002 Piotr Eljasiak <epiotr@idea.net.pl>
- .spec file is now generated from .spec.in

* Mon Jun 10 2002 Marcus Bjurman <marbj499@student.liu.se>
- The default icon for this project is now called gnome-commander.png
  The xpm variant of the same icon is now also renamed in the same manner.

* Sat Mar  9 2002 Marcus Bjurman <marbj499@student.liu.se>
- Pumped up the version nr

* Sun Nov  4 2001 Marcus Bjurman <marbj499@student.liu.se>
- Initial build.
