#ifndef GIFT_GT_NODE_LIST_H_
#define GIFT_GT_NODE_LIST_H_

/*****************************************************************************/

struct gt_node;

typedef struct gt_node* (*GtConnForeachFunc) (TCPC *c, 
                                               struct gt_node *node, 
                                               void *udata);

#define GT_CONN_FOREACH(func) ((GtConnForeachFunc)func)

/*****************************************************************************/

void                 gt_conn_add      (struct gt_node *c);
void                 gt_conn_remove   (struct gt_node *c);
struct gt_node     *gt_conn_foreach   (GtConnForeachFunc func, void *udata,
                                       GtNodeClass klass, GtNodeState state, 
                                       int iter);

/*****************************************************************************/

int         gt_conn_length   (GtNodeClass klass, 
                              GtNodeState state);
GtNode     *gt_conn_random   (GtNodeClass klass,
                              GtNodeState state);
void        gt_conn_trim     (void);

void        gt_conn_sort     (CompareFunc func);
int         gt_conn_sort_vit (struct gt_node *a, struct gt_node *b);
int         gt_conn_sort_vit_neg (struct gt_node *a, struct gt_node *b);

/*****************************************************************************/

/* update or load the list of nodes in ~/.giFT/Gnutella/nodes */
void        gt_node_list_save (void);
void        gt_node_list_load (void);

/*****************************************************************************/

#endif /* GIFT_GT_NODE_LIST_H_ */
