#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"

static void
rendgtk_vseparator_render (ENode * node)
{
    GtkWidget *sep;

    sep = gtk_vseparator_new ();

    enode_set_kv (node, "top-widget", sep);
    enode_set_kv (node, "bottom-widget", sep);

    rendgtk_show_cond (node, sep);
}

static void
rendgtk_hseparator_render (ENode * node)
{
    GtkWidget *sep;

    sep = gtk_hseparator_new ();

    enode_set_kv (node, "top-widget", sep);
    enode_set_kv (node, "bottom-widget", sep);

    rendgtk_show_cond (node, sep);
}


void
separator_renderer_register (void)
{
    Element *element;

    /* labels */
    element = g_malloc0 (sizeof (Element));
    element->render_func = rendgtk_vseparator_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = NULL;
    element->tag = "vseparator";
    element->description = "Create a vertical seperation widget.";
    element_register (element);

    rendgtk_widget_attr_register (element, GTK_TYPE_VSEPARATOR);

    element = g_malloc0 (sizeof (Element));
    element->render_func = rendgtk_hseparator_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = NULL;
    element->tag = "hseparator";
    element->description = "Create a horizontal seperation widget.";
    element_register (element);

    rendgtk_widget_attr_register (element, GTK_TYPE_HSEPARATOR);
}
