/* Emcast - Endhost multicast library
 * Copyright (C) 2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#ifndef _LIBEMCAST_H
#define _LIBEMCAST_H


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/types.h>
#include <emcastconfig.h>

extern const unsigned int emcast_major_version;
extern const unsigned int emcast_minor_version;
extern const unsigned int emcast_micro_version;
extern const unsigned int emcast_interface_age;
extern const unsigned int emcast_binary_age;

/* Check Emcast version */
#define EMCAST_CHECK_VERSION(major,minor,micro)    \
    (EMCAST_MAJOR_VERSION > (major) || \
     (EMCAST_MAJOR_VERSION == (major) && EMCAST_MINOR_VERSION > (minor)) || \
     (EMCAST_MAJOR_VERSION == (major) && EMCAST_MINOR_VERSION == (minor) && \
      EMCAST_MICRO_VERSION >= (micro)))



/* Emcast struct is defined elsewhere.  It's full of secrets. */
typedef struct _Emcast Emcast;

/* Convert error number to const string */
char*   emcast_strerror (int errnum);

/* Error numbers. */
#define EMCAST_EFAIL	  -1	/* General failure		 */
#define EMCAST_EINTERNAL  -2	/* Internal error, unrecoverable */
#define EMCAST_EBADARG	  -3	/* Bad argument			 */
#define EMCAST_EBADURL	  -4	/* Malformed/bad URL		 */
#define EMCAST_ENOPROTO	  -5	/* No such protocol		 */
#define EMCAST_EBADOPT	  -6	/* Bad option			 */
#define EMCAST_EBADVAL	  -7	/* Bad option value		 */


/* Create a new Emcast object */
int emcast_new (Emcast** emcastp, const char* protocol_or_url);
#define emcast_delete(E) emcast_leave(E)

/* Join/leave multicast group */
int emcast_join (Emcast* emcastp, const char* url);
int emcast_leave (Emcast* emcast);

/* Send/receive multicast data */
int emcast_send (Emcast* emcast, const void* buf, size_t len);
int emcast_recv (Emcast* emcast, void* buf, size_t len);
int emcast_recvfrom (Emcast* emcast, void* buf, int len, 
		     void* from, size_t* fromlen);

/* Set/get options */
int emcast_setopt (Emcast* emcast, const char* optname, 
		   const void* optval, size_t optlen);
int emcast_getopt (Emcast* emcast, const char* optname, 
		   void* optval, size_t* optlen);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _LIBEMCAST_H */

