/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * sema_common.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: sema_common.h,v 1.2 2004/01/09 17:27:41 ericprev Exp $
*/

#ifndef __SEMA_COMMON_H__
#define __SEMA_COMMON_H__

/*************************/
/* get nb 512Bytes slice */ 
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_ul_slices(int semid,int nb);

/******************************/
/* try to get one upload slot */ 
/************************************************/ 
/* output: 0= fail to get slot, 1=slot obtained */
/********************************************************/
/* WARNING: this function locks the UL controler itself */
/********************************************************/
int try_to_get_ul_slot(int semid);

/*******************************************************/
/* free an upload slot allocated by try_to_get_ul_slot */
/*******************************************************/
void free_one_ul_slot(int semid);
   
/************************************************/
/* get an upload slot even if none is available */
/********************************************************/ 
/* WARNING: this function locks the UL controler itself */
/********************************************************/ 
void force_get_ul_slot(int semid);

/************************/
/* get nb 1KBytes slice */
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_dl_slices(int semid,int nb);

#endif
