
/* Network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

/* Database code */
#include "db.h"



/* Initialize a db, allocate default-size pool */
void db_init(db *d)
{
	d->size_pool = POOL_GROW;
	d->used = 0;
	d->records = (void**)malloc(sizeof(void*) * d->size_pool);
	if (!d->records) freakout("out of memory in db_init()");
}



/* Grow the pool of a db
 * Returns: 0 on failure, 1 on success
 */
inline int db_growpool(db *d)
{
	void *newptr;
	
	assert(d != NULL);
	assert(d->records != NULL);
	assert(POOL_GROW > 0);
	
	newptr = realloc(d->records, (d->size_pool+POOL_GROW)*sizeof(void*));
	if (newptr == NULL)
	{
		return 0;
	} else {
		d->records = newptr;
		d->size_pool += POOL_GROW;
		return 1;
	}
}



/* Free a database. WARNING: make sure you've freed all the records first */
void db_free(db *d)
{
	assert(d != NULL);
	assert(d->records != NULL);

	free(d->records);
}



/* Grab the n-th item of a database. Returns NULL if invalid request */
inline void *db_get(const db d, const dword n)
{
	if (n >= d.used) return NULL; else
	return d.records[n];
}



/* Add an item to the database. Returns 0 on fail, 1 on success */
inline int db_add(db *d, void *data)
{
	assert(data != NULL);
	assert(d != NULL);
	assert(d->records != NULL);
	assert(d->used <= d->size_pool);

	if (d->used == d->size_pool)
	{
		if (!db_growpool(d)) return 0;
	}

	d->records[d->used] = data;
	d->used++;

	return 1;
}

