/*  cssed (c) Iago Rubio 2003, 2004 - A tiny CSS editor.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#define WITH_PLUGINS

#ifdef WIN32
# undef WITH_PLUGINS
#endif

#ifdef WITH_PLUGINS
# include <gmodule.h>
#endif

#ifdef WITH_TERMINAL
 #include <vte/vte.h>
#endif

#include "cssedwindow.h"
#include "document.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "xmlparser.h"
#include "cssdialogs-menu.h"
#include "utils.h" // tree_iter_compare_markup_string

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)


enum
{
	COL_CSS_VER = 0,
	COL_ATTR,
	COL_VALUE,
	NUM_COLS
};

void set_css_properties_treeview (CssedWindow * window);

GtkWidget *
create_window (CssedWindow * windowobj)
{
	GtkWidget *window;
	GtkWidget *vbox_main;
	GtkWidget *alignment;
	GtkWidget *separatormenuitem;
	GtkWidget *menubar_main;
	GtkWidget *menuitem_file;
	GtkWidget *menuitem_file_menu;
	GtkWidget *menu_new;
	GtkWidget *menu_open;
	GtkWidget *menu_revert_to_saved;
	GtkWidget *menu_guardar;
	GtkWidget *menu_guardar_como;
	GtkWidget *menu_salir;
	GtkWidget *menuitem_editar;
	GtkWidget *menuitem_editar_menu;
	GtkWidget *menu_cortar;
	GtkWidget *menu_copiar;
	GtkWidget *menu_pegar;
	GtkWidget *menu_borrar;
	GtkWidget* menu_close;
	GtkWidget* menu_close_all;
	GtkWidget* menu_save_all;
	GtkWidget* image_menu;
	//GtkWidget* menu_close_all;
	// //// undo redo and search replace
	GtkWidget *menu_undo;
	GtkWidget *menu_redo;
	GtkWidget *menu_search;
	GtkWidget *menu_replace;
	GtkWidget *menu_preferences;
	// //////// view /////////////////
	GtkWidget *menuitem_view;
	GtkWidget *menuitem_view_menu;
	GtkWidget *menu_toolbars_submenu;
	GtkWidget *menu_item_toolbars;
	GtkWidget *menu_toolbar;
	GtkWidget *menu_secodary_toolbar;
	GtkWidget *menu_zoom_in;
	GtkWidget *menu_zoom_out;
	GtkWidget *menu_normal_size;
	// ////// document ////////////////
	// FIXME: change menuitem_ver and menu_ver to menu?_document
	GtkWidget *menuitem_ver;
	GtkWidget *menu_ver_line_numbers;
	GtkWidget *menuitem_ver_menu;
	GtkWidget *menu_ver_line_endings;
	GtkWidget *menu_ver_white_spaces;
	GtkWidget *menu_ver_lines_wrapped;
	GtkWidget *menu_item_autocompletion;
	GtkWidget *menu_item_folding;
	GtkWidget *menuitem_eol_mode;
	GtkWidget *menuitem_eol_mode_menu;
	GtkWidget *menuitem_eol_mode_cr;
	GtkWidget *menuitem_eol_mode_lf;
	GtkWidget *menuitem_eol_mode_crlf;
	GtkWidget *menuitem_folding;
	GtkWidget *menuitem_folding_menu;
	GtkWidget *menuitem_fonding_foldall;
	GtkWidget *menuitem_folding_unfoldall;
	// highlighting
	GtkWidget *menuitem_highlighting;
	GtkWidget *menuitem_highlighting_menu;
	GtkWidget *menuitem_highlighting_text;
	GtkWidget *menuitem_highlighting_css;
	GtkWidget *menuitem_highlighting_html;
	GtkWidget *menuitem_highlighting_sh;
	GtkWidget *menuitem_highlighting_c;
	GtkWidget *menuitem_highlighting_apache_conf;
	GtkWidget *menuitem_highlighting_perl;
	GtkWidget *menuitem_highlighting_python;
	GtkWidget *menuitem_highlighting_xml;
	GtkWidget *menuitem_highlighting_diff;
	GtkWidget *menuitem_highlighting_make;
	// encoding
	GtkWidget *menuitem_encoding;
	GtkWidget *menuitem_encoding_menu;
	GtkWidget *menuitem_encoding_default;
	GtkWidget *menuitem_encoding_utf8;
	GtkWidget *menuitem_encoding_dbcs;
	// charset 
	GtkWidget *menuitem_charset;
	GtkWidget *menuitem_charset_menu;
	GtkWidget *menuitem_charset_ansi;
	GtkWidget *menuitem_charset_easteurope;
	GtkWidget *menuitem_charset_gb2312;	
	GtkWidget *menuitem_charset_hangul;
	GtkWidget *menuitem_charset_shiftjis;	
	// change font // 
	GtkWidget *menu_item_font;
	// panels ///////////////////
	GtkWidget *menuitem_panel;
	GtkWidget *menuitem_panel_menu;
	GtkWidget *menuitem_show_footer_panel;
	GtkWidget *menuitem_hide_footer_panel;
	GtkWidget *menuitem_show_side_panel;
	GtkWidget *menuitem_hide_side_panel;
#ifdef WITH_PLUGINS
	GtkWidget *menuitem_plugins;
	GtkWidget *menuitem_plugins_menu;
	GtkWidget *menuitem_plugins_load;
#endif
	// help //////////////////////
	GtkWidget *menuitem_ayuda;
	GtkWidget *menuitem_ayuda_menu;
#ifdef WITH_HELP_MENUS
	GtkWidget *menuitem_cssed_website;
	GtkWidget *menuitem_cssed_website_menu;
#ifdef DARWIN
	GtkWidget *menuitem_cssed_website_with_safari;
	GtkWidget *menuitem_cssed_website_with_firefox;
#endif
	GtkWidget *menuitem_cssed_website_with_mozilla;
	GtkWidget *menuitem_cssed_website_with_galeon;
	GtkWidget *menuitem_cssed_website_with_dillo;
	GtkWidget *menuitem_cssed_website_with_gnome;
	GtkWidget *menuitem_cssed_doc_online;
	GtkWidget *menuitem_cssed_doc_online_menu;
#ifdef DARWIN
	GtkWidget *menuitem_cssed_doc_online_with_safari;
	GtkWidget *menuitem_cssed_doc_online_with_firefox;
#endif
	GtkWidget *menuitem_cssed_doc_online_with_mozilla;
	GtkWidget *menuitem_cssed_doc_online_with_galeon;
	GtkWidget *menuitem_cssed_doc_online_with_dillo;
	GtkWidget *menuitem_cssed_doc_online_with_gnome;
#endif /* #ifdef WITH_HELP_MENUS */
	//GtkWidget *menu_cssed_help;
	// ///////// CSS ////////////
	GtkWidget *css_menu;
	GtkWidget *menuitem_selector_wizard;
	GtkWidget *menuitem_color_wizard;
	GtkWidget *menuitem_box_wizard;
	GtkWidget *menu_about;
	GtkWidget *css_dialogs_submenu;
	GtkWidget *css_dialogs_mainmenu;
	// toolbar //////////////////
	GtkWidget *toolbar_main;
	GtkWidget *button_abrir;
	GtkWidget *button_nuevo;
	GtkWidget *button_cerrar;
	GtkWidget *button_buscar;
	GtkWidget *button_reemplazar;
	GtkWidget *button_cortar;
	GtkWidget *button_copiar;
	GtkWidget *button_pegar;
	GtkWidget *button_next;
	GtkWidget *button_prev;
	GtkWidget *button_undo;
	GtkWidget *button_redo;
	GtkWidget *button_color;
	GtkWidget *button_guardar;
	GtkWidget *button_guardarcomo;
	GtkWidget *button_preferences;
	GtkWidget *button_hide_side;
	GtkWidget *button_show_side;
	GtkWidget *button_hide_footer;
	GtkWidget *button_show_footer;
	// second toolbar ///////////
	GtkWidget *toolbar_tools;
	GtkWidget* tt_icon;
	GtkWidget *button_border_all;
	GtkWidget *button_margin_all;
	GtkWidget *button_padding_all;
	GtkWidget *button_box_properties;
	GtkWidget *button_sel_wizard;
	GtkWidget *button_col_wizard;
	GtkWidget *button_font;
	GtkWidget *button_scan_selector;
	GtkWidget *button_doc_info;
	GtkWidget *button_clean_output;
	GtkWidget *button_validate;
	GtkWidget *button_validate_dump;
	// ////// zoom //////////////
	/* those will be taken out
	GtkWidget *button_zoom_in;
	GtkWidget *button_zoom_out;
	GtkWidget *button_zoom_off;
	*/
	// //////////////////////////
	GtkWidget *menuitem_utils;
	GtkWidget *menuitem_utils_menu;
	GtkWidget *menu_utils_scan_selector;
	GtkWidget *menu_utils_doc_info;
	GtkWidget *menu_utils_autocomp;
	GtkWidget *menu_utils_validate;
	GtkWidget *menu_utils_validate_only;
	GtkWidget *menu_utils_cleanoutput;
	// ////////////////////////////////
	GtkWidget *vpaned_main;
	GtkWidget *hpaned_main;
	GtkWidget *vpaned_css;
	GtkWidget *notebook_docs;
	//GtkWidget *editor;
	//GtkWidget *label_notebook_blank;
	GtkWidget *scrolledwindow_cssc;
	GtkWidget *treeview_css_current;
	GtkWidget *scrolledwindow_cssp;
	GtkWidget *treeview_css_properties;
	GtkTreePath* css_prop_path;
	GtkWidget *notebook_footer;
	GtkWidget *output_list;
	GtkWidget *scrolledwindow_output_text;
	GtkWidget *scrolledwindow_scratch_text;
	GtkWidget *scratch_text;
	GtkWidget *scratch_label;
	GtkWidget* hpaned_scratch;
	GtkWidget* scrolledwindow_drop_text;
	GtkWidget* drop_text;
#ifdef WITH_TERMINAL
	GtkWidget *term_window;
	GtkWidget *label_terminal;
	GtkWidget* hbox_terminal;
	GtkWidget* frame_terminal;
	GtkWidget* sb_terminal;
	GdkColor terminal_fore_color;
	GdkColor terminal_back_color;
	GdkVisual* visual;
	GdkColormap* colormap;
	gchar* shell;
#endif
	GtkWidget *label_notebook_footer;
	GtkAccelGroup *accel_group;
	// set up items to the output list
	GtkListStore *output_store;
	GtkTreeViewColumn *output_column;
	GtkCellRenderer *output_render;
	// set up items for the current selector list
	GtkListStore *current_css_store;
	GtkTreeViewColumn *current_css_property_column;
	GtkTreeViewColumn *current_css_value_column;
	GtkCellRenderer *current_css_render_properties;
	GtkCellRenderer *current_css_render_values;
	GtkTreeViewColumn *current_arrow_column;
	GtkCellRenderer *current_css_render_pixbuf;
	// setup thing for the document scanner
	GtkListStore *document_scanner_store;
	GtkTreeViewColumn *document_scanner_column;
	GtkTreeViewColumn *document_scanner_column_numbers;
	GtkCellRenderer *document_scanner_render;
	GtkWidget *document_scanner_vbox;
	GtkWidget *document_scanner_button;
	GtkWidget *document_scanner_scrolled_window;
	GtkWidget* document_scanner_treeview;
	// sidebar notebook
	GtkWidget *sidebar_notebook;
	// icon stuff
	const gchar* icon_name = "cssed-icon.png";
	GdkPixbuf* icon_pixbuf;
	GtkAccelGroup* css_menu_accels;
	GtkWidget* css_dialogs_item;
	//GtkWidget* image_menu;
	// editor pop menu
	GtkWidget*  pop_menu;
	GtkWidget* pop_menu_undo;
	GtkWidget* pop_menu_redo;
	GtkWidget* pop_menu_cut;
	GtkWidget* pop_menu_copy;
	GtkWidget* pop_menu_paste;
	GtkWidget* pop_menu_delete;
	GtkWidget* pop_menu_selectall;
	GtkTooltips* scratch_tips;
	CssedConfig* cfg;

	accel_group = gtk_accel_group_new ();
	cfg = cssed_window_get_config( windowobj );

	// pop menu to be used in editors
	pop_menu = gtk_menu_new();

	pop_menu_undo = gtk_image_menu_item_new_from_stock ("gtk-undo", NULL);
	gtk_widget_show (pop_menu_undo);
	gtk_container_add (GTK_CONTAINER (pop_menu), pop_menu_undo);

	pop_menu_redo= gtk_image_menu_item_new_from_stock ("gtk-redo", NULL);
	gtk_widget_show (pop_menu_redo);
	gtk_container_add (GTK_CONTAINER (pop_menu), pop_menu_redo);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (pop_menu),  separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	pop_menu_cut= gtk_image_menu_item_new_from_stock ("gtk-cut", NULL);
	gtk_widget_show (pop_menu_cut);
	gtk_container_add (GTK_CONTAINER (pop_menu), pop_menu_cut);

	pop_menu_copy= gtk_image_menu_item_new_from_stock ("gtk-copy", NULL);
	gtk_widget_show (pop_menu_copy);
	gtk_container_add (GTK_CONTAINER (pop_menu), pop_menu_copy);

	pop_menu_paste= gtk_image_menu_item_new_from_stock ("gtk-paste", NULL);
	gtk_widget_show (pop_menu_paste);
	gtk_container_add (GTK_CONTAINER (pop_menu), pop_menu_paste);

	pop_menu_delete= gtk_image_menu_item_new_from_stock ("gtk-delete", NULL);
	gtk_widget_show (pop_menu_delete);
	gtk_container_add (GTK_CONTAINER (pop_menu), pop_menu_delete);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (pop_menu),  separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	pop_menu_selectall= gtk_image_menu_item_new_with_mnemonic(_("_Select all"));
	gtk_widget_show (pop_menu_selectall);
	gtk_container_add (GTK_CONTAINER (pop_menu), pop_menu_selectall);

	// main window object
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	//windowobj->window_widget = window;
	cssed_window_set_window_widget( windowobj, window );
	cssed_window_set_pop_menu( windowobj, pop_menu );

	gtk_window_set_title (GTK_WINDOW (window), "cssed");
	//gtk_window_set_default_size( GTK_WINDOW (window), 300, 300 ); //small enought to fit in 640x480
	gtk_window_move(GTK_WINDOW(window),cfg->window_x, cfg->window_y );
	gtk_window_resize (GTK_WINDOW(window),cfg->window_width, cfg->window_height);

	icon_pixbuf =  create_pixbuf(icon_name);
	if( icon_pixbuf != NULL ){
		gtk_window_set_icon  ( GTK_WINDOW (window), icon_pixbuf);
	}

	vbox_main = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox_main);
	gtk_container_add (GTK_CONTAINER (window), vbox_main);

	alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
	gtk_widget_show (alignment);
	gtk_box_pack_start (GTK_BOX (vbox_main), alignment, FALSE, FALSE, 0);

	menubar_main = gtk_menu_bar_new ();
	gtk_widget_show (menubar_main);
	gtk_container_add (GTK_CONTAINER (alignment), menubar_main);

	menuitem_file = gtk_menu_item_new_with_mnemonic (_("_File"));
	gtk_widget_show (menuitem_file);
	gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_file);

	menuitem_file_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_file),
				   menuitem_file_menu);

	menu_new =
		gtk_image_menu_item_new_from_stock ("gtk-new", accel_group);
	gtk_widget_show (menu_new);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu), menu_new);

	menu_open =
		gtk_image_menu_item_new_from_stock ("gtk-open", accel_group);
	gtk_widget_show (menu_open);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu), menu_open);

	menu_close = gtk_image_menu_item_new_from_stock ("gtk-close", accel_group);
	gtk_widget_show (menu_close);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu),menu_close);

	//image_menu = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_MENU);
	//gtk_widget_show (image_menu);

	//menu_close_all = gtk_image_menu_item_new_with_label (_("Close all"));
	//gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_close_all), image_menu);
	menu_close_all = gtk_menu_item_new_with_label (_("Close all"));
	gtk_widget_show (menu_close_all);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu),menu_close_all);

	menu_revert_to_saved  = gtk_image_menu_item_new_from_stock ("gtk-revert-to-saved", accel_group);
	gtk_widget_show (menu_revert_to_saved);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu),menu_revert_to_saved);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu),  separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menu_guardar =
		gtk_image_menu_item_new_from_stock ("gtk-save", accel_group);
	gtk_widget_show (menu_guardar);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu), menu_guardar);

	menu_guardar_como =
		gtk_image_menu_item_new_from_stock ("gtk-save-as",  accel_group);
	gtk_widget_show (menu_guardar_como);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu), menu_guardar_como);


	image_menu = gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_MENU);
	gtk_widget_show (image_menu);

	menu_save_all = gtk_image_menu_item_new_with_label (_("Save all"));
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_save_all), image_menu);
	gtk_widget_show (menu_save_all);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu),menu_save_all);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu),  separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menu_salir =
		gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
	gtk_widget_show (menu_salir);
	gtk_container_add (GTK_CONTAINER (menuitem_file_menu), menu_salir);

	menuitem_editar = gtk_menu_item_new_with_mnemonic (_("_Edit"));
	gtk_widget_show (menuitem_editar);
	gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_editar);

	menuitem_editar_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_editar),
				   menuitem_editar_menu);

	menu_undo =
		gtk_image_menu_item_new_from_stock ("gtk-undo", accel_group);
	gtk_widget_show (menu_undo);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_undo);

	menu_redo =
		gtk_image_menu_item_new_from_stock ("gtk-redo", accel_group);
	gtk_widget_show (menu_redo);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_redo);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu),
			   separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	// /////////////// change this variable names to english /// FIXME
	menu_cortar =
		gtk_image_menu_item_new_from_stock ("gtk-cut", accel_group);
	gtk_widget_show (menu_cortar);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_cortar);

	menu_copiar =
		gtk_image_menu_item_new_from_stock ("gtk-copy", accel_group);
	gtk_widget_show (menu_copiar);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_copiar);

	menu_pegar =
		gtk_image_menu_item_new_from_stock ("gtk-paste", accel_group);
	gtk_widget_show (menu_pegar);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_pegar);

	menu_borrar =
		gtk_image_menu_item_new_from_stock ("gtk-delete",
						    accel_group);
	gtk_widget_show (menu_borrar);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_borrar);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu),
			   separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);
	// search & replace
	menu_search =
		gtk_image_menu_item_new_from_stock ("gtk-find", accel_group);
	gtk_widget_show (menu_search);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_search);

	menu_replace =
		gtk_image_menu_item_new_from_stock ("gtk-find-and-replace", accel_group);
	gtk_widget_show (menu_replace);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_replace);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu),
			   separatormenuitem);
	// preferences
	gtk_widget_set_sensitive (separatormenuitem, FALSE);
	menu_preferences = gtk_image_menu_item_new_from_stock ("gtk-preferences",
						    accel_group);
	gtk_widget_show (menu_preferences);
	gtk_container_add (GTK_CONTAINER (menuitem_editar_menu), menu_preferences);
	// /////////////// view menu /////////////////////////////////////////////
	menuitem_view = gtk_menu_item_new_with_mnemonic (_("_View"));
	gtk_widget_show (menuitem_view);
	gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_view);

	menuitem_view_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_view),
				   menuitem_view_menu);

	menu_item_toolbars = gtk_menu_item_new_with_mnemonic (_("_Toolbars"));
	gtk_widget_show (menu_item_toolbars);
	gtk_container_add (GTK_CONTAINER (menuitem_view_menu), menu_item_toolbars);

	menu_toolbars_submenu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item_toolbars),
				   menu_toolbars_submenu);

	menu_toolbar =
		gtk_check_menu_item_new_with_mnemonic (_("View main toolbar"));
	gtk_widget_show (menu_toolbar);
	gtk_container_add (GTK_CONTAINER (menu_toolbars_submenu), menu_toolbar);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_toolbar), TRUE );

	menu_secodary_toolbar =  gtk_check_menu_item_new_with_mnemonic (_("View secondary toolbar"));
	gtk_widget_show (menu_secodary_toolbar);
	gtk_container_add (GTK_CONTAINER (menu_toolbars_submenu), menu_secodary_toolbar);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_secodary_toolbar), TRUE );

	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_view_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menu_zoom_in = 	gtk_image_menu_item_new_from_stock ("gtk-zoom-in", accel_group);
	gtk_widget_show (menu_zoom_in);
	gtk_container_add (GTK_CONTAINER (menuitem_view_menu), menu_zoom_in);

	menu_zoom_out= 	gtk_image_menu_item_new_from_stock ("gtk-zoom-out", accel_group);
	gtk_widget_show (menu_zoom_out);
	gtk_container_add (GTK_CONTAINER (menuitem_view_menu), menu_zoom_out);


	menu_normal_size= 	gtk_image_menu_item_new_from_stock ("gtk-zoom-100", accel_group);
	gtk_widget_show (menu_normal_size);
	gtk_container_add (GTK_CONTAINER (menuitem_view_menu), menu_normal_size);

	// /////////////// document menu /////////////////////////////////////////
	menuitem_ver = gtk_menu_item_new_with_mnemonic (_("_Document"));
	gtk_widget_show (menuitem_ver);
	gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_ver);

	menuitem_ver_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_ver),
				   menuitem_ver_menu);

	menu_ver_line_numbers =
		gtk_check_menu_item_new_with_mnemonic (_("View line _numbers"));
	gtk_widget_show (menu_ver_line_numbers);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menu_ver_line_numbers);

	menu_ver_line_endings =
		gtk_check_menu_item_new_with_mnemonic (_("View line _endings"));
	gtk_widget_show (menu_ver_line_endings);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menu_ver_line_endings);

	menu_ver_white_spaces =
		gtk_check_menu_item_new_with_mnemonic (_("View white _spaces"));
	gtk_widget_show (menu_ver_white_spaces);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menu_ver_white_spaces);

	menu_ver_lines_wrapped =
		gtk_check_menu_item_new_with_mnemonic (_("View lines _wrapped"));
	gtk_widget_show (menu_ver_lines_wrapped);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menu_ver_lines_wrapped);

	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menu_item_autocompletion =
		gtk_check_menu_item_new_with_mnemonic (_("Enable _autocompletion"));
	gtk_widget_show (menu_item_autocompletion);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menu_item_autocompletion);

	menu_item_folding =
		gtk_check_menu_item_new_with_mnemonic (_("Enable _folding"));
	gtk_widget_show (menu_item_folding);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menu_item_folding);

	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	// ~~~~~~~~~~~~~~~~~~~~~~~~~ eols ~~~~~~~~~~~~~~~~~~~~
	menuitem_eol_mode = gtk_menu_item_new_with_mnemonic (_("Set EOL _mode"));
	gtk_widget_show (menuitem_eol_mode);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menuitem_eol_mode);

	menuitem_eol_mode_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_eol_mode),
				   menuitem_eol_mode_menu);

	menuitem_eol_mode_cr =
		gtk_check_menu_item_new_with_mnemonic (_("Mac (C_R)"));
	gtk_widget_show (menuitem_eol_mode_cr);
	gtk_container_add (GTK_CONTAINER (menuitem_eol_mode_menu),
			   menuitem_eol_mode_cr);

	menuitem_eol_mode_lf =
		gtk_check_menu_item_new_with_mnemonic (_("Unix (L_F)"));
	gtk_widget_show (menuitem_eol_mode_lf);
	gtk_container_add (GTK_CONTAINER (menuitem_eol_mode_menu),
			   menuitem_eol_mode_lf);

	menuitem_eol_mode_crlf =
		gtk_check_menu_item_new_with_mnemonic (_
						 ("Dos / Windows (_CR/LF)"));
	gtk_widget_show (menuitem_eol_mode_crlf);
	gtk_container_add (GTK_CONTAINER (menuitem_eol_mode_menu),
			   menuitem_eol_mode_crlf);

	menuitem_folding = gtk_menu_item_new_with_mnemonic (_("Fol_ding"));
	gtk_widget_show (menuitem_folding);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menuitem_folding);

	menuitem_folding_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_folding),
				   menuitem_folding_menu);

	menuitem_fonding_foldall =
		gtk_menu_item_new_with_mnemonic (_("_Fold all"));
	gtk_widget_show (menuitem_fonding_foldall);
	gtk_container_add (GTK_CONTAINER (menuitem_folding_menu),
			   menuitem_fonding_foldall);

	menuitem_folding_unfoldall =
		gtk_menu_item_new_with_mnemonic (_("_Unfold all"));
	gtk_widget_show (menuitem_folding_unfoldall);
	gtk_container_add (GTK_CONTAINER (menuitem_folding_menu),
			   menuitem_folding_unfoldall);
	// highlighting
	menuitem_highlighting = gtk_menu_item_new_with_mnemonic (_("_Highlighting"));
	gtk_widget_show (menuitem_highlighting);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menuitem_highlighting);

	menuitem_highlighting_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_highlighting),
				   menuitem_highlighting_menu);

	menuitem_highlighting_text =
		gtk_menu_item_new_with_mnemonic (_("_Plain text"));
	gtk_widget_show (menuitem_highlighting_text);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_text);

	menuitem_highlighting_css =
		gtk_menu_item_new_with_mnemonic ("_CSS");
	gtk_widget_show (menuitem_highlighting_css);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_css);

	menuitem_highlighting_html =
		gtk_menu_item_new_with_mnemonic ("_HTML/PHP");
	gtk_widget_show (menuitem_highlighting_html);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_html);

	menuitem_highlighting_sh =
		gtk_menu_item_new_with_mnemonic ("_SH");
	gtk_widget_show (menuitem_highlighting_sh);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_sh);

	menuitem_highlighting_c =
		gtk_menu_item_new_with_mnemonic ("C / C_PP");
	gtk_widget_show (menuitem_highlighting_c);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_c);

	menuitem_highlighting_apache_conf =
		gtk_menu_item_new_with_mnemonic ("_Apache / .htaccess");
	gtk_widget_show (menuitem_highlighting_apache_conf);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_apache_conf);

	menuitem_highlighting_perl =
		gtk_menu_item_new_with_mnemonic ("PER_L");
	gtk_widget_show (menuitem_highlighting_perl);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_perl);

	menuitem_highlighting_python =
		gtk_menu_item_new_with_mnemonic ("P_ython");
	gtk_widget_show (menuitem_highlighting_python);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_python);

	menuitem_highlighting_xml =
		gtk_menu_item_new_with_mnemonic ("_XML");
	gtk_widget_show (menuitem_highlighting_xml);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_xml);

	menuitem_highlighting_diff   =
		gtk_menu_item_new_with_mnemonic ("_Diff/Patch");
	gtk_widget_show (menuitem_highlighting_diff);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_diff);

	menuitem_highlighting_make =
		gtk_menu_item_new_with_mnemonic ("_Makefile");
	gtk_widget_show (menuitem_highlighting_make);
	gtk_container_add (GTK_CONTAINER (menuitem_highlighting_menu),
			   menuitem_highlighting_make);

	// encoding
	menuitem_encoding = gtk_menu_item_new_with_mnemonic (_("_Force Encoding"));
	gtk_widget_show (menuitem_encoding);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menuitem_encoding);

	menuitem_encoding_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_encoding),
				   menuitem_encoding_menu);

	menuitem_encoding_default =
		gtk_menu_item_new_with_mnemonic (_("_Default"));
	gtk_widget_show (menuitem_encoding_default);
	gtk_container_add (GTK_CONTAINER (menuitem_encoding_menu),
			   menuitem_encoding_default);

	menuitem_encoding_utf8 =
		gtk_menu_item_new_with_mnemonic ("_UTF8");
	gtk_widget_show (menuitem_encoding_utf8);
	gtk_container_add (GTK_CONTAINER (menuitem_encoding_menu),
			   menuitem_encoding_utf8);

	menuitem_encoding_dbcs =
		gtk_menu_item_new_with_mnemonic ("D_BCS");
	gtk_widget_show (menuitem_encoding_dbcs);
	gtk_container_add (GTK_CONTAINER (menuitem_encoding_menu),
			   menuitem_encoding_dbcs);
	// charset
	menuitem_charset = gtk_menu_item_new_with_mnemonic (_("C_haracter set"));
	gtk_widget_show (menuitem_charset);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu), menuitem_charset);

	menuitem_charset_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_charset), menuitem_charset_menu);

	menuitem_charset_ansi =	gtk_menu_item_new_with_mnemonic (_("_ANSI"));
	gtk_widget_show (menuitem_charset_ansi);
	gtk_container_add (GTK_CONTAINER (menuitem_charset_menu),  menuitem_charset_ansi);

	menuitem_charset_easteurope =	gtk_menu_item_new_with_mnemonic (_("_East Europe"));
	gtk_widget_show (menuitem_charset_easteurope);
	gtk_container_add (GTK_CONTAINER (menuitem_charset_menu),  menuitem_charset_easteurope);

	menuitem_charset_gb2312 =	gtk_menu_item_new_with_mnemonic (_("_GB 2312"));
	gtk_widget_show (menuitem_charset_gb2312);
	gtk_container_add (GTK_CONTAINER (menuitem_charset_menu),  menuitem_charset_gb2312);

	menuitem_charset_hangul =	gtk_menu_item_new_with_mnemonic (_("_Hangul"));
	gtk_widget_show (menuitem_charset_hangul);
	gtk_container_add (GTK_CONTAINER (menuitem_charset_menu),  menuitem_charset_hangul);

	menuitem_charset_shiftjis =	gtk_menu_item_new_with_mnemonic (_("_Shift JIS"));
	gtk_widget_show (menuitem_charset_shiftjis);
	gtk_container_add (GTK_CONTAINER (menuitem_charset_menu),  menuitem_charset_shiftjis);

	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	// change font
	menu_item_font =
		gtk_menu_item_new_with_mnemonic (_("_Change font"));
	gtk_widget_show (menu_item_font);
	gtk_container_add (GTK_CONTAINER (menuitem_ver_menu),
			   menu_item_font);
	// ////////////  CSS dialogs menu created  in //////
	// ////////////  cssdialogs-menu.c /////////////////
	css_dialogs_item = gtk_menu_item_new_with_mnemonic (_("_CSS"));
    gtk_widget_show (css_dialogs_item);

	css_dialogs_submenu = gtk_menu_item_new_with_mnemonic (_("Dialogs"));
 	gtk_widget_show (css_dialogs_submenu);

	css_menu_accels = gtk_accel_group_new();
	css_menu = create_css_dialogs_menu	(windowobj, css_menu_accels );
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (css_dialogs_submenu), css_menu);

	css_dialogs_mainmenu = gtk_menu_new();
	gtk_container_add (GTK_CONTAINER (css_dialogs_mainmenu),
			   css_dialogs_submenu);

	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (css_dialogs_mainmenu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menuitem_selector_wizard = gtk_image_menu_item_new_with_mnemonic (_("_Selector wizard"));
	image_menu = create_pixmap(NULL, "selector_wizard_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menuitem_selector_wizard),
									image_menu);
	gtk_widget_show (menuitem_selector_wizard);
	gtk_container_add (GTK_CONTAINER (css_dialogs_mainmenu), menuitem_selector_wizard);

	menuitem_color_wizard = gtk_image_menu_item_new_with_mnemonic (_("_Color wizard"));
	image_menu = create_pixmap(NULL, "color_wizard_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menuitem_color_wizard),
									image_menu);
	gtk_widget_show (menuitem_color_wizard);
	gtk_container_add (GTK_CONTAINER (css_dialogs_mainmenu), menuitem_color_wizard);

	menuitem_box_wizard = gtk_image_menu_item_new_with_mnemonic (_("_Box properties wizard"));
	image_menu = create_pixmap(NULL, "dlg_box_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menuitem_box_wizard),
									image_menu);
	gtk_widget_show (menuitem_box_wizard);
	gtk_container_add (GTK_CONTAINER (css_dialogs_mainmenu), menuitem_box_wizard);

	gtk_menu_item_set_submenu (GTK_MENU_ITEM (css_dialogs_item), css_dialogs_mainmenu);
	gtk_menu_bar_append(menubar_main,css_dialogs_item);

	// ////////////////////////// Utils //////////////////////////////
	menuitem_utils = gtk_menu_item_new_with_mnemonic (_("_Tools"));
	gtk_widget_show (menuitem_utils);
	gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_utils);

	menuitem_utils_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_utils),
				   menuitem_utils_menu);

	menu_utils_scan_selector =
		gtk_image_menu_item_new_with_mnemonic (_("_Scan selector"));
	image_menu = create_pixmap(NULL, "scan_selector_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menu_utils_scan_selector),
									image_menu);
	gtk_widget_show (menu_utils_scan_selector);
	gtk_container_add (GTK_CONTAINER (menuitem_utils_menu),
			   menu_utils_scan_selector);


	menu_utils_doc_info = gtk_image_menu_item_new_with_mnemonic (_("_Doc Info"));
	image_menu = create_pixmap(NULL, "document_info_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menu_utils_doc_info),
									image_menu);
	gtk_widget_show (menu_utils_doc_info);
	gtk_container_add (GTK_CONTAINER (menuitem_utils_menu), menu_utils_doc_info);

	menu_utils_autocomp  = gtk_menu_item_new_with_mnemonic (_("Show _autocompletion"));
	gtk_widget_show (menu_utils_autocomp);
	gtk_container_add (GTK_CONTAINER (menuitem_utils_menu),
			   menu_utils_autocomp);

	menu_utils_cleanoutput = gtk_image_menu_item_new_with_mnemonic (_("_Clean program output"));
	image_menu = gtk_image_new_from_stock( "gtk-clear", GTK_ICON_SIZE_MENU );
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menu_utils_cleanoutput),
									image_menu);
	gtk_widget_show (menu_utils_cleanoutput);
	gtk_container_add (GTK_CONTAINER (menuitem_utils_menu),
						menu_utils_cleanoutput);
	/* validator */
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_utils_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menu_utils_validate = gtk_image_menu_item_new_with_mnemonic (_("_Validate and dump"));
	image_menu = create_pixmap(NULL, "validate_dump_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menu_utils_validate),
									image_menu);
	gtk_widget_show (menu_utils_validate);
	gtk_container_add (GTK_CONTAINER (menuitem_utils_menu),
			   menu_utils_validate);


	menu_utils_validate_only = gtk_image_menu_item_new_with_mnemonic (_("Validate _only"));
	image_menu = create_pixmap(NULL, "validate_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menu_utils_validate_only),
									image_menu);
	gtk_widget_show (menu_utils_validate_only);
	gtk_container_add (GTK_CONTAINER (menuitem_utils_menu),
			   menu_utils_validate_only);

	/* panels */
	menuitem_panel = gtk_menu_item_new_with_mnemonic (_("_Panels"));
	gtk_widget_show (menuitem_panel);
	gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_panel);

	menuitem_panel_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_panel),
				   menuitem_panel_menu);

	menuitem_show_footer_panel = gtk_image_menu_item_new_with_mnemonic (_("Show _footer panel"));
	image_menu = create_pixmap(NULL, "show_footer_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menuitem_show_footer_panel),
									image_menu);
	gtk_widget_show (menuitem_show_footer_panel);
	gtk_container_add (GTK_CONTAINER (menuitem_panel_menu), menuitem_show_footer_panel);

	menuitem_hide_footer_panel = gtk_image_menu_item_new_with_mnemonic (_("Hide footer _panel"));
	image_menu = create_pixmap(NULL, "hide_footer_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menuitem_hide_footer_panel),
									image_menu);
	gtk_widget_show (menuitem_hide_footer_panel);
	gtk_container_add (GTK_CONTAINER (menuitem_panel_menu), menuitem_hide_footer_panel);

	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_panel_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menuitem_show_side_panel = gtk_image_menu_item_new_with_mnemonic (_("_Show side panel"));
	image_menu = create_pixmap(NULL, "show_sidebar_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menuitem_show_side_panel),
									image_menu);
	gtk_widget_show (menuitem_show_side_panel);
	gtk_container_add (GTK_CONTAINER (menuitem_panel_menu), menuitem_show_side_panel);

	menuitem_hide_side_panel = gtk_image_menu_item_new_with_mnemonic (_("_Hide side panel"));
	image_menu = create_pixmap(NULL, "hide_sidebar_menu.png");
	gtk_widget_show(image_menu);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(menuitem_hide_side_panel),
									image_menu);
	gtk_widget_show (menuitem_hide_side_panel);
	gtk_container_add (GTK_CONTAINER (menuitem_panel_menu), menuitem_hide_side_panel);
	// plugins menu ////////////////////////////////////////////////////////////
#ifdef WITH_PLUGINS
	if( g_module_supported() ){
		menuitem_plugins = gtk_menu_item_new_with_mnemonic (_("_Plugins"));
		gtk_widget_show (menuitem_plugins);
		gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_plugins);

		menuitem_plugins_menu = gtk_menu_new ();
		gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_plugins),
				   menuitem_plugins_menu);

		menuitem_plugins_load = gtk_menu_item_new_with_mnemonic (_("_View plugins"));
		gtk_widget_show (menuitem_plugins_load);
		gtk_container_add (GTK_CONTAINER (menuitem_plugins_menu),
						menuitem_plugins_load);

		// separator
		separatormenuitem = gtk_menu_item_new ();
		gtk_widget_show (separatormenuitem);
		gtk_container_add (GTK_CONTAINER (menuitem_plugins_menu), separatormenuitem);
		gtk_widget_set_sensitive (separatormenuitem, FALSE);
	}
#endif
	// help menu ///////////////////////////////////////////////////////////////
	menuitem_ayuda = gtk_menu_item_new_with_mnemonic (_("_Help"));
	gtk_widget_show (menuitem_ayuda);
	gtk_container_add (GTK_CONTAINER (menubar_main), menuitem_ayuda);

	menuitem_ayuda_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_ayuda),
				   menuitem_ayuda_menu);

/*  For future use, don't delete me please ;-)
	menu_cssed_help = gtk_menu_item_new_with_mnemonic (_("Cssed _help"));
	gtk_widget_show (menu_cssed_help);
	gtk_container_add (GTK_CONTAINER (menuitem_ayuda_menu), menu_cssed_help);
*/
	menu_about = gtk_menu_item_new_with_mnemonic (_("_About"));
	gtk_widget_show (menu_about);
	gtk_container_add (GTK_CONTAINER (menuitem_ayuda_menu), menu_about);

#ifdef WITH_HELP_MENUS
	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_ayuda_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);

	menuitem_cssed_website = gtk_menu_item_new_with_mnemonic (_("Cssed _web site"));
	gtk_widget_show (menuitem_cssed_website);
	gtk_container_add (GTK_CONTAINER (menuitem_ayuda_menu), menuitem_cssed_website);

	menuitem_cssed_website_menu = gtk_menu_new();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_cssed_website), menuitem_cssed_website_menu);

#ifdef DARWIN
	menuitem_cssed_website_with_safari = gtk_menu_item_new_with_mnemonic (_("With _Safari"));
	gtk_widget_show (menuitem_cssed_website_with_safari);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_website_menu), menuitem_cssed_website_with_safari);

	menuitem_cssed_website_with_firefox = gtk_menu_item_new_with_mnemonic (_("With _Firefox"));
	gtk_widget_show (menuitem_cssed_website_with_firefox);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_website_menu), menuitem_cssed_website_with_firefox);

	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_website_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);
#endif

	menuitem_cssed_website_with_mozilla = gtk_menu_item_new_with_mnemonic (_("With _Mozilla"));
	gtk_widget_show (menuitem_cssed_website_with_mozilla);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_website_menu), menuitem_cssed_website_with_mozilla);

	menuitem_cssed_website_with_galeon = gtk_menu_item_new_with_mnemonic (_("With G_aleon"));
	gtk_widget_show (menuitem_cssed_website_with_galeon);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_website_menu), menuitem_cssed_website_with_galeon);

	menuitem_cssed_website_with_dillo = gtk_menu_item_new_with_mnemonic (_("With _Dillo"));
	gtk_widget_show (menuitem_cssed_website_with_dillo);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_website_menu), menuitem_cssed_website_with_dillo);

	menuitem_cssed_website_with_gnome = gtk_menu_item_new_with_mnemonic (_("With _Gnome"));
	gtk_widget_show (menuitem_cssed_website_with_gnome);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_website_menu), menuitem_cssed_website_with_gnome);

	menuitem_cssed_doc_online = gtk_menu_item_new_with_mnemonic (_("Cssed _documentation on line"));
	gtk_widget_show (menuitem_cssed_doc_online);
	gtk_container_add (GTK_CONTAINER (menuitem_ayuda_menu), menuitem_cssed_doc_online);

	menuitem_cssed_doc_online_menu = gtk_menu_new();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_cssed_doc_online), menuitem_cssed_doc_online_menu);

#ifdef DARWIN
	menuitem_cssed_doc_online_with_safari = gtk_menu_item_new_with_mnemonic (_("With _Safari"));
	gtk_widget_show (menuitem_cssed_doc_online_with_safari);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_doc_online_menu), menuitem_cssed_doc_online_with_safari);

	menuitem_cssed_doc_online_with_firefox = gtk_menu_item_new_with_mnemonic (_("With _Firefox"));
	gtk_widget_show (menuitem_cssed_doc_online_with_firefox);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_doc_online_menu), menuitem_cssed_doc_online_with_firefox);

	// separator
	separatormenuitem = gtk_menu_item_new ();
	gtk_widget_show (separatormenuitem);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_doc_online_menu), separatormenuitem);
	gtk_widget_set_sensitive (separatormenuitem, FALSE);
#endif

	menuitem_cssed_doc_online_with_mozilla = gtk_menu_item_new_with_mnemonic (_("With _Mozilla"));
	gtk_widget_show (menuitem_cssed_doc_online_with_mozilla);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_doc_online_menu), menuitem_cssed_doc_online_with_mozilla);

	menuitem_cssed_doc_online_with_galeon = gtk_menu_item_new_with_mnemonic (_("With G_aleon"));
	gtk_widget_show (menuitem_cssed_doc_online_with_galeon);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_doc_online_menu), menuitem_cssed_doc_online_with_galeon);

	menuitem_cssed_doc_online_with_dillo = gtk_menu_item_new_with_mnemonic (_("With _Dillo"));
	gtk_widget_show (menuitem_cssed_doc_online_with_dillo);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_doc_online_menu), menuitem_cssed_doc_online_with_dillo);

	menuitem_cssed_doc_online_with_gnome = gtk_menu_item_new_with_mnemonic (_("With _Gnome"));
	gtk_widget_show (menuitem_cssed_doc_online_with_gnome);
	gtk_container_add (GTK_CONTAINER (menuitem_cssed_doc_online_menu), menuitem_cssed_doc_online_with_gnome);
#endif /* #ifdef WITH_HELP_MENUS */

	//  main toolbar ///////////////////////////////////////////////////////////
	toolbar_main = gtk_toolbar_new ();
	gtk_widget_show (toolbar_main);
	gtk_box_pack_start (GTK_BOX (vbox_main), toolbar_main, FALSE, FALSE, 0);
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar_main), GTK_TOOLBAR_ICONS);

	button_nuevo =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-new", _("New"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_nuevo);

	button_abrir =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-open", _("Open..."), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_abrir);

	button_guardar =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-save", _("Save"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_guardar);

	// set it initially grayed ( insensitive )
	gtk_widget_set_sensitive( GTK_WIDGET( button_guardar ), FALSE );

	button_guardarcomo =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-save-as", _("Save As..."), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_guardarcomo);

	button_cerrar =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-close", _("Close"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_cerrar);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_main));

	button_cortar =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-cut", _("Cut"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_cortar);

	button_copiar =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-copy", _("Copy"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_copiar);

	button_pegar =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-paste", _("Paste"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_pegar);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_main));

	button_buscar =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-find", _("Find..."), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_buscar);

	button_reemplazar =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-find-and-replace", _("Replace..."), NULL,
					  NULL, NULL, -1);
	gtk_widget_show (button_reemplazar);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_main));

	button_undo =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-undo", _("Undo"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_undo);

	button_redo =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-redo", _("Redo"), NULL, NULL, NULL,
					  -1);
	gtk_widget_show (button_redo);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_main));

	// next prev for bookmarks
	button_prev =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-go-back", _("Previous Bookmark"), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_guardarcomo);

	button_next =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-go-forward", _("Next Bookmark"), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_guardarcomo);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_main));

	//  zoom in toolbar //////////
	/*
	button_zoom_in =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-zoom-in", _("Bigger Font Size"), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_zoom_in);

	button_zoom_out =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-zoom-out", _("Smaller Font Size"), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_zoom_out);

	button_zoom_off =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-zoom-100", _("Default Font Size"), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_zoom_off);
	*/
	tt_icon = create_pixmap (NULL,"hide_sidebar.png");
	button_hide_side =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_main),
                                         _("Hide sidebar"),
                                         _("Hide sidebar"),
                                         _("Hide the right sidebar"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_hide_side);

	tt_icon = create_pixmap (NULL,"show_sidebar.png");
	button_show_side =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_main),
                                         _("Show sidebar"),
                                         _("Show sidebar"),
                                         _("Show the right sidebar"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_show_side);

	tt_icon = create_pixmap (NULL,"hide_footer.png");
	button_hide_footer =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_main),
                                         _("Hide footer"),
                                         _("Hide footer"),
                                         _("Hide the footer panel"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_hide_footer);

	tt_icon = create_pixmap (NULL,"show_footer.png");
	button_show_footer =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_main),
                                         _("Show footer"),
                                         _("Show footer"),
                                         _("Show the footer panel"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_show_footer);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_main));
	// prefs /////////////
	button_preferences = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_main),
					  "gtk-preferences", _("Preferences"), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_preferences);
	// secondary toolbar ///////////////////////////////////////////////////////
	toolbar_tools = gtk_toolbar_new ();
	gtk_widget_show (toolbar_tools);
	gtk_box_pack_start (GTK_BOX (vbox_main), toolbar_tools, FALSE, FALSE, 0);
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar_tools), GTK_TOOLBAR_ICONS);

	tt_icon = create_pixmap (NULL,"dlg_margin.png");
	button_margin_all =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Margin all"),
                                         _("Show the margin all dialog"),
                                         _("Show the margin all dialog"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_margin_all);

	tt_icon = create_pixmap (NULL,"dlg_border.png");
	button_border_all =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Border all"),
                                         _("Show the border all dialog"),
                                         _("Show the border all dialog"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_border_all);

	tt_icon = create_pixmap (NULL,"dlg_padding.png");
	button_padding_all =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Padding all"),
                                         _("Show the padding all dialog"),
                                         _("Show the padding all dialog"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_padding_all);

	tt_icon = create_pixmap (NULL,"dlg_box.png");
	button_box_properties =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Box properties wizard"),
                                         _("Show the box properties wizard"),
                                         _("Show the box properties wizard"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_box_properties);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_tools));

	tt_icon = create_pixmap (NULL,"font.png");
	button_font =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Font"),
                                         _("Show the font dialog"),
                                         _("Show the font dialog"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_font);

	button_color =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_tools),
					  "gtk-select-color", _("Choose Color"), NULL,
					  NULL, NULL, -1);
	gtk_widget_show (button_color);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_tools));

	tt_icon = create_pixmap (NULL,"selector_wizard.png");
	button_sel_wizard =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Selector wizard"),
                                         _("Show the Selector wizard"),
                                         _("Show the Selector wizard"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_sel_wizard);

	tt_icon = create_pixmap (NULL,"color_wizard.png");
	button_col_wizard =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Color wizard"),
                                         _("Show the Color wizard"),
                                         _("Show the Color wizard"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_col_wizard);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_tools));

	tt_icon = create_pixmap (NULL,"scan_selector.png");
	button_scan_selector =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Scan selector"),
                                         _("Scan the current selector to be shown in the side panel"),
                                         _("Scan the current selector to be shown in the side panel"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_scan_selector);

	tt_icon = create_pixmap (NULL,"document_info.png");
	button_doc_info =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Document info"),
                                         _("Show information about the current document"),
                                         _("Show information about the current document"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_doc_info);

	button_clean_output =
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar_tools),
					  "gtk-clear", _("Clean program output"), NULL, NULL,
					  NULL, -1);
	gtk_widget_show (button_clean_output);

	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_tools));

	tt_icon = create_pixmap (NULL,"validate.png");
	button_validate =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Validate"),
                                         _("Validate current document"),
                                         _("Validate current document"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_validate);

	tt_icon = create_pixmap (NULL,"validate_dump.png");
	button_validate_dump =
		gtk_toolbar_append_item         (GTK_TOOLBAR (toolbar_tools),
                                         _("Validate and dump"),
                                         _("Validate and dump current document"),
                                         _("Validate and dump current document"),
										 tt_icon,
                                         NULL,
                                         NULL);
	gtk_widget_show (button_validate_dump);

	//  paned //////////////////////////////////////////////////////////////////
	vpaned_main = gtk_vpaned_new ();
	gtk_widget_show (vpaned_main);
	gtk_box_pack_start (GTK_BOX (vbox_main), vpaned_main, TRUE, TRUE, 0);

	hpaned_main = gtk_hpaned_new ();
	gtk_widget_show (hpaned_main);
	gtk_paned_pack1 (GTK_PANED (vpaned_main), hpaned_main, TRUE, TRUE);
	gtk_paned_set_position (GTK_PANED (hpaned_main), 450);
	// ////////////// notebook_docs ////////////////////////////////////////////
	notebook_docs = gtk_notebook_new ();
	gtk_widget_show (notebook_docs);
	gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook_docs), TRUE);
	gtk_notebook_popup_enable (GTK_NOTEBOOK (notebook_docs));
	gtk_paned_pack1 (GTK_PANED (hpaned_main), notebook_docs, TRUE, TRUE);

	// //////////////// notebook footer ////////////////////////////////////////
	notebook_footer = gtk_notebook_new ();
	// /////////// set win object settings before creating any doc /////////////
	cssed_window_set_document_notebook( windowobj, notebook_docs );
	cssed_window_set_footer_notebook( windowobj, notebook_footer );
	cssed_window_dynamic_menus_set_full( 	windowobj,
											menu_ver_line_numbers,
											menu_ver_line_endings,
											menu_ver_white_spaces,
											menu_ver_lines_wrapped,
											menuitem_eol_mode_cr,
											menuitem_eol_mode_lf,
											menuitem_eol_mode_crlf,
											menu_item_autocompletion,
											menu_item_folding );

	// //////////////////////////////////////////////////////////////////////
	// we need to fill the window->keyword list before creating an editor,
	// if we don't do that the initial editor will have
	// no keywords to style so first of all we create and fill
	// the tree. will be show later.
	treeview_css_properties = gtk_tree_view_new ();
	// this must be set after the xmlparser runs. It could need to
	// write to output
	output_list = gtk_tree_view_new ();
	cssed_window_set_output_treeview ( windowobj, GTK_WIDGET(output_list) );
	output_render = gtk_cell_renderer_text_new ();
	output_column =	gtk_tree_view_column_new_with_attributes ("", output_render, "markup", 0, NULL);
	gtk_tree_view_insert_column (GTK_TREE_VIEW (output_list), output_column, 0);
	output_store = gtk_list_store_new (1, G_TYPE_STRING);
	gtk_tree_view_set_model (GTK_TREE_VIEW (output_list), GTK_TREE_MODEL (output_store));
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (output_list),	   FALSE);
	// this func will fill the treeview
	// we must fill the window->treeview_css_properties before
	// trying to fill the tree
	cssed_window_set_css_definition_treeview( windowobj, GTK_WIDGET(treeview_css_properties) );
	set_css_properties_treeview (windowobj);
	// the same can be applied to the selector scanner
	treeview_css_current = gtk_tree_view_new ();
	cssed_window_set_selector_scanner_treeview( windowobj, GTK_WIDGET(treeview_css_current));
	// and also for the document scanner list
	document_scanner_treeview = gtk_tree_view_new();
	cssed_window_set_digest_treeview ( windowobj, document_scanner_treeview );
	// those widgets are enabled disabled by the app
	cssed_window_dynamic_widgets_set(	windowobj,
										button_guardar, menu_guardar,
										button_undo, menu_undo, pop_menu_undo,
										button_redo, menu_redo, pop_menu_redo );

// now we can create and stylised editor
	create_and_attach_new_doc( windowobj, _("Untitled"));
/*	editor = create_initial_blank_editor (windowobj);

	gtk_widget_show (editor);
	gtk_container_add (GTK_CONTAINER (notebook_docs), editor);
	GTK_WIDGET_SET_FLAGS (editor, GTK_CAN_FOCUS);
	GTK_WIDGET_SET_FLAGS (editor, GTK_CAN_DEFAULT);


	label_notebook_blank = gtk_label_new (_("Untitled"));
	gtk_widget_show (label_notebook_blank);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook_docs),
				    gtk_notebook_get_nth_page (GTK_NOTEBOOK
							       (notebook_docs),
							       0),
				    label_notebook_blank);
	gtk_label_set_justify (GTK_LABEL (label_notebook_blank),
			       GTK_JUSTIFY_LEFT);
*/
	// document scanner // ( digest ) ///////////////////////////////////////////////////
	document_scanner_store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	gtk_tree_view_set_model(GTK_TREE_VIEW(document_scanner_treeview),
										GTK_TREE_MODEL(document_scanner_store));

	gtk_widget_show (document_scanner_treeview);
	document_scanner_render	= gtk_cell_renderer_text_new();

	document_scanner_column_numbers = gtk_tree_view_column_new_with_attributes (
								_("Line"),
							  document_scanner_render, "markup", 0, NULL);
	document_scanner_column = gtk_tree_view_column_new_with_attributes (_("Styles"),
							  document_scanner_render, "markup", 1, NULL);


	gtk_tree_view_insert_column (GTK_TREE_VIEW (document_scanner_treeview),
				     document_scanner_column_numbers, 0);
	gtk_tree_view_insert_column (GTK_TREE_VIEW (document_scanner_treeview),
				     document_scanner_column, 1);


	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW (document_scanner_treeview),
									TRUE);
	gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW (document_scanner_treeview),
									TRUE);


	gtk_tree_sortable_set_sort_func( GTK_TREE_SORTABLE( document_scanner_store ),
									0, tree_iter_doc_scanner_compare_string,
									GINT_TO_POINTER(0), NULL);

	gtk_tree_sortable_set_sort_func( GTK_TREE_SORTABLE( document_scanner_store ),
									1, tree_iter_doc_scanner_compare_string,
									GINT_TO_POINTER(1), NULL);

	document_scanner_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(document_scanner_scrolled_window);

	gtk_container_add (GTK_CONTAINER (document_scanner_scrolled_window),
			   document_scanner_treeview);

	document_scanner_vbox = gtk_vbox_new(TRUE,0);
	gtk_box_set_homogeneous(GTK_BOX(document_scanner_vbox), FALSE);

	gtk_widget_show(document_scanner_vbox);
	document_scanner_button = gtk_button_new_with_label(_("Parse document"));
	gtk_widget_show(document_scanner_button);

	gtk_box_pack_start(GTK_BOX(document_scanner_vbox),document_scanner_button,
                       FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(document_scanner_vbox),document_scanner_scrolled_window,
                       TRUE, TRUE, 0);

	// sidebar notebook ////////////////////////////////////////////////////////
	sidebar_notebook = gtk_notebook_new();
	gtk_widget_show (sidebar_notebook);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(sidebar_notebook),GTK_POS_BOTTOM);
	// add to window structure
	cssed_window_set_sidebar_notebook ( windowobj, sidebar_notebook );

	vpaned_css = gtk_vpaned_new ();
	gtk_widget_show (vpaned_css);
	gtk_paned_pack2 (GTK_PANED (hpaned_main), sidebar_notebook, FALSE, TRUE);

	scrolledwindow_cssc = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow_cssc);
	gtk_paned_pack1 (GTK_PANED (vpaned_css), scrolledwindow_cssc, FALSE,
			 TRUE);

	gtk_notebook_append_page(GTK_NOTEBOOK(sidebar_notebook), GTK_WIDGET(vpaned_css),
							gtk_label_new("CSS"));
	gtk_notebook_append_page(GTK_NOTEBOOK(sidebar_notebook), GTK_WIDGET(document_scanner_vbox),
							gtk_label_new(_("Digest")));

	// Current selector list is added here to a container
	gtk_widget_show (treeview_css_current);
	gtk_container_add (GTK_CONTAINER (scrolledwindow_cssc),
			   				treeview_css_current);

	// current css selector list
	current_css_render_properties = gtk_cell_renderer_text_new ();
	current_css_render_values = gtk_cell_renderer_text_new ();
	current_css_render_pixbuf = gtk_cell_renderer_pixbuf_new();

	g_object_set(G_OBJECT(current_css_render_values), "editable", TRUE, NULL);

	current_css_property_column =
		gtk_tree_view_column_new_with_attributes (_("Property"),
							  current_css_render_properties,
							  "text", 0, NULL);
	gtk_tree_view_column_set_resizable(
						GTK_TREE_VIEW_COLUMN(current_css_property_column),
                        TRUE);

	current_css_value_column = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title  (GTK_TREE_VIEW_COLUMN(current_css_value_column),
                                     _("Value"));
	gtk_tree_view_column_pack_start (GTK_TREE_VIEW_COLUMN(current_css_value_column),
                                             current_css_render_values,
                                             TRUE);
	gtk_tree_view_column_set_attributes  (GTK_TREE_VIEW_COLUMN(current_css_value_column),
                                        current_css_render_values,
                                        "text",
                                        1, NULL);
	gtk_tree_view_column_set_resizable(
						GTK_TREE_VIEW_COLUMN(current_css_value_column),
                        TRUE);

	current_arrow_column =
		gtk_tree_view_column_new_with_attributes(" ",
							current_css_render_pixbuf,
							"pixbuf",2, NULL);
	gtk_tree_view_column_set_resizable(
						GTK_TREE_VIEW_COLUMN(current_arrow_column),
                        FALSE);
	gtk_tree_view_column_set_sizing (
							GTK_TREE_VIEW_COLUMN(current_arrow_column),
							GTK_TREE_VIEW_COLUMN_FIXED);
	 gtk_tree_view_column_set_fixed_width(
							GTK_TREE_VIEW_COLUMN(current_arrow_column),
                            10);

	gtk_tree_view_insert_column (GTK_TREE_VIEW (treeview_css_current),
				     		current_css_property_column, 0);
	gtk_tree_view_insert_column (GTK_TREE_VIEW (treeview_css_current),
				     		current_css_value_column, 1);
	gtk_tree_view_insert_column (GTK_TREE_VIEW (treeview_css_current),
				    		 current_arrow_column, 2);

	current_css_store =
		gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, GDK_TYPE_PIXBUF);

	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview_css_current),
							 GTK_TREE_MODEL (current_css_store));
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW
					  		 (treeview_css_current), TRUE);

	scrolledwindow_cssp = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow_cssp);
	gtk_paned_pack2 (GTK_PANED (vpaned_css), scrolledwindow_cssp, TRUE, TRUE);
	gtk_widget_set_size_request (scrolledwindow_cssp, 100, 100);

	// HERE THE CSS PROPERTIES TREE VIEW IS ADDED to a container ///////////////
	gtk_widget_show (treeview_css_properties);
	gtk_container_add (GTK_CONTAINER (scrolledwindow_cssp),
			   treeview_css_properties);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview_css_properties),
				      TRUE);
	// add panes to windowobj
	cssed_window_panes_set(	windowobj, vpaned_main, hpaned_main, vpaned_css );
	/* expand the css properties tree on path "0" */
	css_prop_path = gtk_tree_path_new_first();
	gtk_tree_view_expand_row (GTK_TREE_VIEW (treeview_css_properties),
                              css_prop_path, FALSE);
	gtk_drag_source_unset( treeview_css_properties ); // avoid DnD

	// Footer notebook was created above
	gtk_widget_show (notebook_footer);
	gtk_paned_pack2 (GTK_PANED (vpaned_main), notebook_footer, TRUE, TRUE);

	scrolledwindow_output_text = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow_output_text);

	// OUTPUT LIST is added here to a container

	gtk_widget_show (output_list);
	gtk_container_add (GTK_CONTAINER (scrolledwindow_output_text), output_list);
	gtk_container_add (GTK_CONTAINER (notebook_footer),
			   scrolledwindow_output_text);

// ///////////////////////////////////////
	scratch_tips = gtk_tooltips_new ();
	hpaned_scratch = gtk_hpaned_new();
	gtk_widget_show (hpaned_scratch);

	scrolledwindow_drop_text = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow_drop_text);

	drop_text = gtk_text_view_new ();
	gtk_text_view_set_editable (GTK_TEXT_VIEW (drop_text), TRUE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW (drop_text), GTK_WRAP_WORD);
	gtk_widget_show (drop_text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow_drop_text),  drop_text);

	scrolledwindow_scratch_text = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow_scratch_text);
	scratch_text = gtk_text_view_new ();
	// set the scratch pad in the window object
	cssed_window_set_scratch_buffer( windowobj, gtk_text_view_get_buffer( GTK_TEXT_VIEW(scratch_text) ) );
	gtk_text_view_set_editable (GTK_TEXT_VIEW (scratch_text), TRUE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW (scratch_text), GTK_WRAP_WORD);
	// load file contents if any
	scratch_pad_load_contents(  cssed_window_get_scratch_buffer( windowobj ) );
	gtk_widget_show (scratch_text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow_scratch_text), scratch_text);
	// add to paned
	gtk_paned_pack1 ( GTK_PANED (hpaned_scratch), scrolledwindow_drop_text, TRUE, TRUE);
	gtk_paned_pack2 ( GTK_PANED (hpaned_scratch), scrolledwindow_scratch_text, TRUE, TRUE);

	scratch_label = gtk_label_new (_("Scratch Pad / Static Pad"));

	gtk_tooltips_set_tip ( scratch_tips, scratch_label,
						  _( "Those buffers are for notes or drag and drop.\n"
						  	 "The first one is the drag & drop buffer to be\n"
							 "used as a second clipboard or a drag & drop target.\n"
							 "The second one will save the text between sessions so it can"
							 "be used for notes"),
						  	 _("Those buffers are for notes or drag and drop.\n"
						  	 "The first one is the drag & drop buffer to be\n"
							 "used as a second clipboard or a drag & drop target.\n"
							 "The second one will save the text between sessions so it can"
							 "be used for notes")
						 );


	gtk_tooltips_enable( scratch_tips );
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook_footer), hpaned_scratch, scratch_label);
	gtk_widget_queue_draw (GTK_WIDGET (notebook_footer));
// //////////////////////////////////////////////////////////

	label_notebook_footer = gtk_label_new (_("Program output"));
	gtk_widget_show (label_notebook_footer);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook_footer),
				    gtk_notebook_get_nth_page (GTK_NOTEBOOK
							       (notebook_footer),
							       0),
				    label_notebook_footer);
	gtk_label_set_justify (GTK_LABEL (label_notebook_footer),
			       GTK_JUSTIFY_LEFT);

#ifdef WITH_TERMINAL
	visual = gdk_visual_get_system();
	colormap = gdk_colormap_new(visual, TRUE);

	term_window = vte_terminal_new ();
	vte_terminal_reset (VTE_TERMINAL(term_window), TRUE, TRUE);
	vte_terminal_set_emulation (VTE_TERMINAL(term_window), "xterm");
	vte_terminal_set_mouse_autohide (VTE_TERMINAL(term_window), TRUE);
	vte_terminal_set_size (VTE_TERMINAL(term_window),50,7);// with a bigger size the app doesn't fit in 800x600

	gdk_color_parse ("black", &terminal_fore_color);
	gdk_color_parse ("white", &terminal_back_color);
	gdk_colormap_alloc_color(colormap, &terminal_fore_color, FALSE,TRUE);
	gdk_colormap_alloc_color(colormap, &terminal_back_color, FALSE,TRUE);
	vte_terminal_set_colors(VTE_TERMINAL(term_window), &terminal_fore_color, &terminal_back_color, NULL,0);

	vte_terminal_set_cursor_blinks (VTE_TERMINAL(term_window), TRUE);
	vte_terminal_set_scroll_on_output (VTE_TERMINAL(term_window), TRUE);
	vte_terminal_set_scroll_on_keystroke (VTE_TERMINAL(term_window), TRUE);

	shell = getenv("SHELL");
	if( shell == NULL){
		vte_terminal_fork_command (VTE_TERMINAL(term_window), "/bin/sh", NULL, NULL, "~/",
				   0, 0, 0);
	}else{
		if( g_file_test(shell, G_FILE_TEST_EXISTS) && g_file_test(shell,G_FILE_TEST_IS_EXECUTABLE) ){
			vte_terminal_fork_command (VTE_TERMINAL(term_window), shell, NULL, NULL, "~/",
				   0, 0, 0);
		}else{
			vte_terminal_fork_command (VTE_TERMINAL(term_window), "/bin/sh", NULL, NULL, "~/",
				   0, 0, 0);
		}
	}

	gtk_widget_show (term_window);

	sb_terminal = gtk_vscrollbar_new (GTK_ADJUSTMENT (VTE_TERMINAL (term_window)->adjustment));
	GTK_WIDGET_UNSET_FLAGS (sb_terminal, GTK_CAN_FOCUS);

	frame_terminal = gtk_frame_new (NULL);
	gtk_widget_show (frame_terminal);
	gtk_frame_set_shadow_type (GTK_FRAME (frame_terminal), GTK_SHADOW_IN);

	hbox_terminal = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox_terminal), term_window, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox_terminal), sb_terminal, FALSE, TRUE, 0);
	gtk_widget_show_all (hbox_terminal);

	gtk_container_add( GTK_CONTAINER( frame_terminal ), hbox_terminal);

	label_terminal = gtk_label_new (_("Terminal"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook_footer),
				  frame_terminal, label_terminal);

	g_signal_connect ((gpointer) term_window, "child-exited",
			  G_CALLBACK (on_vte_terminal_child_exited), windowobj);
#endif
	g_signal_connect ((gpointer) window, "destroy",
			  G_CALLBACK (on_window_destroy), windowobj);
	g_signal_connect ((gpointer) window, "delete_event",
			  G_CALLBACK (on_window_delete_event), windowobj);
	g_signal_connect ((gpointer) document_scanner_button,"clicked",
				G_CALLBACK (on_document_scanner_button_clicked),  windowobj);
	g_signal_connect ((gpointer) menu_new, "activate",
			  G_CALLBACK (on_menu_new_activate), windowobj);
	g_signal_connect ((gpointer) menu_open, "activate",
			  G_CALLBACK (on_menu_open_activate), windowobj);
	g_signal_connect ((gpointer) menu_close, "activate",
			  G_CALLBACK (on_menu_close_activate), windowobj);
	g_signal_connect ((gpointer) menu_close_all, "activate",
			  G_CALLBACK (on_menu_close_all_activate), windowobj);
	g_signal_connect ((gpointer) menu_revert_to_saved, "activate",
			  G_CALLBACK (on_menu_revert_to_saved_activate), windowobj);
	g_signal_connect ((gpointer) menu_save_all, "activate",
			  G_CALLBACK (on_menu_save_all_activate), windowobj);
	g_signal_connect ((gpointer) menu_guardar, "activate",
			  G_CALLBACK (on_menu_guardar_activate), windowobj);
	g_signal_connect ((gpointer) menu_guardar_como, "activate",
			  G_CALLBACK (on_menu_guardar_como_activate),
			  windowobj);
	g_signal_connect ((gpointer) menu_salir, "activate",
			  G_CALLBACK (on_menu_salir_activate), windowobj);
	g_signal_connect ((gpointer) menu_undo, "activate",
			  G_CALLBACK (on_menu_undo_activate), windowobj);
	g_signal_connect ((gpointer) menu_redo, "activate",
			  G_CALLBACK (on_menu_redo_activate), windowobj);
	g_signal_connect ((gpointer) menu_search, "activate",
			  G_CALLBACK (on_menu_search_activate), windowobj);
	g_signal_connect ((gpointer) menu_replace, "activate",
			  G_CALLBACK (on_menu_replace_activate), windowobj);

	g_signal_connect ((gpointer) menu_cortar, "activate",
			  G_CALLBACK (on_menu_cortar_activate), windowobj);
	g_signal_connect ((gpointer) menu_copiar, "activate",
			  G_CALLBACK (on_menu_copiar_activate), windowobj);
	g_signal_connect ((gpointer) menu_pegar, "activate",
			  G_CALLBACK (on_menu_pegar_activate), windowobj);
	g_signal_connect ((gpointer) menu_borrar, "activate",
			  G_CALLBACK (on_menu_borrar_activate), windowobj);
	g_signal_connect ((gpointer) menu_preferences, "activate",
			  G_CALLBACK (on_menu_preferences_activate), windowobj);
	// toolbar hide/show (toggle)
	g_signal_connect ((gpointer) menu_toolbar, "toggled",
			  G_CALLBACK (on_menu_view_toolbar_toggled), toolbar_main);
	g_signal_connect ((gpointer) menu_secodary_toolbar, "toggled",
			  G_CALLBACK (on_menu_view_toolbar_toggled), toolbar_tools);
	// testing here // this must change
	g_signal_connect ((gpointer) menu_zoom_in, "activate",
			  G_CALLBACK (on_button_zoom_in_clicked), windowobj);
	g_signal_connect ((gpointer) menu_zoom_out, "activate",
			  G_CALLBACK (on_button_zoom_out_clicked), windowobj);
	g_signal_connect ((gpointer) menu_normal_size, "activate",
			  G_CALLBACK (on_button_zoom_off_clicked), windowobj);

	g_signal_connect ((gpointer) menu_about, "activate",
			  G_CALLBACK (on_menu_about_activate), NULL);

#ifdef WITH_HELP_MENUS
#ifdef DARWIN
	g_signal_connect ((gpointer) menuitem_cssed_website_with_safari, "activate",
			G_CALLBACK (on_menu_cssed_website_with_safari_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_website_with_firefox, "activate",
			G_CALLBACK (on_menu_cssed_website_with_firefox_activate), NULL);
#endif
	g_signal_connect ((gpointer) menuitem_cssed_website_with_mozilla, "activate",
					  G_CALLBACK (on_menu_cssed_website_with_mozilla_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_website_with_galeon, "activate",
					  G_CALLBACK (on_menu_cssed_website_with_galeon_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_website_with_dillo, "activate",
					  G_CALLBACK (on_menu_cssed_website_with_dillo_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_website_with_gnome, "activate",
					  G_CALLBACK (on_menu_cssed_website_with_gnome_activate), NULL);

#ifdef DARWIN
	g_signal_connect ((gpointer) menuitem_cssed_doc_online_with_safari, "activate",
					  G_CALLBACK (on_menu_cssed_doc_online_with_safari_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_doc_online_with_firefox, "activate",
					  G_CALLBACK (on_menu_cssed_doc_online_with_firefox_activate), NULL);
#endif
	g_signal_connect ((gpointer) menuitem_cssed_doc_online_with_mozilla, "activate",
					  G_CALLBACK (on_menu_cssed_doc_online_with_mozilla_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_doc_online_with_galeon, "activate",
					  G_CALLBACK (on_menu_cssed_doc_online_with_galeon_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_doc_online_with_dillo, "activate",
					  G_CALLBACK (on_menu_cssed_doc_online_with_dillo_activate), NULL);
	g_signal_connect ((gpointer) menuitem_cssed_doc_online_with_gnome, "activate",
					  G_CALLBACK (on_menu_cssed_doc_online_with_gnome_activate), NULL);
#endif /* #ifdef WITH_HELP_MENUS */

	g_signal_connect ((gpointer) menuitem_show_footer_panel, "activate",
			  G_CALLBACK (11), vpaned_main);
	g_signal_connect ((gpointer) menuitem_hide_footer_panel, "activate",
			  G_CALLBACK (on_hide_footer_panel_activate), vpaned_main);
	g_signal_connect ((gpointer) menuitem_show_side_panel, "activate",
			  G_CALLBACK (on_show_side_panel_activate), hpaned_main);
	g_signal_connect ((gpointer) menuitem_hide_side_panel, "activate",
			  G_CALLBACK (on_hide_side_panel_activate), hpaned_main);
	/*   For future use
	g_signal_connect ((gpointer) menu_cssed_help, "activate",
			  G_CALLBACK (on_menu_cssed_help_activate), NULL);
	*/
	// toolbar buttons
	g_signal_connect ((gpointer) button_abrir, "clicked",
			  G_CALLBACK (on_button_abrir_clicked), windowobj);
	g_signal_connect ((gpointer) button_nuevo, "clicked",
			  G_CALLBACK (on_button_nuevo_clicked), windowobj);
	g_signal_connect ((gpointer) button_cerrar, "clicked",
			  G_CALLBACK (on_button_cerrar_clicked), windowobj);
	g_signal_connect ((gpointer) button_buscar, "clicked",
			  G_CALLBACK (on_button_buscar_clicked), windowobj);
	g_signal_connect ((gpointer) button_reemplazar, "clicked",
			  G_CALLBACK (on_button_reemplazar_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_color, "clicked",
			  G_CALLBACK (on_button_color_clicked), windowobj);
	g_signal_connect ((gpointer) button_guardar, "clicked",
			  G_CALLBACK (on_button_guardar_clicked), windowobj);
	g_signal_connect ((gpointer) button_guardarcomo, "clicked",
			  G_CALLBACK (on_button_guardarcomo_clicked),
			  windowobj);

	g_signal_connect ((gpointer) button_copiar, "clicked",
			  G_CALLBACK (on_button_copiar_clicked), windowobj);
	g_signal_connect ((gpointer) button_pegar, "clicked",
			  G_CALLBACK (on_button_pegar_clicked), windowobj);
	g_signal_connect ((gpointer) button_cortar, "clicked",
			  G_CALLBACK (on_button_cortar_clicked), windowobj);

	g_signal_connect ((gpointer) button_next, "clicked",
			  G_CALLBACK (on_button_next_clicked), windowobj);
	g_signal_connect ((gpointer) button_prev, "clicked",
			  G_CALLBACK (on_button_prev_clicked), windowobj);

	g_signal_connect ((gpointer) button_undo, "clicked",
			  G_CALLBACK (on_button_undo_clicked), windowobj);
	g_signal_connect ((gpointer) button_redo, "clicked",
			  G_CALLBACK (on_button_redo_clicked), windowobj);
	/* zooming callbacks */
	/*
	g_signal_connect ((gpointer) button_zoom_in, "clicked",
			  G_CALLBACK (on_button_zoom_in_clicked), windowobj);
	g_signal_connect ((gpointer) button_zoom_out, "clicked",
			  G_CALLBACK (on_button_zoom_out_clicked), windowobj);
	g_signal_connect ((gpointer) button_zoom_off, "clicked",
			  G_CALLBACK (on_button_zoom_off_clicked), windowobj);
	*/
	g_signal_connect ((gpointer) button_hide_side, "clicked",
			  G_CALLBACK (on_button_hide_side_clicked), hpaned_main);
	g_signal_connect ((gpointer) button_show_side, "clicked",
			  G_CALLBACK (on_button_show_side_clicked), hpaned_main);
	g_signal_connect ((gpointer) button_hide_footer, "clicked",
			  G_CALLBACK (on_button_hide_footer_clicked), vpaned_main);
	g_signal_connect ((gpointer) button_show_footer, "clicked",
			  G_CALLBACK (on_button_show_footer_clicked), vpaned_main);
	/* preferences dialog callbacks */
	g_signal_connect ((gpointer)button_preferences, "clicked",
			  G_CALLBACK (on_button_preferences_clicked), windowobj);
	/* notebook */
	g_signal_connect ((gpointer) notebook_docs, "switch-page",
			  G_CALLBACK (on_notebook_docs_switch_page),
			  windowobj);
	// main view menu, this will change child menus
	//	on a document basis reflecting the opened document state
	g_signal_connect ((gpointer) menuitem_ver, "activate",
			  G_CALLBACK (on_menu_view_activate), windowobj);
	// dynamic menus set the callback func used when document specific menu items are toggled
	g_signal_connect ((gpointer) menu_ver_line_numbers, "toggled",
			  G_CALLBACK (on_menu_line_numbers_toggled),
			  windowobj);
	g_signal_connect ((gpointer) menu_ver_line_endings, "toggled",
			  G_CALLBACK (on_menu_line_endings_toggled),
			  windowobj);
	g_signal_connect ((gpointer) menu_ver_lines_wrapped, "toggled",
			  G_CALLBACK (on_menu_line_wrapping_toggled),
			  windowobj);
	g_signal_connect ((gpointer) menu_ver_white_spaces, "toggled",
			  G_CALLBACK (on_menu_ver_white_spaces_toggled),
			  windowobj);
	g_signal_connect ((gpointer) menu_item_autocompletion, "toggled",
			  G_CALLBACK (on_menu_item_autocompletion_toggled),
			  windowobj);
	g_signal_connect ((gpointer) menu_item_folding, "toggled",
			  G_CALLBACK (on_menu_item_folding_toggled),
			  windowobj);
	g_signal_connect ((gpointer) menu_item_font, "activate",
			  G_CALLBACK (on_menu_item_font_activate),
			  windowobj);
/*
	g_signal_connect ((gpointer) menu_item_autocompletion, "activate",
			  G_CALLBACK (on_menu_item_autocompletion_activate),
			  windowobj);
*/
	g_signal_connect ((gpointer) menuitem_eol_mode_cr, "activate",
			  G_CALLBACK (on_menu_eol_mode_cr_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_eol_mode_lf, "activate",
			  G_CALLBACK (on_menu_eol_mode_lf_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_eol_mode_crlf, "activate",
			  G_CALLBACK (on_menu_eol_mode_crlf_activate),
			  windowobj);
	// folding
	g_signal_connect ((gpointer) menuitem_fonding_foldall, "activate",
			  G_CALLBACK (on_menuitem_fonding_foldall_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_folding_unfoldall, "activate",
			  G_CALLBACK (on_menuitem_folding_unfoldall_activate),
			  windowobj);
	// highlighting
	g_signal_connect ((gpointer) menuitem_highlighting_text, "activate",
			  G_CALLBACK (on_menuitem_highlighting_text_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_css, "activate",
			  G_CALLBACK (on_menuitem_highlighting_css_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_html, "activate",
			  G_CALLBACK (on_menuitem_highlighting_html_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_sh, "activate",
			  G_CALLBACK (on_menuitem_highlighting_sh_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_c, "activate",
			  G_CALLBACK (on_menuitem_highlighting_c_activate),
			  windowobj);	;
	g_signal_connect ((gpointer) menuitem_highlighting_apache_conf, "activate",
			  G_CALLBACK (on_menuitem_highlighting_apache_conf_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_perl, "activate",
			  G_CALLBACK (on_menuitem_highlighting_perl_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_python, "activate",
			  G_CALLBACK (on_menuitem_highlighting_python_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_xml, "activate",
			  G_CALLBACK (on_menuitem_highlighting_xml_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_diff, "activate",
			  G_CALLBACK (on_menuitem_highlighting_diff_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_highlighting_make, "activate",
			  G_CALLBACK (on_menuitem_highlighting_make_activate),
			  windowobj);
	// encoding
	g_signal_connect ((gpointer) menuitem_encoding_default, "activate",
			  G_CALLBACK (on_menuitem_encoding_default_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_encoding_utf8, "activate",
			  G_CALLBACK (on_menuitem_encoding_utf8_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_encoding_dbcs, "activate",
			  G_CALLBACK (on_menuitem_encoding_dbcs_activate),
			  windowobj);
	// charset
	g_signal_connect ((gpointer) menuitem_charset_ansi, "activate",
			  G_CALLBACK (on_menuitem_charset_ansi_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_charset_easteurope, "activate",
			  G_CALLBACK (on_menuitem_charset_easteurope_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_encoding_dbcs, "activate",
			  G_CALLBACK (on_menuitem_charset_gb2312_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_encoding_utf8, "activate",
			  G_CALLBACK (on_menuitem_charset_hangul_activate),
			  windowobj);
	g_signal_connect ((gpointer) menuitem_encoding_dbcs, "activate",
			  G_CALLBACK (on_menuitem_charset_shiftjis_activate),
			  windowobj);
	// selector scan menu
	g_signal_connect ((gpointer) menu_utils_scan_selector, "activate",
			  G_CALLBACK (on_menu_scan_selector_activate),
			  windowobj);
	// doc info
	g_signal_connect ((gpointer) menu_utils_doc_info, "activate",
			  G_CALLBACK (on_menu_doc_info_activate), windowobj);
	// autocompletion,  not in lookup_widget list
	g_signal_connect ((gpointer) menu_utils_autocomp, "activate",
			  G_CALLBACK (on_menu_autocompletion_activate), windowobj);
	// folding,  not in lookup_widget list
	g_signal_connect ((gpointer) menu_utils_autocomp, "activate",
			  G_CALLBACK (on_menu_autocompletion_activate), windowobj);
	// validation and dump,  not in lookup_widget list
	g_signal_connect ((gpointer) menu_utils_validate, "activate",
			  G_CALLBACK (on_menu_utils_validate_activate), windowobj);
	// validation only,  not in lookup_widget list
	g_signal_connect ((gpointer) menu_utils_validate_only, "activate",
			  G_CALLBACK (on_menu_utils_validate_only_activate), windowobj);
	// clean output,  not in lookup_widget list
	g_signal_connect ((gpointer) menu_utils_cleanoutput, "activate",
			  G_CALLBACK (on_menu_utils_cleanoutput_activate), windowobj);

	// css properties treeview callbacks
	g_signal_connect ((gpointer) treeview_css_properties, "row-activated",
			  G_CALLBACK
			  (on_treeview_css_properties_row_activated),
			  windowobj);
	//output window callbacks
	g_signal_connect ((gpointer) output_list, "row-activated",
			  G_CALLBACK
			  (on_output_list_row_activated),
			  windowobj);
	// doc scanner callbacks
	g_signal_connect ((gpointer) document_scanner_treeview, "row-activated",
			  G_CALLBACK
			  (on_doc_scanner_row_activated),
			  windowobj);
	// catch when edited the current CSS selector
	g_signal_connect(G_OBJECT(current_css_render_values), "edited",
						G_CALLBACK(on_current_css_render_values_edited),
						windowobj);
	// selector scanner treeview callbacks
	g_signal_connect ((gpointer) treeview_css_current, "row-activated",
			  G_CALLBACK
			  (on_treeview_css_current_row_activated),
			  windowobj);
	// css selector wizard
	g_signal_connect ((gpointer) menuitem_selector_wizard, "activate",
			  G_CALLBACK (on_menuitem_selector_wizard_activate),
			  windowobj);
	// css color wizard
	g_signal_connect ((gpointer) menuitem_color_wizard, "activate",
			  G_CALLBACK (on_menuitem_color_wizard_activate),
			  windowobj);
	// box properties wizard
	g_signal_connect ((gpointer) menuitem_box_wizard, "activate",
			  G_CALLBACK (on_menuitem_box_wizard_activate),
			  windowobj);
	// secondary toolbar callbacks
	g_signal_connect ((gpointer) button_border_all, "clicked",
			  G_CALLBACK (on_button_border_all_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_margin_all, "clicked",
			  G_CALLBACK (on_button_margin_all_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_padding_all, "clicked",
			  G_CALLBACK (on_button_padding_all_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_box_properties, "clicked",
			  G_CALLBACK (on_button_box_properties_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_doc_info, "clicked",
			  G_CALLBACK (on_button_doc_info_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_sel_wizard, "clicked",
			  G_CALLBACK (on_button_sel_wizard_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_col_wizard, "clicked",
			  G_CALLBACK (on_button_col_wizard_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_font, "clicked",
			  G_CALLBACK (on_button_font_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_scan_selector, "clicked",
			  G_CALLBACK (on_button_scan_selector_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_clean_output, "clicked",
			  G_CALLBACK (on_button_clean_output_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_validate, "clicked",
			  G_CALLBACK (on_button_validate_clicked),
			  windowobj);
	g_signal_connect ((gpointer) button_validate_dump, "clicked",
			  G_CALLBACK (on_button_validate_dump_clicked),
			  windowobj);
	// editor pop menu callbacks
	g_signal_connect ((gpointer) pop_menu_undo, "activate",
			  G_CALLBACK (on_pop_menu_undo_activate),
			  windowobj);
	g_signal_connect ((gpointer) pop_menu_redo, "activate",
			  G_CALLBACK (on_pop_menu_redo_activate),
			  windowobj);
	g_signal_connect ((gpointer) pop_menu_cut, "activate",
			  G_CALLBACK (on_pop_menu_cut_activate),
			  windowobj);
	g_signal_connect ((gpointer) pop_menu_copy, "activate",
			  G_CALLBACK (on_pop_menu_copy_activate),
			  windowobj);
	g_signal_connect ((gpointer) pop_menu_paste, "activate",
			  G_CALLBACK (on_pop_menu_paste_activate),
			  windowobj);
	g_signal_connect ((gpointer) pop_menu_delete, "activate",
			  G_CALLBACK (on_pop_menu_delete_activate),
			  windowobj);
	g_signal_connect ((gpointer) pop_menu_selectall, "activate",
			  G_CALLBACK (on_pop_menu_selectall_activate),
			  windowobj);
	// document scanner columns callbacks
	g_signal_connect ((gpointer) document_scanner_column_numbers, "clicked",
			  G_CALLBACK (on_doc_scanner_col_numbers_clicked),
			  document_scanner_store);
	g_signal_connect ((gpointer) document_scanner_column, "clicked",
			  G_CALLBACK (on_doc_scanner_col_styles_clicked),
			  document_scanner_store);

#ifdef WITH_PLUGINS
	if( g_module_supported() ){
		g_signal_connect ((gpointer) menuitem_plugins_load, "activate",
			  G_CALLBACK (on_plugins_load_activate), windowobj);
	}
#endif
	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (window, window, "window");
#ifdef WITH_PLUGINS
	GLADE_HOOKUP_OBJECT (window, menuitem_plugins_menu, "plugins_menu");
#endif
	GLADE_HOOKUP_OBJECT (window, menubar_main, "menubar_main");
	GLADE_HOOKUP_OBJECT (window, menuitem_file, "menuitem_file");
	GLADE_HOOKUP_OBJECT (window, menuitem_file_menu,   "menuitem_file_menu");
	GLADE_HOOKUP_OBJECT (window, menu_new, "menu_new");
	GLADE_HOOKUP_OBJECT (window, menu_open, "menu_open");
	GLADE_HOOKUP_OBJECT (window, menu_guardar, "menu_guardar");
	GLADE_HOOKUP_OBJECT (window, menu_guardar_como, "menu_guardar_como");
	GLADE_HOOKUP_OBJECT (window, menu_salir, "menu_salir");
	GLADE_HOOKUP_OBJECT (window, menuitem_editar, "menuitem_editar");
	GLADE_HOOKUP_OBJECT (window, menuitem_editar_menu,   "menuitem_editar_menu");
	GLADE_HOOKUP_OBJECT (window, menu_cortar, "menu_cortar");
	GLADE_HOOKUP_OBJECT (window, menu_copiar, "menu_copiar");
	GLADE_HOOKUP_OBJECT (window, menu_pegar, "menu_pegar");
	GLADE_HOOKUP_OBJECT (window, menu_borrar, "menu_borrar");
	GLADE_HOOKUP_OBJECT (window, menuitem_ver, "menuitem_ver");
	GLADE_HOOKUP_OBJECT (window, menuitem_ayuda, "menuitem_ayuda");
	GLADE_HOOKUP_OBJECT (window, menuitem_show_footer_panel, "menuitem_show_footer_panel");
	GLADE_HOOKUP_OBJECT (window, menuitem_hide_footer_panel, "menuitem_hide_footer_panel");
	GLADE_HOOKUP_OBJECT (window, menuitem_ayuda_menu, "menuitem_ayuda_menu");
	GLADE_HOOKUP_OBJECT (window, menu_about, "menu_about");
#ifdef WITH_HELP_MENUS
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website, "menuitem_cssed_website");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website_menu, "menuitem_cssed_website_menu");
#ifdef DARWIN
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website_with_safari, "menuitem_cssed_website_with_safari");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website_with_firefox, "menuitem_cssed_website_with_firefox");
#endif
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website_with_mozilla, "menuitem_cssed_website_with_mozilla");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website_with_galeon, "menuitem_cssed_website_with_galeon");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website_with_dillo, "menuitem_cssed_website_with_dillo");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_website_with_gnome, "menuitem_cssed_website_with_gnome");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online, "menuitem_cssed_doc_online");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online_menu, "menuitem_cssed_doc_online_menu");
#ifdef DARWIN
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online_with_safari, "menuitem_cssed_doc_online_with_safari");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online_with_firefox, "menuitem_cssed_doc_online_with_firefox");
#endif
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online_with_mozilla, "menuitem_cssed_doc_online_with_mozilla");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online_with_galeon, "menuitem_cssed_doc_online_with_galeon");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online_with_dillo, "menuitem_cssed_doc_online_with_dillo");
	GLADE_HOOKUP_OBJECT (window, menuitem_cssed_doc_online_with_gnome, "menuitem_cssed_doc_online_with_gnome");
#endif /* #ifdef WITH_HELP_MENUS */
	GLADE_HOOKUP_OBJECT (window, toolbar_main, "toolbar_main");
	GLADE_HOOKUP_OBJECT (window, toolbar_tools, "toolbar_tools");
	GLADE_HOOKUP_OBJECT (window, button_abrir, "button_abrir");
	GLADE_HOOKUP_OBJECT (window, button_nuevo, "button_nuevo");
	GLADE_HOOKUP_OBJECT (window, button_cerrar, "button_cerrar");
	GLADE_HOOKUP_OBJECT (window, button_buscar, "button_buscar");
	GLADE_HOOKUP_OBJECT (window, button_reemplazar, "button_reemplazar");
	GLADE_HOOKUP_OBJECT (window, button_copiar, "button_copiar");
	GLADE_HOOKUP_OBJECT (window, button_pegar, "button_pegar");
	GLADE_HOOKUP_OBJECT (window, button_color, "button_color");
	GLADE_HOOKUP_OBJECT (window, button_guardar, "button_guardar");
	GLADE_HOOKUP_OBJECT (window, button_guardarcomo, "button_guardarcomo");
	GLADE_HOOKUP_OBJECT (window, notebook_docs, "notebook_docs");
	//GLADE_HOOKUP_OBJECT (window, editor, "editor");
	//GLADE_HOOKUP_OBJECT (window, label_notebook_blank, "label_notebook_blank");
	GLADE_HOOKUP_OBJECT (window, treeview_css_current, "treeview_css_current");
	GLADE_HOOKUP_OBJECT (window, treeview_css_properties, "treeview_css_properties");
	GLADE_HOOKUP_OBJECT (window, notebook_footer, "notebook_footer");
	GLADE_HOOKUP_OBJECT (window, output_list, "output_list");
	GLADE_HOOKUP_OBJECT (window, label_notebook_footer, "label_notebook_footer");
	GLADE_HOOKUP_OBJECT (window, scrolledwindow_scratch_text, "scrolledwindow_scratch_text");
	GLADE_HOOKUP_OBJECT (window, notebook_footer, "notebook_footer");
	GLADE_HOOKUP_OBJECT (window, scratch_text, "scratch_text");
	GLADE_HOOKUP_OBJECT (window, scratch_label, "scratch_label");
//
	GLADE_HOOKUP_OBJECT (window, vpaned_main, "vpaned_main");
	GLADE_HOOKUP_OBJECT (window, hpaned_main, "hpaned_main");
	GLADE_HOOKUP_OBJECT (window, vpaned_css, "vpaned_css");

	GLADE_HOOKUP_OBJECT (window, button_hide_side,"button_hide_side");
	GLADE_HOOKUP_OBJECT (window, button_show_side,"button_show_side");
	GLADE_HOOKUP_OBJECT (window, button_hide_footer,"button_hide_footer");
	GLADE_HOOKUP_OBJECT (window, button_show_footer,"button_show_footer");

	//gtk_widget_grab_focus (editor);
	//gtk_widget_grab_default (editor);
	gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

	// set the panes positions with config values
	gtk_paned_set_position(GTK_PANED (hpaned_main), cfg->sidebar_width);
	gtk_paned_set_position(GTK_PANED (vpaned_main), cfg->notebook_height);
	gtk_paned_set_position(GTK_PANED (vpaned_css), cfg->treeview_height);

	return window;
}

/* 	This file selection related functions will be deleted
	FIXME - This is just a unused template the used ones are below
	and are flaged to be skipped

GtkWidget *
create_fileselection (void)
{
	GtkWidget *fileselection;
	GtkWidget *fileselection_ok_button;
	GtkWidget *fileselection_cancel_button;

	fileselection = gtk_file_selection_new (_("Seleccione Archivo"));
	gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
	gtk_window_set_position (GTK_WINDOW (fileselection),
				 GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW (fileselection), TRUE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (fileselection), TRUE);

	fileselection_ok_button =
		GTK_FILE_SELECTION (fileselection)->ok_button;
	gtk_widget_show (fileselection_ok_button);
	GTK_WIDGET_SET_FLAGS (fileselection_ok_button, GTK_CAN_DEFAULT);

	fileselection_cancel_button =
		GTK_FILE_SELECTION (fileselection)->cancel_button;
	gtk_widget_show (fileselection_cancel_button);
	GTK_WIDGET_SET_FLAGS (fileselection_cancel_button, GTK_CAN_DEFAULT);

	g_signal_connect_swapped ((gpointer) fileselection, "close",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (fileselection));

	g_signal_connect_swapped ((gpointer) fileselection, "destroy",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (fileselection));
	g_signal_connect_swapped ((gpointer) fileselection_cancel_button,
				  "clicked", G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (fileselection));

	// Store pointers to all widgets, for use by lookup_widget().
	GLADE_HOOKUP_OBJECT_NO_REF (fileselection, fileselection,
				    "fileselection");
	GLADE_HOOKUP_OBJECT_NO_REF (fileselection, fileselection_ok_button,
				    "fileselection_ok_button");
	GLADE_HOOKUP_OBJECT_NO_REF (fileselection,
				    fileselection_cancel_button,
				    "fileselection_cancel_button");

	return fileselection;
}
*/
GtkWidget * // flaged to be taken out FIXME
create_save_fileselection (CssedWindow * window)
{
	GtkWidget *save_fileselection;
	GtkWidget *save_fileselection_ok_button;
	GtkWidget *save_fileselection_cancel_button;
	CssedFileSelectorData *data;

	save_fileselection = gtk_file_selection_new (_("Select file"));
	gtk_container_set_border_width (GTK_CONTAINER (save_fileselection), 10);
	gtk_window_set_modal (GTK_WINDOW (save_fileselection), TRUE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (save_fileselection),  TRUE);
	gtk_window_set_transient_for ( GTK_WINDOW ( save_fileselection ),
				      GTK_WINDOW ( cssed_window_get_window_widget( window ) ) );

	save_fileselection_ok_button =
		GTK_FILE_SELECTION (save_fileselection)->ok_button;
	gtk_widget_show (save_fileselection_ok_button);
	GTK_WIDGET_SET_FLAGS (save_fileselection_ok_button, GTK_CAN_DEFAULT);

	save_fileselection_cancel_button =
		GTK_FILE_SELECTION (save_fileselection)->cancel_button;
	gtk_widget_show (save_fileselection_cancel_button);
	GTK_WIDGET_SET_FLAGS (save_fileselection_cancel_button,
			      GTK_CAN_DEFAULT);

	data = g_malloc (sizeof (CssedFileSelectorData));
	data->notebook = cssed_window_get_document_notebook( window );
	data->fileselector = save_fileselection;
	data->main_window = window;

	g_signal_connect ((gpointer) save_fileselection, "close",
				  G_CALLBACK (file_selector_close),
				  data);
	g_signal_connect ((gpointer) save_fileselection_cancel_button,
				  "clicked", G_CALLBACK (file_selector_cancel_button_clicked),
				 data);
	g_signal_connect ((gpointer) save_fileselection_ok_button, "clicked",
		G_CALLBACK (on_save_fileselection_ok_button_clicked), (gpointer) data);	// must be freed by callers
	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (save_fileselection, save_fileselection,
				    "save_fileselection");
	GLADE_HOOKUP_OBJECT_NO_REF (save_fileselection,
				    save_fileselection_ok_button,
				    "save_fileselection_ok_button");
	GLADE_HOOKUP_OBJECT_NO_REF (save_fileselection,
				    save_fileselection_cancel_button,
				    "save_fileselection_cancel_button");

	return save_fileselection;
}

GtkWidget * // flaged to be taken out FIXME
create_save_as_fileselection (CssedWindow * window)
{
	GtkWidget *save_as_fileselection;
	GtkWidget *save_as_fileselection_ok_button;
	GtkWidget *save_as_fileselection_cancel_button;
	gchar* last_save_dir;
	CssedFileSelectorData *data;

	// FIXME make me transient of parent window
	save_as_fileselection =	gtk_file_selection_new (_("Select file"));
	gtk_container_set_border_width (GTK_CONTAINER (save_as_fileselection),	10);
	gtk_window_set_modal (GTK_WINDOW (save_as_fileselection), TRUE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW(save_as_fileselection), TRUE);
	gtk_window_set_transient_for ( GTK_WINDOW(save_as_fileselection),
				      GTK_WINDOW ( cssed_window_get_window_widget(window) ));

	save_as_fileselection_ok_button =
		GTK_FILE_SELECTION (save_as_fileselection)->ok_button;
	gtk_widget_show (save_as_fileselection_ok_button);
	GTK_WIDGET_SET_FLAGS (save_as_fileselection_ok_button,
			      GTK_CAN_DEFAULT);

	save_as_fileselection_cancel_button =
		GTK_FILE_SELECTION (save_as_fileselection)->cancel_button;
	gtk_widget_show (save_as_fileselection_cancel_button);
	GTK_WIDGET_SET_FLAGS (save_as_fileselection_cancel_button,
			      GTK_CAN_DEFAULT);

	data = g_malloc (sizeof (CssedFileSelectorData));
	data->notebook = cssed_window_get_document_notebook( window );
	data->fileselector = save_as_fileselection;
	data->main_window = window;

	last_save_dir = cssed_window_get_last_save_dir ( window );

	if( last_save_dir != NULL ){
		gtk_file_selection_set_filename( GTK_FILE_SELECTION (save_as_fileselection),
										last_save_dir );
	}

	g_signal_connect ((gpointer) save_as_fileselection, "close",
				  G_CALLBACK (file_selector_close),
				  data);
	g_signal_connect ((gpointer)
				  save_as_fileselection_cancel_button,
				  "clicked", G_CALLBACK (file_selector_cancel_button_clicked),
				  data);
	g_signal_connect ((gpointer) save_as_fileselection_ok_button, "clicked",
		G_CALLBACK (on_save_as_fileselection_ok_button_clicked),
		(gpointer) data);	// must be freed by callers

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (save_as_fileselection,
				    save_as_fileselection,
				    "save_as_fileselection");
	GLADE_HOOKUP_OBJECT_NO_REF (save_as_fileselection,
				    save_as_fileselection_ok_button,
				    "save_as_fileselection_ok_button");
	GLADE_HOOKUP_OBJECT_NO_REF (save_as_fileselection,
				    save_as_fileselection_cancel_button,
				    "save_as_fileselection_cancel_button");

	return save_as_fileselection;
}

GtkWidget * // flaged to be taken out FIXME
create_open_fileselection (CssedWindow * window)
{
	GtkWidget *open_fileselection;
	GtkWidget *open_fileselection_ok_button;
	GtkWidget *open_fileselection_cancel_button;
	gchar* last_open_dir;
	CssedFileSelectorData *data;

	open_fileselection = gtk_file_selection_new (_("Select file"));
	gtk_container_set_border_width (GTK_CONTAINER (open_fileselection), 10);
	gtk_window_set_modal (GTK_WINDOW (open_fileselection), TRUE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (open_fileselection), TRUE);
	gtk_window_set_transient_for ( GTK_WINDOW(open_fileselection),
				      GTK_WINDOW ( cssed_window_get_window_widget(window) ));

	open_fileselection_ok_button =
		GTK_FILE_SELECTION (open_fileselection)->ok_button;
	gtk_widget_show (open_fileselection_ok_button);
	GTK_WIDGET_SET_FLAGS (open_fileselection_ok_button, GTK_CAN_DEFAULT);

	open_fileselection_cancel_button =
		GTK_FILE_SELECTION (open_fileselection)->cancel_button;
	gtk_widget_show (open_fileselection_cancel_button);
	GTK_WIDGET_SET_FLAGS (open_fileselection_cancel_button,
			      GTK_CAN_DEFAULT);

	data = g_malloc (sizeof (CssedFileSelectorData));
	data->notebook = cssed_window_get_document_notebook( window );
	data->fileselector = open_fileselection;
	data->main_window = window;

	last_open_dir = cssed_window_get_last_open_dir( window );

	if( last_open_dir != NULL ){
		gtk_file_selection_set_filename( GTK_FILE_SELECTION (open_fileselection),
										last_open_dir );
	}

	g_signal_connect ((gpointer) open_fileselection, "close",
			  G_CALLBACK (file_selector_close),
			  data);
	g_signal_connect((gpointer) open_fileselection_cancel_button,
				  "clicked", G_CALLBACK (file_selector_cancel_button_clicked),
				  data);
	g_signal_connect ((gpointer) open_fileselection_ok_button, "clicked",
		G_CALLBACK (create_and_attach_new_named_doc_from_fileselector_cb),
		(gpointer) data);	// must be freed by callers

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (open_fileselection, open_fileselection,
				    "open_fileselection");
	GLADE_HOOKUP_OBJECT_NO_REF (open_fileselection,
				    open_fileselection_ok_button,
				    "open_fileselection_ok_button");
	GLADE_HOOKUP_OBJECT_NO_REF (open_fileselection,
				    open_fileselection_cancel_button,
				    "open_fileselection_cancel_button");

	return open_fileselection;
}


GtkWidget *
create_error_dialog (void)
{
	GtkWidget *error_dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *image;
	GtkWidget *label_msg;
	GtkWidget *label_detail;
	GtkWidget *dialog_action_area;
	GtkWidget *errordialog_okbutton;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new ();

	error_dialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (error_dialog), "");
	gtk_window_set_position (GTK_WINDOW (error_dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (error_dialog), TRUE);

	dialog_vbox = GTK_DIALOG (error_dialog)->vbox;
	gtk_widget_show (dialog_vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), hbox, TRUE, TRUE, 0);

	image = gtk_image_new_from_stock ("gtk-dialog-warning", GTK_ICON_SIZE_DIALOG);
	gtk_widget_show (image);
	gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 35);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 10);

	label_msg = gtk_label_new (NULL);
	gtk_widget_show (label_msg);
	gtk_box_pack_start (GTK_BOX (vbox), label_msg, TRUE, TRUE, 10);

	label_detail = gtk_label_new (NULL);
	gtk_widget_show (label_detail);
	gtk_box_pack_start (GTK_BOX (vbox), label_detail, TRUE, TRUE, 10);

	dialog_action_area = GTK_DIALOG (error_dialog)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area),GTK_BUTTONBOX_END);

	errordialog_okbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (errordialog_okbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (error_dialog),
				      errordialog_okbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (errordialog_okbutton, GTK_CAN_DEFAULT);

	gtk_widget_add_accelerator (errordialog_okbutton, "clicked", accel_group,
				    GDK_O, GDK_CONTROL_MASK,
				    GTK_ACCEL_VISIBLE);
	gtk_widget_add_accelerator (errordialog_okbutton, "clicked", accel_group,
				    GDK_C, GDK_CONTROL_MASK,
				    GTK_ACCEL_VISIBLE);

	g_signal_connect_swapped ((gpointer) error_dialog, "close",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (error_dialog));
	g_signal_connect_swapped ((gpointer) errordialog_okbutton, "clicked",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (error_dialog));

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (error_dialog, error_dialog,
				    "error_dialog");
	GLADE_HOOKUP_OBJECT (error_dialog, label_detail, "label_detail");
	GLADE_HOOKUP_OBJECT (error_dialog, image, "image");
	GLADE_HOOKUP_OBJECT (error_dialog, label_msg, "label_msg");
	GLADE_HOOKUP_OBJECT_NO_REF (error_dialog, dialog_action_area,
				    			"dialog_action_area");
	GLADE_HOOKUP_OBJECT (error_dialog, errordialog_okbutton,
			     				"errordialog_okbutton");

	gtk_window_add_accel_group (GTK_WINDOW (error_dialog),
				    accel_group);

	return error_dialog;
}

GtkWidget *
create_about (void)
{
  GtkWidget *dialog_about;
  GdkPixbuf *dialog_about_icon_pixbuf;
  GtkWidget *dialog_vbox;
  GtkWidget *notebook;
  GtkWidget *hbox_author;
  GtkWidget *image_cssed;
  GtkWidget *vbox_author;
  GtkWidget *label_author;
  GtkWidget *label_author_name;
  GtkWidget *label_version;
  GtkWidget *label_app_url;
  GtkWidget *vbox_dev;
  GtkWidget *label_dev_first;
  GtkWidget *label_dev_second;
  GtkWidget *label_dev_third;
  GtkWidget *label_dev_fourth;
  GtkWidget *label_developers;
  GtkWidget *vbox_translators;
  GtkWidget *label_not_yet;
  GtkWidget *label_translators;
  GtkWidget *dialog_action_area;
  GtkWidget *okbutton;
  gchar* version;

  GtkAccelGroup* accel_group;

#ifdef WIN32
  version = g_strdup("<span size='larger'>cssed - 0.3.0</span>");
#else
  version = g_strdup_printf("<span size='larger'>%s - v. %s</span>", PACKAGE, VERSION);
#endif

	accel_group = gtk_accel_group_new ();

  dialog_about = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog_about), _("About cssed"));
  gtk_window_set_position (GTK_WINDOW (dialog_about), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (dialog_about), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (dialog_about), TRUE);
  dialog_about_icon_pixbuf = create_pixbuf ("cssed-icon.png");
  if (dialog_about_icon_pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (dialog_about), dialog_about_icon_pixbuf);
      gdk_pixbuf_unref (dialog_about_icon_pixbuf);
    }

  dialog_vbox = GTK_DIALOG (dialog_about)->vbox;
  gtk_widget_show (dialog_vbox);

  notebook = gtk_notebook_new ();
  gtk_widget_show (notebook);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), notebook, TRUE, TRUE, 0);

  hbox_author = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_author);
  gtk_container_add (GTK_CONTAINER (notebook), hbox_author);

  image_cssed = create_pixmap (dialog_about, "cssed-about.png");
  gtk_widget_show (image_cssed);
  gtk_box_pack_start (GTK_BOX (hbox_author), image_cssed, TRUE, TRUE, 0);

  vbox_author = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox_author);
  gtk_box_pack_start (GTK_BOX (hbox_author), vbox_author, TRUE, TRUE, 0);

  label_author = gtk_label_new (_("<span weight='bold' size='large'><u>Author</u></span>"));
  gtk_widget_show (label_author);
  gtk_box_pack_start (GTK_BOX (vbox_author), label_author, FALSE, FALSE, 5);
  gtk_label_set_use_markup (GTK_LABEL (label_author), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_author), GTK_JUSTIFY_LEFT);

  label_author_name = gtk_label_new ("<span size='medium' weight='bold'>Iago Rubio Sanfiz (c) 2003 - 2004</span>");
  gtk_widget_show (label_author_name);
  gtk_box_pack_start (GTK_BOX (vbox_author), label_author_name, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label_author_name), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_author_name), GTK_JUSTIFY_LEFT);

  label_version = gtk_label_new (version);
  g_free(version);//not needed anymore
  gtk_widget_show (label_version);
  gtk_box_pack_start (GTK_BOX (vbox_author), label_version, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label_version), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_version), GTK_JUSTIFY_LEFT);

  label_app_url = gtk_label_new ("<span weight='bold'> http://cssed.sourceforge.net</span>");
  gtk_widget_show (label_app_url);
  gtk_box_pack_start (GTK_BOX (vbox_author), label_app_url, FALSE, FALSE, 15);
  gtk_label_set_use_markup (GTK_LABEL (label_app_url), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_app_url), GTK_JUSTIFY_LEFT);

  label_author = gtk_label_new (_("Author"));
  gtk_widget_show (label_author);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label_author);
  gtk_label_set_justify (GTK_LABEL (label_author), GTK_JUSTIFY_LEFT);
//
  vbox_dev = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox_dev);
  gtk_container_add (GTK_CONTAINER (notebook), vbox_dev);

  label_dev_first = gtk_label_new ("<span size='medium'>Iago Rubio</span> - <span size='small'>iago.rubio (at) hispalinux.es - http://www.iagorubio.com</span>");
  gtk_widget_show (label_dev_first);
  gtk_box_pack_start (GTK_BOX (vbox_dev), label_dev_first, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label_dev_first), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_dev_first), GTK_JUSTIFY_LEFT);

  label_dev_second = gtk_label_new ("<span size='medium'>Michèle Garoche</span> - <span size='small'>michga (at) users.sourceforge.net</span>");
  gtk_widget_show (label_dev_second);
  gtk_box_pack_start (GTK_BOX (vbox_dev), label_dev_second, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label_dev_second), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_dev_second), GTK_JUSTIFY_LEFT);

  label_dev_third = gtk_label_new ("<span size='medium'>Alastair Porter</span> - <span size='small'>trommaster (at) users.sourceforge.net</span>");
  gtk_widget_show (label_dev_third);
  gtk_box_pack_start (GTK_BOX (vbox_dev), label_dev_third, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label_dev_third), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_dev_third), GTK_JUSTIFY_LEFT);

  label_dev_fourth = gtk_label_new ("");
  gtk_widget_show (label_dev_fourth);
  gtk_box_pack_start (GTK_BOX (vbox_dev), label_dev_fourth, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label_dev_fourth), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_dev_fourth), GTK_JUSTIFY_LEFT);

  label_developers = gtk_label_new (_("Developers"));
  gtk_widget_show (label_developers);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), label_developers);
  gtk_label_set_justify (GTK_LABEL (label_developers), GTK_JUSTIFY_LEFT);
//
  vbox_translators = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox_translators);
  gtk_container_add (GTK_CONTAINER (notebook), vbox_translators);

  // translator: put here your name, in your language.po file
  label_not_yet = gtk_label_new (_("Not yet"));
  gtk_widget_show (label_not_yet);
  gtk_box_pack_start (GTK_BOX (vbox_translators), label_not_yet, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label_not_yet), TRUE);
  gtk_label_set_justify (GTK_LABEL (label_not_yet), GTK_JUSTIFY_LEFT);

  label_translators = gtk_label_new (_("Translators"));
  gtk_widget_show (label_translators);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 2), label_translators);
  gtk_label_set_justify (GTK_LABEL (label_translators), GTK_JUSTIFY_LEFT);


  {  // JUST FOR THIS RELEASE
	GtkWidget* vbox_dedicated;
	GtkWidget* label_dedicated;
	GtkWidget* label_dedicated_first;
	GtkWidget* label_dedicated_scnd;
	GtkWidget* label_dedicated_thrd;

	vbox_dedicated = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox_dedicated);
	gtk_container_add (GTK_CONTAINER (notebook), vbox_dedicated);

	label_dedicated_first = gtk_label_new (_("<span size='medium'><b>Pascaline and Pierre-Loïc</b>\nWishing them a long and happy life together.</span> "));
	gtk_widget_show (label_dedicated_first);
	gtk_box_pack_start (GTK_BOX (vbox_dedicated), label_dedicated_first, TRUE, TRUE, 0);
	gtk_label_set_use_markup (GTK_LABEL (label_dedicated_first), TRUE);
	gtk_label_set_justify (GTK_LABEL (label_dedicated_first), GTK_JUSTIFY_CENTER);

	label_dedicated_scnd = gtk_label_new (_("<span size='medium'><b>Eva and Alejandro</b>\nFor the birdth of their first son Adrian.</span> "));
	gtk_widget_show (label_dedicated_scnd);
	gtk_box_pack_start (GTK_BOX (vbox_dedicated), label_dedicated_scnd, TRUE, TRUE, 0);
	gtk_label_set_use_markup (GTK_LABEL (label_dedicated_scnd), TRUE);
	gtk_label_set_justify (GTK_LABEL (label_dedicated_scnd), GTK_JUSTIFY_CENTER);

	label_dedicated_thrd = gtk_label_new (_("<span size='medium'><b>Jorge and Laura</b>\nFor the birdth of their first and second sons Martin and Xoel.</span> "));
	gtk_widget_show (label_dedicated_thrd);
	gtk_box_pack_start (GTK_BOX (vbox_dedicated), label_dedicated_thrd, TRUE, TRUE, 0);
	gtk_label_set_use_markup (GTK_LABEL (label_dedicated_thrd), TRUE);
	gtk_label_set_justify (GTK_LABEL (label_dedicated_thrd), GTK_JUSTIFY_CENTER);

	label_dedicated = gtk_label_new (_("Dedicated to ..."));
	gtk_widget_show (label_dedicated);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 3), label_dedicated);
	gtk_label_set_justify (GTK_LABEL (label_dedicated), GTK_JUSTIFY_LEFT);
} // JUST FOR THIS RELEASE


  dialog_action_area = GTK_DIALOG (dialog_about)->action_area;
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  okbutton = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog_about), okbutton, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);

  	gtk_widget_add_accelerator (okbutton, "clicked", accel_group,
				    GDK_O, GDK_CONTROL_MASK,
				    GTK_ACCEL_VISIBLE);

	gtk_widget_add_accelerator (okbutton, "clicked", accel_group,
				    GDK_C, GDK_CONTROL_MASK,
				    GTK_ACCEL_VISIBLE);

	g_signal_connect_swapped ((gpointer) dialog_about, "close",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (dialog_about));

	g_signal_connect_swapped ((gpointer) okbutton, "clicked",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (dialog_about));

  	gtk_window_add_accel_group (GTK_WINDOW (dialog_about),
				    accel_group);

  return dialog_about;
}

GtkWidget *
create_search_dialog (CssedWindow * window)
{
	GtkWidget *search_dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *vbox;
	GtkWidget *hbox4;
	GtkWidget *label;
	GtkWidget *entry_text_to_find;
	GtkWidget *table;
	GtkWidget *checkbutton_regex;
	GtkWidget *radiobutton_perl_regex;
	GtkWidget *radiobutton_regex;
	GtkWidget *checkbutton_match_case;
	GtkWidget *checkbutton_whole_word;
	GtkWidget *checkbutton_word_start;
	GtkWidget *dialog_action_area;
	GtkWidget *dialog_search_help_button;
	GtkWidget *search_dialog_find_button;
	GtkWidget *search_dialog_cancel_button;
	CssedDoc* doc;
	GSList *radiobutton_perl_regex_group = NULL;

	search_dialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (search_dialog), _("Search"));
	gtk_window_set_destroy_with_parent (GTK_WINDOW (search_dialog), TRUE);
	gtk_window_set_modal (GTK_WINDOW (search_dialog), FALSE);
	gtk_window_set_transient_for ( GTK_WINDOW(search_dialog),
				      GTK_WINDOW ( cssed_window_get_window_widget(window) ));

	dialog_vbox = GTK_DIALOG (search_dialog)->vbox;
	gtk_widget_show (dialog_vbox);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), vbox, TRUE, TRUE, 0);

	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox), hbox4, TRUE, TRUE, 0);

	label = gtk_label_new (_("Text to find"));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox4), label, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

	entry_text_to_find = gtk_entry_new ();
	gtk_widget_show (entry_text_to_find);
	gtk_box_pack_start (GTK_BOX (hbox4), entry_text_to_find, TRUE, TRUE,
			    3);

	table = gtk_table_new (3, 2, TRUE);
	gtk_widget_show (table);
	gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (table), 6);
	gtk_table_set_row_spacings (GTK_TABLE (table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (table), 5);

	checkbutton_regex =
		gtk_check_button_new_with_mnemonic (_("Regular expression"));
	gtk_widget_show (checkbutton_regex);
	gtk_table_attach (GTK_TABLE (table), checkbutton_regex, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	radiobutton_perl_regex =
		gtk_radio_button_new_with_mnemonic (NULL, _("Perl regexp"));
	gtk_widget_show (radiobutton_perl_regex);
	gtk_table_attach (GTK_TABLE (table), radiobutton_perl_regex, 1, 2, 1,
			  2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_perl_regex),
				    radiobutton_perl_regex_group);
	radiobutton_perl_regex_group =
		gtk_radio_button_get_group (GTK_RADIO_BUTTON
					    (radiobutton_perl_regex));

	radiobutton_regex =
		gtk_radio_button_new_with_mnemonic (NULL, _("Posix regexp"));
	gtk_widget_show (radiobutton_regex);
	gtk_table_attach (GTK_TABLE (table), radiobutton_regex, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_regex),
				    radiobutton_perl_regex_group);
	radiobutton_perl_regex_group =
		gtk_radio_button_get_group (GTK_RADIO_BUTTON
					    (radiobutton_regex));

	checkbutton_match_case =
		gtk_check_button_new_with_mnemonic (_("Match case"));
	gtk_widget_show (checkbutton_match_case);
	gtk_table_attach (GTK_TABLE (table), checkbutton_match_case, 0, 1, 0,
			  1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	checkbutton_whole_word =
		gtk_check_button_new_with_mnemonic (_("Whole world only"));
	gtk_widget_show (checkbutton_whole_word);
	gtk_table_attach (GTK_TABLE (table), checkbutton_whole_word, 0, 1, 1,
			  2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	checkbutton_word_start =
		gtk_check_button_new_with_mnemonic (_("Word start"));
	gtk_widget_show (checkbutton_word_start);
	gtk_table_attach (GTK_TABLE (table), checkbutton_word_start, 0, 1, 2,
			  3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	dialog_action_area = GTK_DIALOG (search_dialog)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area),
				   GTK_BUTTONBOX_END);

	dialog_search_help_button = gtk_button_new_from_stock ("gtk-help");
	gtk_widget_show (dialog_search_help_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (search_dialog),
				      dialog_search_help_button,
				      GTK_RESPONSE_HELP);
	GTK_WIDGET_SET_FLAGS (dialog_search_help_button, GTK_CAN_DEFAULT);

	search_dialog_find_button = gtk_button_new_from_stock ("gtk-find");
	gtk_widget_show (search_dialog_find_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (search_dialog),
				      search_dialog_find_button,
				      GTK_RESPONSE_CLOSE);
	GTK_WIDGET_SET_FLAGS (search_dialog_find_button, GTK_CAN_DEFAULT);

	search_dialog_cancel_button = gtk_button_new_from_stock ("gtk-close");
	gtk_widget_show (search_dialog_cancel_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (search_dialog),
				      search_dialog_cancel_button,
				      GTK_RESPONSE_CLOSE);
	GTK_WIDGET_SET_FLAGS (search_dialog_cancel_button, GTK_CAN_DEFAULT);
	// get the current selected text to the dialog entry
	doc = document_get_current( window );
	if( doc ){
		gint sel_start;
		gint sel_end;

		sel_start = document_get_selection_start(doc);
		sel_end = document_get_selection_end( doc );
		if(  sel_end > sel_start  ){
			gchar* sel_text;
			sel_text = g_malloc0 (sel_end - sel_start + 2);
			document_get_selected_text( doc, sel_text );
			gtk_entry_set_text( GTK_ENTRY(entry_text_to_find), sel_text );
			g_free( sel_text );
		}
	}
	g_signal_connect_swapped ((gpointer) search_dialog, "close",
				  G_CALLBACK (gtk_widget_destroy),
				  G_OBJECT (search_dialog));
	g_signal_connect_swapped ((gpointer) search_dialog, "destroy",
				  G_CALLBACK (gtk_widget_destroy),
				  G_OBJECT (search_dialog));
	g_signal_connect ((gpointer) dialog_search_help_button, "clicked",
			  G_CALLBACK (on_dialog_search_help_button_clicked),
			  NULL);
	g_signal_connect_swapped ((gpointer) search_dialog_cancel_button,
				  "clicked", G_CALLBACK (gtk_widget_destroy),
				  G_OBJECT (search_dialog));
	g_signal_connect ((gpointer) search_dialog_find_button, "clicked",
			  G_CALLBACK (on_search_dialog_find_button_clicked),
			  window);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (search_dialog, search_dialog,
				    "search_dialog");
	GLADE_HOOKUP_OBJECT (search_dialog, label, "label");
	GLADE_HOOKUP_OBJECT (search_dialog, entry_text_to_find,
			     "entry_text_to_find");
	GLADE_HOOKUP_OBJECT (search_dialog, table, "table");
	GLADE_HOOKUP_OBJECT (search_dialog, checkbutton_regex,
			     "checkbutton_regex");
	GLADE_HOOKUP_OBJECT (search_dialog, radiobutton_perl_regex,
			     "radiobutton_perl_regex");
	GLADE_HOOKUP_OBJECT (search_dialog, radiobutton_regex,
			     "radiobutton_regex");
	GLADE_HOOKUP_OBJECT (search_dialog, checkbutton_match_case,
			     "checkbutton_match_case");
	GLADE_HOOKUP_OBJECT (search_dialog, checkbutton_whole_word,
			     "checkbutton_whole_word");
	GLADE_HOOKUP_OBJECT (search_dialog, checkbutton_word_start,
			     "checkbutton_word_start");
	GLADE_HOOKUP_OBJECT_NO_REF (search_dialog, dialog_action_area,
				    "dialog_action_area");
	GLADE_HOOKUP_OBJECT (search_dialog, dialog_search_help_button,
			     "dialog_search_help_button");
	GLADE_HOOKUP_OBJECT (search_dialog, search_dialog_find_button,
			     "search_dialog_find_button");
	GLADE_HOOKUP_OBJECT (search_dialog, search_dialog_cancel_button,
			     "search_dialog_cancel_button");

	return search_dialog;
}

GtkWidget *
create_replace_dialog (CssedWindow * window)
{
	GtkWidget *replace_dialog;
	GtkWidget *vbox_main;
	GtkWidget *vbox;
	GtkWidget *hbox_search_for;
	GtkWidget *label_search_for;
	GtkWidget *entry_find;
	GtkWidget *hbox_replace_with;
	GtkWidget *label_replace_with;
	GtkWidget *entry_replace;
	GtkWidget *table;
	GtkWidget *checkbutton_regex;
	GtkWidget *radiobutton_perl_regex;
	GSList *radiobutton_perl_regex_group = NULL;
	GtkWidget *radiobutton_posix_regex;
	GtkWidget *checkbutton_match_case;
	GtkWidget *checkbutton_whole_word;
	GtkWidget *checkbutton_word_start;
	GtkWidget *hbuttonbox;
	GtkWidget *dialog_replace_help_button;
	GtkWidget *dialog_replace_button;
	GtkWidget *dialog_replace_apply_button;
	GtkWidget *dialog_replace_close_button;
	CssedDoc* doc;

	replace_dialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (replace_dialog), _("Replace"));
	gtk_window_set_destroy_with_parent (GTK_WINDOW (replace_dialog), TRUE);
	gtk_window_set_transient_for ( GTK_WINDOW(replace_dialog),
				      GTK_WINDOW ( cssed_window_get_window_widget(window) ));

	vbox_main = GTK_DIALOG (replace_dialog)->vbox;
	gtk_widget_show (vbox_main);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (vbox_main), vbox, TRUE, TRUE, 0);

	hbox_search_for = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox_search_for);
	gtk_box_pack_start (GTK_BOX (vbox), hbox_search_for, TRUE, TRUE, 0);

	label_search_for = gtk_label_new (_("Search for   "));
	gtk_widget_show (label_search_for);
	gtk_box_pack_start (GTK_BOX (hbox_search_for), label_search_for, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label_search_for), GTK_JUSTIFY_LEFT);

	entry_find = gtk_entry_new ();
	gtk_widget_show (entry_find);
	gtk_box_pack_start (GTK_BOX (hbox_search_for), entry_find, TRUE, TRUE, 3);

	hbox_replace_with = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox_replace_with);
	gtk_box_pack_start (GTK_BOX (vbox), hbox_replace_with, TRUE, TRUE, 0);

	label_replace_with = gtk_label_new (_("Replace with"));
	gtk_widget_show (label_replace_with);
	gtk_box_pack_start (GTK_BOX (hbox_replace_with), label_replace_with, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label_replace_with), GTK_JUSTIFY_LEFT);

	entry_replace = gtk_entry_new ();
	gtk_widget_show (entry_replace);
	gtk_box_pack_start (GTK_BOX (hbox_replace_with), entry_replace, TRUE, TRUE, 3);

	table = gtk_table_new (3, 2, TRUE);
	gtk_widget_show (table);
	gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 1);
	gtk_table_set_row_spacings (GTK_TABLE (table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (table), 5);

	checkbutton_regex =
		gtk_check_button_new_with_mnemonic (_("Regular expression"));
	gtk_widget_show (checkbutton_regex);
	gtk_table_attach (GTK_TABLE (table), checkbutton_regex, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	radiobutton_perl_regex =
		gtk_radio_button_new_with_mnemonic (NULL, _("Perl regex"));
	gtk_widget_show (radiobutton_perl_regex);
	gtk_table_attach (GTK_TABLE (table), radiobutton_perl_regex, 1, 2, 1,
			  2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_perl_regex),
				    radiobutton_perl_regex_group);
	radiobutton_perl_regex_group =
		gtk_radio_button_get_group (GTK_RADIO_BUTTON
					    (radiobutton_perl_regex));

	radiobutton_posix_regex =
		gtk_radio_button_new_with_mnemonic (NULL, _("Posix regex"));
	gtk_widget_show (radiobutton_posix_regex);
	gtk_table_attach (GTK_TABLE (table), radiobutton_posix_regex, 1, 2,
			  2, 3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON
				    (radiobutton_posix_regex),
				    radiobutton_perl_regex_group);
	radiobutton_perl_regex_group =
		gtk_radio_button_get_group (GTK_RADIO_BUTTON
					    (radiobutton_posix_regex));

	checkbutton_match_case =
		gtk_check_button_new_with_mnemonic (_("Match case"));
	gtk_widget_show (checkbutton_match_case);
	gtk_table_attach (GTK_TABLE (table), checkbutton_match_case, 0, 1, 0,
			  1, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	checkbutton_whole_word =
		gtk_check_button_new_with_mnemonic (_("Whole world only"));
	gtk_widget_show (checkbutton_whole_word);
	gtk_table_attach (GTK_TABLE (table), checkbutton_whole_word, 0, 1, 1,
			  2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	checkbutton_word_start =
		gtk_check_button_new_with_mnemonic (_("Word start"));
	gtk_widget_show (checkbutton_word_start);
	gtk_table_attach (GTK_TABLE (table), checkbutton_word_start, 0, 1, 2,
			  3, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	hbuttonbox = GTK_DIALOG (replace_dialog)->action_area;
	gtk_widget_show (hbuttonbox);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox),
				   GTK_BUTTONBOX_END);

	dialog_replace_help_button = gtk_button_new_from_stock ("gtk-help");
	gtk_widget_show (dialog_replace_help_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (replace_dialog),
				      dialog_replace_help_button,
				      GTK_RESPONSE_HELP);
	GTK_WIDGET_SET_FLAGS (dialog_replace_help_button, GTK_CAN_DEFAULT);

	dialog_replace_button = gtk_button_new_from_stock ("gtk-find");
	gtk_widget_show (dialog_replace_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (replace_dialog),
				      dialog_replace_button, 0);
	GTK_WIDGET_SET_FLAGS (dialog_replace_button, GTK_CAN_DEFAULT);

	dialog_replace_apply_button = gtk_button_new_from_stock ("gtk-apply");
	gtk_widget_show (dialog_replace_apply_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (replace_dialog),
				      dialog_replace_apply_button,
				      GTK_RESPONSE_APPLY);
	GTK_WIDGET_SET_FLAGS (dialog_replace_apply_button, GTK_CAN_DEFAULT);

	dialog_replace_close_button = gtk_button_new_from_stock ("gtk-close");
	gtk_widget_show (dialog_replace_close_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (replace_dialog),
				      dialog_replace_close_button,
				      GTK_RESPONSE_CLOSE);
	GTK_WIDGET_SET_FLAGS (dialog_replace_close_button, GTK_CAN_DEFAULT);

	// get the current selected text to the dialog entry
	doc = document_get_current( window );
	if( doc ){
		gint sel_start;
		gint sel_end;

		sel_start = document_get_selection_start(doc);
		sel_end = document_get_selection_end( doc );
		if(  sel_end > sel_start  ){
			gchar* sel_text;
			sel_text = g_malloc0 (sel_end - sel_start + 2);
			document_get_selected_text( doc, sel_text );
			gtk_entry_set_text( GTK_ENTRY(entry_find), sel_text );
			g_free( sel_text );
		}
	}

	g_signal_connect_swapped ((gpointer) replace_dialog, "close",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (replace_dialog));
	g_signal_connect_swapped ((gpointer) replace_dialog, "destroy",
				  G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (replace_dialog));
	g_signal_connect ((gpointer) dialog_replace_help_button, "clicked",
			  G_CALLBACK (on_dialog_replace_help_button_clicked),
			  NULL);

	g_signal_connect ((gpointer) dialog_replace_apply_button, "clicked",
			  G_CALLBACK (on_dialog_replace_apply_button_clicked),
			  window);
	g_signal_connect ((gpointer) dialog_replace_button, "clicked",
			  G_CALLBACK
			  (on_dialog_replace_search_button_clicked), window);


	g_signal_connect_swapped ((gpointer) dialog_replace_close_button,
				  "clicked", G_CALLBACK (gtk_widget_destroy),
				  GTK_OBJECT (replace_dialog));

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (replace_dialog, replace_dialog,
				    "replace_dialog");
	GLADE_HOOKUP_OBJECT (replace_dialog, label_search_for, "label_search_for");
	GLADE_HOOKUP_OBJECT (replace_dialog, entry_find, "entry_find");
	GLADE_HOOKUP_OBJECT (replace_dialog, entry_replace, "entry_replace");
	GLADE_HOOKUP_OBJECT (replace_dialog, checkbutton_regex,
			     "checkbutton_regex");
	GLADE_HOOKUP_OBJECT (replace_dialog, radiobutton_perl_regex,
			     "radiobutton_perl_regex");
	GLADE_HOOKUP_OBJECT (replace_dialog, radiobutton_posix_regex,
			     "radiobutton_posix_regex");
	GLADE_HOOKUP_OBJECT (replace_dialog, checkbutton_match_case,
			     "checkbutton_match_case");
	GLADE_HOOKUP_OBJECT (replace_dialog, checkbutton_whole_word,
			     "checkbutton_whole_word");
	GLADE_HOOKUP_OBJECT (replace_dialog, checkbutton_word_start,
			     "checkbutton_word_start");
	GLADE_HOOKUP_OBJECT_NO_REF (replace_dialog, hbuttonbox, "hbuttonbox");
	GLADE_HOOKUP_OBJECT (replace_dialog, dialog_replace_help_button,
			     "dialog_replace_help_button");
	GLADE_HOOKUP_OBJECT (replace_dialog, dialog_replace_button,
			     "dialog_replace_button");
	GLADE_HOOKUP_OBJECT (replace_dialog, dialog_replace_apply_button,
			     "dialog_replace_apply_button");
	GLADE_HOOKUP_OBJECT (replace_dialog, dialog_replace_close_button,
			     "dialog_replace_close_button");

	return replace_dialog;
}

void
set_css_properties_treeview (CssedWindow* window)
{

	GtkTreeViewColumn *col;
	GtkCellRenderer *renderer;
	GtkTreeStore *model;
	GtkWidget *treeview;
	GtkTreeIter toplevel, child, third;
	Tcssed_tp_data data;

	treeview = cssed_window_get_css_definition_treeview ( window );

	/* --- Column #1 --- */
	col = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (col, "Version");
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), col);
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (col, renderer, TRUE);
	gtk_tree_view_column_add_attribute (col, renderer, "text",
					    COL_CSS_VER);

	/* --- Column #2 --- */
	col = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (col, "Property");
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), col);
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (col, renderer, TRUE);
	gtk_tree_view_column_add_attribute (col, renderer, "text", COL_ATTR);

	/* --- Column #3 --- */
	col = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (col, "Value");
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), col);
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (col, renderer, TRUE);
	gtk_tree_view_column_add_attribute (col, renderer, "text", COL_VALUE);

	model = gtk_tree_store_new (NUM_COLS, G_TYPE_STRING, G_TYPE_STRING,
				    G_TYPE_STRING);

	// fill data struct values to pass to func
	data.first_col = &toplevel;
	data.second_col = &child;
	data.thrid_col = &third;
	data.store = model;
	data.window = window;
	// parse the xml and fill the values on the treeview
	parse_css_definition_and_fill_tree_view (&data);

	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview),
				 GTK_TREE_MODEL (model));
	g_object_unref (GTK_TREE_MODEL (model));	/* destroy model automatically with view */
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection
				     (GTK_TREE_VIEW (treeview)),
				     GTK_SELECTION_SINGLE);

}








