/*
 * Time-stamp: <99/02/19 08:47:03 panic>
 * Author:	The C-Mix Project <cmix@diku.dk>
 *              Peter Holst Andersen <txix@diku.dk>
 *              Arne John Glenstrup  <panic@diku.dk>
 * Contents:	The main function and declaration of global variables.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/times.h>
#include <unistd.h>
#ifdef USE_PLOT
#  include "plot.h"
#endif
#ifdef HAVE_LIBTIFF
#  include "tiff.h"
   int  compress = TIFF_COMPRESS_NONE;
#endif
#include <string.h>
#include "ray.h"

int getopt(int, char * const [], const char *);
int drawscene(int, int, int, int);
extern char *optarg;
extern int  optind, opterr;
extern int lastscene;

int  to_screen, to_file;
char prg_name[256];
char image_file[256];
int  eyepointSelected = FALSE;
int  lookpointSelected = FALSE;
int  updirSelected = FALSE;
int  fieldOfViewSelected = FALSE;
viewType userview;

static void usage()
{
    fprintf(stderr,
	    "usage: %s [-n scene#] "
#ifdef HAVE_LIBTIFF
	    "[-o filename] [-z] [-p] "
#endif
#ifdef USE_PLOT
	    "[-s] "
#endif
	    "[-S size] [-c]\n"
	    "           [-e x,y,z] [-l x,y,z] [-u x,y,z] [-f angle]\n"
	    "       -n: select scene number (1-%d)\n"
#ifdef HAVE_LIBTIFF
	    "       -z: use LZW TIFF file compression\n"
	    "       -p: use PackBits TIFF file compression\n"
#endif
#ifdef USE_PLOT
	    "       -s: do not output to screen\n"
#endif
	    "       -c: use colours\n"
	    "       -e: eyepoint\n"
	    "       -l: lookpoint\n"
	    "       -u: up direction\n"
	    "       -f: field of view\n",
	    prg_name, lastscene);
    exit(-1);
};

extern int main(int argc, char **argv)
{
  int  image_x, image_y, use_color;
  char c;
  int  use_scene;
    
  strcpy(prg_name, argv[0]);
  to_screen = TRUE;
  to_file = FALSE;
  use_scene = -1;
  image_x = 512;
  image_y = 512;
  use_color = 0;
  SRANDOM(getpid());
   
  while((c = getopt(argc, argv, "so:n:S:ce:l:u:f:zp")) != -1) {
    switch(c) {
    case 's':
      to_screen = FALSE;
      break;
    case 'o':
      to_file = TRUE;
      strcpy(image_file, optarg);
      break;
    case 'n':
      use_scene = atoi(optarg);
      break;
    case 'S':
      image_x = atoi(optarg);
      image_y = image_x;
      if (image_x <= 0)
	usage();
      break;
    case 'c':
      use_color = 1;
      break;
    case 'e':
      eyepointSelected = TRUE;
      if (sscanf(optarg, "%lg,%lg,%lg",
		 &userview.pos.x, &userview.pos.y, &userview.pos.z)
	  != 3) usage();
      fprintf(stderr, "eyepoint=(%lg, %lg, %lg)\n",
	      userview.pos.x, userview.pos.y, userview.pos.z);
      break;
    case 'l':
      lookpointSelected = TRUE;
      if (sscanf(optarg, "%lg,%lg,%lg",
		 &userview.lookp.x, &userview.lookp.y, &userview.lookp.z)
	  != 3) usage();
      fprintf(stderr, "lookpoint=(%lg, %lg, %lg)\n",
	      userview.lookp.x, userview.lookp.y, userview.lookp.z);
      break;
    case 'u':
      updirSelected = TRUE;
      if (sscanf(optarg, "%lg,%lg,%lg",
		 &userview.up.x, &userview.up.y, &userview.up.z)
	  != 3) usage();
      fprintf(stderr, "updir=(%lg, %lg, %lg)\n",
	      userview.up.x, userview.up.y, userview.up.z);
      break;
    case 'f':
      fieldOfViewSelected = TRUE;
      userview.hfov = userview.vfov = atof(optarg);
      break;
#ifdef HAVE_LIBTIFF
    case 'z':
      compress = TIFF_COMPRESS_LZW;
      break;
    case 'p':
      compress = TIFF_COMPRESS_PACKBITS;
      break;
#endif
    default:
      usage();
    }
  }
  {
    struct tms tstart, tstop;
    double tuser, tsys;
    long clk_tck;
    times(&tstart);
    drawscene(image_x, image_y, use_scene, use_color);
    times(&tstop);
    printf("%-16s: completed\n", prg_name);
    clk_tck = sysconf(_SC_CLK_TCK);
    tuser = (double)(tstop.tms_utime - tstart.tms_utime) /
      (double)clk_tck;
    tsys = (double)(tstop.tms_stime - tstart.tms_stime) /
      (double)clk_tck;
    printf("\n%-16s:             User time       (System time   )\n"
	   "%-16s: Total time: %6.5g seconds  (%6.5g seconds)\n",
	   prg_name,
	   prg_name, tuser, tsys);
    fflush(stdout);
  }
#ifdef USE_PLOT
  if (to_screen) {
    waitKeyOrClick();
    closeWindow();
  }
#endif
  return 0;
}
