;;; makeconf.el - A generic installer based on APEL installer.
;;;

;;; Module configuration.
;;; (This part has been made to be online specific.)
(defconst SUBDIR "online" "A subdirectory to be used below LISPDIR")
(defconst PRIMARYMODULE 'online "Used to detect already installed dir.")
(defconst MODULES '(online)
  "List of modules to compile and install.")




;;; @ Installer globals
;;;
(defvar PREFIX nil "A global to hold a string of the install prefix.")
(defvar EXEC_PREFIX nil "A global to hold a string of the executable.")
(defvar LISPDIR nil "A global to hold a string of the lisp directory.")
(defvar INFODIR nil "A global to hold a string of the info directory.")
(defvar VERSION_SPECIFIC_LISPDIR nil
  "A global to hold a string of the version specific lisp directory.")

;;; @ Installer code starts here
;;;
(defun config-find-install-dir ()
  "Find if we should use subdirectory to install modules."
  (let ((el (concat (expand-file-name (symbol-name PRIMARYMODULE) LISPDIR)
		    ".el")))
    (cond ((file-exists-p el)
	   LISPDIR)  ;; if already installed without subdir.
	  ((or (featurep 'xemacs)
	       (and (fboundp 'set-buffer-multibyte)
		    (subrp (symbol-function 'set-buffer-multibyte))))
	   (expand-file-name SUBDIR LISPDIR)) ;; for recent emacsen
	  (t LISPDIR)))) ;; default is still no subdir.

(defun config-modules ()
  (let (prefix exec-prefix lisp-dir)
    (and (setq prefix (car command-line-args-left))
	 (or (string-equal "NONE" prefix)
	     (setq PREFIX prefix)
	     ))
    (setq command-line-args-left (cdr command-line-args-left))
    (and (setq exec-prefix (car command-line-args-left))
	 (or (string-equal "NONE" exec-prefix)
	     (setq EXEC_PREFIX exec-prefix)
	     ))
    (setq command-line-args-left (cdr command-line-args-left))
    (and (setq lisp-dir (car command-line-args-left))
	 (or (string-equal "NONE" lisp-dir)
	     (setq LISPDIR lisp-dir)
	     ))
    (setq command-line-args-left (cdr command-line-args-left))
    (and (setq info-dir (car command-line-args-left))
	 (or (string-equal "NONE" info-dir)
	     (setq INFODIR info-dir)
	     ))
    (setq command-line-args-left (cdr command-line-args-left))
    (and (setq version-specific-lisp-dir (car command-line-args-left))
	 (or (string-equal "NONE" version-specific-lisp-dir)
	     (progn
	       (setq VERSION_SPECIFIC_LISPDIR version-specific-lisp-dir)
	       (princ (format "VERSION_SPECIFIC_LISPDIR=%s\n"
			      VERSION_SPECIFIC_LISPDIR)))
	     ))
    (setq command-line-args-left (cdr command-line-args-left)))
  
  (if (null LISPDIR)
      (setq LISPDIR (install-detect-elisp-directory PREFIX)))

  (setq INSTALL_DIR (config-find-install-dir))
  
  (princ (format "PREFIX=%s\nEXEC_PREFIX=%s\nLISPDIR=%s\n"
		 PREFIX EXEC_PREFIX LISPDIR)))

(defun compile-modules ()
  (config-modules)
  (compile-elisp-modules MODULES "."))

(defun install-modules ()
  (config-modules)
  (compile-elisp-modules MODULES ".")
  (install-elisp-modules MODULES "." INSTALL_DIR))

(defun what-where-modules ()
  (config-modules)
  (install-elisp-modules MODULES "." INSTALL_DIR 'just-print))


;;; The following part is copied from APEL (as of 10.4) and modified
;;; to avoid dependency.
;;;

;;;INSTALL-MK;;;-------------------------------------------------------

;;; install.el --- Emacs Lisp package install utility

;; Copyright (C) 1996,1997,1998,1999,2001 Free Software Foundation, Inc.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Created: 1996/08/18
;; Keywords: install, byte-compile, directory detection

;; This file is part of APEL (A Portable Emacs Library).

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

;;;-INSTALL-MK-;;;(require 'poe)	      ; make-directory for v18
;;;-INSTALL-MK-;;;(require 'path-util)	      ; default-load-path

;;;INSTALL-MK;;;++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;;INSTALL-MK;;; copied from path-util
(defvar default-load-path load-path
  "*Base of `load-path'.
It is used as default value of target path to search file or
subdirectory under load-path.")
;;;INSTALL-MK;;;++++++++++++++++++++++++++++++++++++++++++++++++++++++

;;; @ compile Emacs Lisp files
;;;

(defun compile-elisp-module (module &optional path every-time)
  (setq module (expand-file-name (symbol-name module) path))
  (let ((el-file (concat module ".el"))
	(elc-file (concat module ".elc")))
    (if (or every-time
	    (file-newer-than-file-p el-file elc-file))
	(byte-compile-file el-file))))

(defun compile-elisp-modules (modules &optional path every-time)
  (mapcar
   (function
    (lambda (module)
      (compile-elisp-module module path every-time)))
   modules))


;;; @ install files
;;;

(defvar install-overwritten-file-modes (+ (* 64 6)(* 8 4) 4)) ; 0644

(defun install-file (file src dest &optional move overwrite just-print)
  (if just-print
      (princ (format "%s -> %s\n" file dest))
    (let ((src-file (expand-file-name file src)))
      (if (file-exists-p src-file)
	  (let ((full-path (expand-file-name file dest)))
	    (if (and (file-exists-p full-path) overwrite)
		(delete-file full-path))
	    (copy-file src-file full-path t t)
	    (set-file-modes full-path install-overwritten-file-modes)
	    (if move
		(catch 'tag
		  (while (and (file-exists-p src-file)
			      (file-writable-p src-file))
		    (condition-case err
			(progn
			  (delete-file src-file)
			  (throw 'tag nil))
		      (error (princ (format "%s\n" (nth 1 err))))))))
	    (princ (format "%s -> %s\n" file dest)))))))

(defun install-files (files src dest &optional move overwrite just-print)
  (or just-print
      (file-exists-p dest)
      (make-directory dest t))
  (mapcar
   (function
    (lambda (file)
      (install-file file src dest move overwrite just-print)))
   files))


;;; @@ install Emacs Lisp files
;;;

(defun install-elisp-module (module src dest &optional just-print del-elc)
  (let (el-file elc-file)
    (let ((name (symbol-name module)))
      (setq el-file (concat name ".el"))
      (setq elc-file (concat name ".elc")))
    (let ((src-file (expand-file-name el-file src)))
      (if (not (file-exists-p src-file))
	  nil 
	(if just-print
	    (princ (format "%s -> %s\n" el-file dest))
	  (let ((full-path (expand-file-name el-file dest)))
	    (if (file-exists-p full-path)
		(delete-file full-path))
	    (copy-file src-file full-path t t)
	    (set-file-modes full-path install-overwritten-file-modes)
	    (princ (format "%s -> %s\n" el-file dest)))))
      (setq src-file (expand-file-name elc-file src))
      (if (not (file-exists-p src-file))
	  (let ((full-path (expand-file-name elc-file dest)))
	    (if (and del-elc (file-exists-p full-path))
		(if just-print
		    (princ (format "%s -> to be deleted\n" full-path))
		  (delete-file full-path)
		  (princ (format "%s -> deleted\n" full-path)))))
	(if just-print
	    (princ (format "%s -> %s\n" elc-file dest))
	  (let ((full-path (expand-file-name elc-file dest)))
            (if (file-exists-p full-path)
                (delete-file full-path))
	    (copy-file src-file full-path t t)
	    (set-file-modes full-path install-overwritten-file-modes)
	    (catch 'tag
	      (while (file-exists-p src-file)
		(condition-case err
		    (progn
		      (delete-file src-file)
		      (throw 'tag nil))
		  (error (princ (format "%s\n" (nth 1 err)))))))
	    (princ (format "%s -> %s\n" elc-file dest))))))))

(defun install-elisp-modules (modules src dest &optional just-print del-elc)
  (or just-print
      (file-exists-p dest)
      (make-directory dest t))
  (mapcar
   (function
    (lambda (module)
      (install-elisp-module module src dest just-print del-elc)))
   modules))


;;; @ detect install path
;;;

;; install to shared directory (maybe "/usr/local")
(defvar install-prefix
  (if (or (<= emacs-major-version 18)
	  (featurep 'xemacs)
	  (and (boundp 'system-configuration-options) ; 19.29 or later
	       (string= system-configuration-options "NT"))) ; for Meadow
      (expand-file-name "../../.." exec-directory)
    (expand-file-name "../../../.." data-directory)))

(defvar install-elisp-prefix
  (if (>= emacs-major-version 19)
      "site-lisp"
    ;; v18 does not have standard site directory.
    "local.lisp"))

(defun install-detect-elisp-directory (&optional prefix elisp-prefix
						 allow-version-specific)
  (or prefix
      (setq prefix install-prefix))
  (or elisp-prefix
      (setq elisp-prefix install-elisp-prefix))
  (or (catch 'tag
	(let ((rest default-load-path)
	      (regexp (concat "^"
			      (expand-file-name (concat ".*/" elisp-prefix)
						prefix)
			      "/?$")))
	  (while rest
	    (if (string-match regexp (car rest))
		(if (or allow-version-specific
			(not (string-match (format "/%d\\.%d"
						   emacs-major-version
						   emacs-minor-version)
					   (car rest))))
		    (throw 'tag (car rest))))
	    (setq rest (cdr rest)))))
      (expand-file-name (concat (if (and (not (featurep 'xemacs))
					 (or (>= emacs-major-version 20)
					     (and (= emacs-major-version 19)
						  (> emacs-minor-version 28))))
				    "share/"
				  "lib/")
				(cond
				 ((featurep 'xemacs)
				  (if (featurep 'mule)
				      "xmule/"
				    "xemacs/"))
				 ;; unfortunately, unofficial mule based on
				 ;; 19.29 and later use "emacs/" by default.
				 ((boundp 'MULE) "mule/")
				 ((boundp 'NEMACS) "nemacs/")
				 (t "emacs/"))
				elisp-prefix)
			prefix)))

(defvar install-default-elisp-directory
  (install-detect-elisp-directory))


;;; @ for XEmacs package system
;;;

(defun install-update-package-files (package dir &optional just-print)
  (cond
   (just-print
    (princ (format "Updating autoloads in directory %s..\n\n" dir))

    (princ (format "Processing %s\n" dir))
    (princ "Generating custom-load.el...\n\n")

    (princ (format "Compiling %s...\n"
		   (expand-file-name "auto-autoloads.el" dir)))
    (princ (format "Wrote %s\n"
		   (expand-file-name "auto-autoloads.elc" dir)))

    (princ (format "Compiling %s...\n"
		   (expand-file-name "custom-load.el" dir)))
    (princ (format "Wrote %s\n"
		   (expand-file-name "custom-load.elc" dir))))
   (t
    (setq autoload-package-name package)

    (let ((command-line-args-left (list dir)))
      (batch-update-directory))

    (let ((command-line-args-left (list dir)))
      (Custom-make-dependencies))

    (byte-compile-file (expand-file-name "auto-autoloads.el" dir))
    (byte-compile-file (expand-file-name "custom-load.el" dir)))))


;;; @ Other Utilities
;;;

(defun install-just-print-p ()
  (let ((flag (getenv "MAKEFLAGS"))
	(case-fold-search nil))
    (princ (format "%s\n" flag))
    (if flag
	(string-match "^\\(\\(--[^ ]+ \\)+-\\|[^ =-]\\)*n" flag))))


;;; @ end
;;;

;;;-INSTALL-MK-;;;(require 'product)
;;;-INSTALL-MK-;;;(product-provide (provide 'install) (require 'apel-ver))

;;; install.el ends here

;;;INSTALL-MK;;;-------------------------------------------------------
