/* original copyright by ƣ ɰϺ(GHC02331@niftyserve.or.jp) */
/* this file is added by FURUKAWA Yo (you@ss.iij4u.or.jp) */

#include <stdio.h>
#include <stdlib.h>
#include <locale.h>
#include <time.h>
#include "lfunc.h"

BYTE EmptyStr[1] = {0};

void
fatal(BYTE msg[] )
{
    fprintf(stderr, msg);
    exit(99);
}

void
wcs_fatal( LPCTSTR msg )
{
    fprintf(stderr, msg);
    exit(99);
}

void
fatal_msg( int val )
{
    BYTE *p ;

    switch ( val ) {
    case 3:
	p = "E005:Obsolete Data" ;
	break ;
    case 6:
	p = "E009:Insufficient nodes" ;
	break ;
    case 19:
	p = "E011:Insufficient RSTAT" ;
	break ;
    case 20:
	p = "???" ;
	break ;
    default:
	p = "unknown" ;
	break ;
    }
    fatal(p) ;
}

/*----------------------------------------------------------------------------
 * ٥եؿ
 *--------------------------------------------------------------------------*/
#define INVALID_HANDLE_VALUE NULL

FILE *hFile = INVALID_HANDLE_VALUE;

void
Fclose( void )
{
    if ( hFile != INVALID_HANDLE_VALUE ) {
	fclose(hFile);
	hFile = INVALID_HANDLE_VALUE ;
    }
}

BOOL
Fopen( LPCTSTR fn, LPCTSTR mode )
{
    hFile = fopen(fn, mode);
    if (hFile == NULL){
	return FALSE;
    }
    return TRUE;
}

int
Fread(void* buf, int size)
{
    return fread(buf, 1, size, hFile);
}

WORD
Fread_far( void* _buf, WORD size )
{
    return (WORD) Fread( _buf, size ) ;
}

int
FreadBuf( void* buf, int size )
{
    return Fread( buf, size ) ;
}

int
Fwrite( void* buf, int size )
{
    return fwrite(buf, 1, size, hFile);
}

int
Fwrite_far( void* buf, WORD size )
{
    return Fwrite( buf, (DWORD) size ) ;
}

void
Fseek( long ptr, int whence )
{
    fseek(hFile, ptr, whence);
}

/*
 * ̾Ρե¸ߥå
 * ؿ̾Fexist
 * src(ե̾)
 * ͡BOOL(TRUE=, FALSE=ʤ)
 *   סե뤬¸ߤ뤫ɤĴ٤
 */
BOOL
Fexist( LPCTSTR src )
{
    FILE *fp;

    fp = fopen(src, "r");
    if (fp == NULL){
	return FALSE;
    }
    fclose(fp);
    return TRUE;
}

void
get_nowstr( BYTE *buf )
{
    struct tm *local_time;
    time_t now;
    int year;

    setlocale(LC_TIME, "");
    time(&now);
    local_time = localtime(&now);
    year = local_time->tm_year >= 100 ? (local_time->tm_year - 100) : /* Y2K */
       local_time->tm_year;
    sprintf(buf, "%02d-%02d-%02d %02d:%02d",
	    year,
	    local_time->tm_mon + 1,
	    local_time->tm_mday,
	    local_time->tm_hour,
	    local_time->tm_min);
 }

BYTE	*Msg0[] = {
    "[]", "[]", "", "", "¾",
    "", "", "", "", "   ",
    "  ", "    ", "    ", "   ",
} ;
BYTE	*Msg1[] = {
    "You can't use any routes"
} ;

BYTE*
get_msg( int kind, int idx )
{
    static	BYTE	msg[ 128 ] ;
    
    if ( kind == 0 ) {
	return Msg0[ idx ] ;
    } else if ( kind == 1 ) {
	return Msg1[ idx ] ;
    }
    return msg ;
}
