/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.annotation.Nonnull;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.w3c.dom.Attr;

public class KeyDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        KeyDescriptor keyDescriptor = (KeyDescriptor)parentObject;
        if (childObject instanceof KeyInfo) {
            keyDescriptor.setKeyInfo((KeyInfo)childObject);
        } else if (childObject instanceof EncryptionMethod) {
            keyDescriptor.getEncryptionMethods().add((EncryptionMethod)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        KeyDescriptor keyDescriptor = (KeyDescriptor)xmlObject;
        if (attribute.getName().equals("use") && attribute.getNamespaceURI() == null) {
            if (UsageType.SIGNING.getValue().equals(attribute.getValue())) {
                keyDescriptor.setUse(UsageType.SIGNING);
                return;
            } else {
                if (!UsageType.ENCRYPTION.getValue().equals(attribute.getValue())) throw new UnmarshallingException("Invalid key usage type: " + attribute.getValue());
                keyDescriptor.setUse(UsageType.ENCRYPTION);
            }
            return;
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }
}

