/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.summarization;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.summarization.GenericMultiCenter;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MultiCenter
extends GenericMultiCenter<float[]> {
    ArrayList<Weighted<Integer>> assignedPoints = new ArrayList();

    MultiCenter(float[] coordinate, float weight, double shrinkage, int numberOfRepresentatives) {
        super(coordinate, weight, shrinkage, numberOfRepresentatives);
    }

    public static MultiCenter initialize(float[] coordinate, float weight, double shrinkage, int numberOfRepresentatives) {
        CommonUtils.checkArgument(shrinkage >= 0.0 && shrinkage <= 1.0, " parameter has to be in [0,1]");
        CommonUtils.checkArgument(numberOfRepresentatives > 0 && numberOfRepresentatives <= 100, " the number of representatives has to be in (0,100]");
        return new MultiCenter(coordinate, weight, shrinkage, numberOfRepresentatives);
    }

    @Override
    public void addPoint(int index, float weight, double dist, float[] point, BiFunction<float[], float[], Double> distance) {
        super.addPoint(index, weight, dist, point, distance);
        this.assignedPoints.add(new Weighted<Integer>(index, weight));
    }

    @Override
    public void reset() {
        super.reset();
        this.assignedPoints = new ArrayList();
    }

    @Override
    public double recompute(Function<Integer, float[]> getPoint, boolean force, BiFunction<float[], float[], Double> distanceFunction) {
        if (this.assignedPoints.size() == 0 || this.weight == 0.0 || !force) {
            return 0.0;
        }
        this.previousSumOFRadius = this.sumOfRadius;
        this.sumOfRadius = 0.0;
        for (int j = 0; j < this.assignedPoints.size(); ++j) {
            double addTerm = this.distance(getPoint.apply((Integer)this.assignedPoints.get((int)j).index), distanceFunction) * (double)this.assignedPoints.get((int)j).weight;
            this.sumOfRadius += addTerm;
        }
        return this.previousSumOFRadius - this.sumOfRadius;
    }

    @Override
    public List<Weighted<Integer>> getAssignedPoints() {
        return this.assignedPoints;
    }
}

