/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ns.NetException;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.SSLConfig;

class PEMKeyStore
implements Diagnosable {
    private static final String CLASS_NAME = PEMKeyStore.class.getName();
    private static final Pattern CERTIFICATE_PATTERN = Pattern.compile("-----BEGIN CERTIFICATE-----(.*?)-----END CERTIFICATE-----", 32);
    private static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("-----BEGIN (?:ENCRYPTED |)PRIVATE KEY-----(.*?)-----END (?:ENCRYPTED |)PRIVATE KEY-----", 32);
    private static final Pattern CLEAR_PRIVATE_KEY_PATTERN = Pattern.compile("-----BEGIN PRIVATE KEY-----(.*?)-----END PRIVATE KEY-----", 32);
    private static final Pattern ENCRYPTED_PRIVATE_KEY_PATTERN = Pattern.compile("-----BEGIN ENCRYPTED PRIVATE KEY-----(.*?)-----END ENCRYPTED PRIVATE KEY-----", 32);
    private static final String PEM_CERTIFICATE_TYPE = "X.509";
    private final SSLConfig config;
    private final KeyStore keyStore;
    private int privateKeyCount;
    private char[] pwd;
    private final List<Certificate> trustCertificates = new LinkedList<Certificate>();
    private final List<Certificate> chainedCertificates = new LinkedList<Certificate>();
    private PrivateKey privateKey;
    private final boolean isTrustStore;

    PEMKeyStore(SSLConfig cfg, KeyStore ks, boolean isTrustStore) throws Exception {
        this.isTrustStore = isTrustStore;
        this.config = cfg;
        this.keyStore = ks;
        String pemFile = isTrustStore ? cfg.getTrustStore() : cfg.getKeyStore();
        this.loadKeyStore(this.content(pemFile));
    }

    PEMKeyStore(SSLConfig cfg, KeyStore ks, String pemContent, boolean isTrustStore) throws Exception {
        this.isTrustStore = isTrustStore;
        this.config = cfg;
        this.keyStore = ks;
        this.loadKeyStore(pemContent);
    }

    KeyStore getKeyStore() {
        return this.keyStore;
    }

    int getPrivateKeyCount() {
        return this.privateKeyCount;
    }

    private void loadKeyStore(String pemContent) throws NetException {
        this.pwd = this.isTrustStore ? this.config.getTrustStorePassword().getChars() : this.config.getKeyStorePassword().getChars();
        try {
            ArrayList<String> certs = new ArrayList<String>();
            Matcher certificateMatcher = CERTIFICATE_PATTERN.matcher(pemContent);
            while (certificateMatcher.find()) {
                certs.add(certificateMatcher.group(1).replace("\n", "").trim());
            }
            if (certs.isEmpty()) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "loadKeyStore", "No certificate found in the PEM keystore.", null, null);
                throw new NetException(17972);
            }
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "loadKeyStore", "{0} certificate(s) found in the PEM keystore.", (String)null, null, (Object)certs.size());
            this.privateKey = this.getPrivateKey(pemContent);
            this.initCertificates(certs);
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "loadKeyStore", "Found {0} certificate(s) corresponding to the private key. Found {1} trust certificate(s).", (String)null, null, (Object)this.chainedCertificates.size(), (Object)this.trustCertificates.size());
            this.keyStore.load(null, this.pwd);
            if (this.privateKey != null) {
                this.keyStore.setKeyEntry("key", this.privateKey, this.pwd, this.chainedCertificates.toArray(new Certificate[0]));
            }
            for (int i = 0; i < this.trustCertificates.size(); ++i) {
                this.keyStore.setCertificateEntry("oratc" + i, this.trustCertificates.get(i));
            }
        }
        catch (NetException e) {
            throw e;
        }
        catch (Exception e) {
            throw (NetException)new NetException(17971).initCause(e);
        }
        finally {
            CustomSSLSocketFactory.clearPwd(this.pwd);
        }
    }

    private PrivateKey getPrivateKey(String pemContent) throws Exception {
        int privateKeyIndex = this.config.getPemPrivateKeyIndex();
        Matcher privateKeyMatcher = PRIVATE_KEY_PATTERN.matcher(pemContent);
        String privateKeyContent = null;
        this.privateKeyCount = 0;
        while (privateKeyMatcher.find()) {
            ++this.privateKeyCount;
            if (this.privateKeyCount != privateKeyIndex) continue;
            privateKeyContent = privateKeyMatcher.group().trim();
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getPrivateKey", "Found {0} private keys from the PEM KeyStore. Index to be selected is {1}", (String)null, null, (Object)this.privateKeyCount, (Object)privateKeyIndex);
        if (this.privateKeyCount == 0) {
            return null;
        }
        if (privateKeyContent == null) {
            throw new NetException(17970);
        }
        Matcher encPrivateKeyMatcher = ENCRYPTED_PRIVATE_KEY_PATTERN.matcher(privateKeyContent);
        PKCS8EncodedKeySpec encodedKeySpec = null;
        if (encPrivateKeyMatcher.find()) {
            privateKeyContent = encPrivateKeyMatcher.group(1).replace("\n", "").trim();
            EncryptedPrivateKeyInfo pkInfo = new EncryptedPrivateKeyInfo(this.decode(privateKeyContent));
            PBEKeySpec pbeKeySpec = new PBEKeySpec(this.pwd);
            SecretKey secretKey = SecretKeyFactory.getInstance(pkInfo.getAlgName()).generateSecret(pbeKeySpec);
            encodedKeySpec = pkInfo.getKeySpec(secretKey);
        } else {
            Matcher clearPrivateKeyMatcher = CLEAR_PRIVATE_KEY_PATTERN.matcher(privateKeyContent);
            if (!clearPrivateKeyMatcher.find()) {
                return null;
            }
            privateKeyContent = clearPrivateKeyMatcher.group(1).replace("\n", "").trim();
            encodedKeySpec = new PKCS8EncodedKeySpec(this.decode(privateKeyContent));
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(encodedKeySpec);
    }

    private void initCertificates(List<String> certs) throws Exception {
        Certificate certificate;
        CertificateFactory certFactory = CertificateFactory.getInstance(PEM_CERTIFICATE_TYPE);
        if (this.privateKey == null) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCertificates", "No private key found. Might have only trust certificates.", null, null);
            for (int i = 0; i < certs.size(); ++i) {
                Certificate certificate2 = certFactory.generateCertificate(new ByteArrayInputStream(this.decode(certs.get(i))));
                this.trustCertificates.add(certificate2);
            }
            return;
        }
        int index = 0;
        Certificate certInChain = null;
        BigInteger privateModulus = ((RSAPrivateKey)this.privateKey).getModulus();
        while (index < certs.size()) {
            certificate = certFactory.generateCertificate(new ByteArrayInputStream(this.decode(certs.get(index++))));
            BigInteger publicModulus = ((RSAPublicKey)certificate.getPublicKey()).getModulus();
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCertificates", "Found Certificate {0}", (String)null, null, (Object)certificate);
            if (publicModulus.equals(privateModulus)) {
                certInChain = certificate;
                this.chainedCertificates.add(certificate);
                break;
            }
            this.trustCertificates.add(certificate);
        }
        while (index < certs.size()) {
            certificate = certFactory.generateCertificate(new ByteArrayInputStream(this.decode(certs.get(index++))));
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initCertificates", "Found Certificate {0}", (String)null, null, (Object)certificate);
            if (this.isCertificateInChain(certInChain, certificate) && !this.isSelfSigned(certificate)) {
                certInChain = certificate;
                this.chainedCertificates.add(certificate);
                continue;
            }
            this.trustCertificates.add(certificate);
        }
    }

    private boolean isCertificateInChain(Certificate chainCert, Certificate cert) {
        try {
            chainCert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSelfSigned(Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String content(String pemFile) throws NetException {
        try {
            return new String(Files.readAllBytes(Paths.get(pemFile, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw (NetException)new NetException(17956).initCause(e);
        }
    }

    private byte[] decode(String content) {
        return Base64.getDecoder().decode(content);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.config.diagnosable == null ? CommonDiagnosable.getInstance() : this.config.diagnosable;
    }
}

