/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XLayoutConstrains;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;
import com.sun.star.util.Time;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.Shape;

public class Control
extends Shape {
    XControlModel xControlModel;
    private XControl xControl;
    protected XPropertySet xPropertySet;
    XWindowPeer xWindowPeer;
    private static final int SOMAXTEXTSIZE = 50;
    private int icontroltype;
    private XNameContainer xFormName;
    private static final int IIMGFIELDWIDTH = 3000;

    public Control() {
    }

    public Control(FormHandler formHandler, String string, Point point) {
        super(formHandler, string, point, null);
    }

    public Control(FormHandler formHandler, XNameContainer xNameContainer, int n, String string, Point point, Size size) {
        super(formHandler, point, size);
        this.xFormName = xNameContainer;
        this.createControl(n, null, string);
    }

    public Control(FormHandler formHandler, int n, Point point, Size size) {
        super(formHandler, point, size);
        this.createControl(n, null, null);
    }

    private void createControl(int n, XShapes xShapes, String string) {
        try {
            this.icontroltype = n;
            String string2 = this.oFormHandler.sModelServices[this.icontroltype];
            Object object = this.oFormHandler.xMSFDoc.createInstance(string2);
            this.xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)object);
            this.xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            XPropertySetInfo xPropertySetInfo = this.xPropertySet.getPropertySetInfo();
            if (xPropertySetInfo.hasPropertyByName("MouseWheelBehavior")) {
                this.xPropertySet.setPropertyValue("MouseWheelBehavior", (Object)0);
            }
            this.insertControlInContainer(string);
            this.xControlShape.setControl(this.xControlModel);
            if (xShapes == null) {
                this.oFormHandler.xDrawPage.add(this.xShape);
            } else {
                xShapes.add(this.xShape);
            }
            this.xControl = this.oFormHandler.xControlAccess.getControl(this.xControlModel);
            UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xControl);
            this.xWindowPeer = this.xControl.getPeer();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void insertControlInContainer(String string) {
        try {
            if (this.xFormName != null) {
                XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xFormName);
                String string2 = Desktop.getUniqueName(xNameAccess, this.getControlName(string));
                this.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)string2);
                this.xFormName.insertByName(string2, (Object)this.xControlModel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private String getControlName(String string) {
        String string2 = PropertyNames.EMPTY_STRING;
        switch (this.getControlType()) {
            case 0: {
                string2 = "lbl" + string;
                break;
            }
            case 1: {
                string2 = "txt" + string;
                break;
            }
            case 2: {
                string2 = "chk" + string;
                break;
            }
            case 3: {
                string2 = "dat" + string;
                break;
            }
            case 4: {
                string2 = "tim" + string;
                break;
            }
            case 5: {
                string2 = "fmt" + string;
                break;
            }
            case 6: {
                string2 = "grd" + string;
                break;
            }
            case 7: {
                string2 = "img" + string;
                break;
            }
            default: {
                string2 = "ctrl" + string;
            }
        }
        return string2;
    }

    public int getPreferredWidth(String string) {
        Size size = this.getPreferredSize(string);
        return (size.Width + 10) * this.oFormHandler.getXPixelFactor();
    }

    public int getPreferredHeight(String string) {
        Size size = this.getPreferredSize(string);
        if (this.getControlType() == 2) {
            return size.Height * this.oFormHandler.getXPixelFactor();
        }
        return (size.Height + 2) * this.oFormHandler.getXPixelFactor();
    }

    public int getPreferredWidth() {
        if (this.getControlType() == 7) {
            return 3000;
        }
        Size size = this.getPeerSize();
        int n = size == null ? 0 : size.Width;
        if (this.getControlType() == 2) {
            return n * this.oFormHandler.getXPixelFactor();
        }
        return n * this.oFormHandler.getXPixelFactor() + 200;
    }

    public int getPreferredHeight() {
        if (this.getControlType() == 7) {
            return 2000;
        }
        Size size = this.getPeerSize();
        int n = size == null ? 0 : size.Height;
        return (n + 1) * this.oFormHandler.getYPixelFactor();
    }

    private Size getPreferredSize(String string) {
        block4: {
            try {
                if (this.xPropertySet.getPropertySetInfo().hasPropertyByName("Text")) {
                    this.xPropertySet.setPropertyValue("Text", (Object)string);
                    break block4;
                }
                if (this.xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_LABEL)) {
                    this.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_LABEL, (Object)string);
                    break block4;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return this.getPeer().getPreferredSize();
    }

    public void setPropertyValue(String string, Object object) throws Exception {
        if (this.xPropertySet.getPropertySetInfo().hasPropertyByName(string)) {
            this.xPropertySet.setPropertyValue(string, object);
        }
    }

    private XLayoutConstrains getPeer() {
        return (XLayoutConstrains)UnoRuntime.queryInterface(XLayoutConstrains.class, (Object)this.xControl.getPeer());
    }

    private Size getPeerSize() {
        try {
            Size size = null;
            double d = 0.0;
            if (this.xPropertySet.getPropertySetInfo().hasPropertyByName("EffectiveMax")) {
                if (this.xPropertySet.getPropertyValue("EffectiveMax") != Any.VOID) {
                    d = AnyConverter.toDouble((Object)this.xPropertySet.getPropertyValue("EffectiveMax"));
                }
                if (d == 0.0) {
                    this.xPropertySet.setPropertyValue("EffectiveValue", (Object)99999.0);
                } else {
                    this.xPropertySet.setPropertyValue("EffectiveValue", (Object)d);
                }
                size = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("EffectiveValue", (Object)Any.VOID);
            } else if (this.getControlType() == 2) {
                size = this.getPeer().getPreferredSize();
            } else if (this.getControlType() == 3) {
                Date date = new Date();
                date.Day = (short)30;
                date.Month = (short)12;
                date.Year = (short)9999;
                this.xPropertySet.setPropertyValue("Date", (Object)date);
                size = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("Date", (Object)Any.VOID);
            } else if (this.getControlType() == 4) {
                Time time = new Time();
                time.NanoSeconds = 999999999;
                time.Seconds = (short)59;
                time.Minutes = (short)59;
                time.Hours = (short)22;
                this.xPropertySet.setPropertyValue("Time", (Object)time);
                size = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("Time", (Object)Any.VOID);
            } else {
                short s = AnyConverter.toShort((Object)this.xPropertySet.getPropertyValue("MaxTextLen"));
                String string = s < 50 ? FormHandler.SOSIZETEXT.substring(0, 50) : FormHandler.SOSIZETEXT.substring(0, s);
                this.xPropertySet.setPropertyValue("Text", (Object)string);
                size = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("Text", (Object)PropertyNames.EMPTY_STRING);
            }
            return size;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public int getControlType() {
        return this.icontroltype;
    }

    public XPropertySet getPropertySet() {
        return this.xPropertySet;
    }
}

