/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class FloatListParameter
extends AbstractParameter<Float[]> {
    public FloatListParameter() {
        this.setType(ParameterType.FLOAT_LIST);
        this.setMultiplicity(true);
    }

    public FloatListParameter(String string) {
        this(string, null);
    }

    public FloatListParameter(String string, Float[] floatArray) {
        this();
        this.setName(string);
        this.setValue(floatArray);
    }

    protected FloatListParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("RANGE_MIN: ")) {
            string = string.substring("RANGE_MIN: ".length(), string.length());
            try {
                this.setRangeMin(Float.valueOf(Float.parseFloat(string)));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notFloat!", "RANGE_MIN"), numberFormatException);
            }
        }
        if (string.startsWith("RANGE_MAX: ")) {
            string = string.substring("RANGE_MAX: ".length(), string.length());
            try {
                this.setRangeMax(Float.valueOf(Float.parseFloat(string)));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notFloat!", "RANGE_MAX"), numberFormatException);
            }
        }
        if (string.startsWith("DEFAULT: ")) {
            string = string.substring("DEFAULT: ".length(), string.length());
            try {
                this.setDefault(Parser.parseFloatList(string));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notFloat!", "DEFAULT"), numberFormatException);
            }
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length(), string.length());
            String[] stringArray = Parser.parseStringList(string);
            Float[][] floatArrayArray = new Float[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                floatArrayArray[i] = Parser.parseFloatList(stringArray[i]);
            }
            this.setPossibilities((T[])floatArrayArray);
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) throws LscpException {
        this.setValue(Parser.parseFloatList(string));
    }

    @Override
    public String getStringValue() {
        Float[] floatArray = (Float[])this.getValue();
        if (floatArray == null || floatArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(floatArray[0]);
        for (int i = 1; i < floatArray.length; ++i) {
            stringBuffer.append(',').append(floatArray[i]);
        }
        return stringBuffer.toString();
    }
}

