/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import org.a11y.brlapi.BitMask;
import org.a11y.brlapi.ParameterComponent;

public class RowCells
extends ParameterComponent {
    private static final int BYTE_SIZE = 8;
    private final byte[] cellArray;
    private final BitMask cellMask;

    private final int copyBytes(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        System.arraycopy(byArray2, n, byArray, 0, n2);
        return n + n2;
    }

    public RowCells(byte[] byArray) {
        if (byArray.length == 0) {
            this.cellArray = null;
            this.cellMask = new BitMask(new byte[0]);
        } else {
            this.cellArray = new byte[256];
            int n = this.copyBytes(this.cellArray, byArray, 0);
            byte[] byArray2 = new byte[this.cellArray.length / 8];
            n = this.copyBytes(byArray2, byArray, n);
            this.cellMask = new BitMask(byArray2);
        }
    }

    public int getSize() {
        return this.cellArray.length;
    }

    public boolean isDefined(int n) {
        return this.cellMask.isSet(n);
    }

    public byte getCell(int n) {
        return this.isDefined(n) ? this.cellArray[n] : (byte)0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl = true;
        for (int n : this.cellMask.getBitNumbers()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(String.format("%02X:%s", n, RowCells.asDots(this.cellArray[n])));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

