﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AwsBackupBackupPlanBackupPlanDetails.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Provides details about an Backup backup plan and an array of
 * <code>BackupRule</code> objects, each of which specifies a backup rule.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsBackupBackupPlanDetails">AWS
 * API Reference</a></p>
 */
class AwsBackupBackupPlanDetails {
 public:
  AWS_SECURITYHUB_API AwsBackupBackupPlanDetails() = default;
  AWS_SECURITYHUB_API AwsBackupBackupPlanDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsBackupBackupPlanDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Uniquely identifies the backup plan to be associated with the selection of
   * resources. </p>
   */
  inline const AwsBackupBackupPlanBackupPlanDetails& GetBackupPlan() const { return m_backupPlan; }
  inline bool BackupPlanHasBeenSet() const { return m_backupPlanHasBeenSet; }
  template <typename BackupPlanT = AwsBackupBackupPlanBackupPlanDetails>
  void SetBackupPlan(BackupPlanT&& value) {
    m_backupPlanHasBeenSet = true;
    m_backupPlan = std::forward<BackupPlanT>(value);
  }
  template <typename BackupPlanT = AwsBackupBackupPlanBackupPlanDetails>
  AwsBackupBackupPlanDetails& WithBackupPlan(BackupPlanT&& value) {
    SetBackupPlan(std::forward<BackupPlanT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An Amazon Resource Name (ARN) that uniquely identifies the backup plan. </p>
   */
  inline const Aws::String& GetBackupPlanArn() const { return m_backupPlanArn; }
  inline bool BackupPlanArnHasBeenSet() const { return m_backupPlanArnHasBeenSet; }
  template <typename BackupPlanArnT = Aws::String>
  void SetBackupPlanArn(BackupPlanArnT&& value) {
    m_backupPlanArnHasBeenSet = true;
    m_backupPlanArn = std::forward<BackupPlanArnT>(value);
  }
  template <typename BackupPlanArnT = Aws::String>
  AwsBackupBackupPlanDetails& WithBackupPlanArn(BackupPlanArnT&& value) {
    SetBackupPlanArn(std::forward<BackupPlanArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique ID for the backup plan. </p>
   */
  inline const Aws::String& GetBackupPlanId() const { return m_backupPlanId; }
  inline bool BackupPlanIdHasBeenSet() const { return m_backupPlanIdHasBeenSet; }
  template <typename BackupPlanIdT = Aws::String>
  void SetBackupPlanId(BackupPlanIdT&& value) {
    m_backupPlanIdHasBeenSet = true;
    m_backupPlanId = std::forward<BackupPlanIdT>(value);
  }
  template <typename BackupPlanIdT = Aws::String>
  AwsBackupBackupPlanDetails& WithBackupPlanId(BackupPlanIdT&& value) {
    SetBackupPlanId(std::forward<BackupPlanIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs
   * cannot be edited. </p>
   */
  inline const Aws::String& GetVersionId() const { return m_versionId; }
  inline bool VersionIdHasBeenSet() const { return m_versionIdHasBeenSet; }
  template <typename VersionIdT = Aws::String>
  void SetVersionId(VersionIdT&& value) {
    m_versionIdHasBeenSet = true;
    m_versionId = std::forward<VersionIdT>(value);
  }
  template <typename VersionIdT = Aws::String>
  AwsBackupBackupPlanDetails& WithVersionId(VersionIdT&& value) {
    SetVersionId(std::forward<VersionIdT>(value));
    return *this;
  }
  ///@}
 private:
  AwsBackupBackupPlanBackupPlanDetails m_backupPlan;

  Aws::String m_backupPlanArn;

  Aws::String m_backupPlanId;

  Aws::String m_versionId;
  bool m_backupPlanHasBeenSet = false;
  bool m_backupPlanArnHasBeenSet = false;
  bool m_backupPlanIdHasBeenSet = false;
  bool m_versionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
