/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class vmSymbols {
    private static Address symbolsAddress;
    private static int FIRST_SID;
    private static int SID_LIMIT;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("vmSymbols");
        symbolsAddress = type.getAddressField("_symbols[0]").getStaticFieldAddress();
        FIRST_SID = db.lookupIntConstant("vmSymbols::FIRST_SID");
        SID_LIMIT = db.lookupIntConstant("vmSymbols::SID_LIMIT");
    }

    public static Symbol symbolAt(int id) {
        if (id < FIRST_SID || id >= SID_LIMIT) {
            throw new IndexOutOfBoundsException("bad SID " + id);
        }
        return Symbol.create(symbolsAddress.getAddressAt((long)id * VM.getVM().getAddressSize()));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                vmSymbols.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

