/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 0ul) => i64vec3(-1333333333333333259l, 85l, 94l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 1ul) => i64vec3(-2666666666666666518l, 170l, 188l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 2ul) => i64vec3(-5333333333333333036l, 340l, 376l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 5ul) => i64vec3(-5773178519247561056l, 2720l, 3008l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 25ul) => i64vec3(-3776561488156688384l, 2852126720l, 3154116608l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 31ul) => i64vec3(-1892262283803885568l, 182536110080l, 201863462912l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 32ul) => i64vec3(-3784524567607771136l, 365072220160l, 403726925824l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 47ul) => i64vec3(6159376177870929920l, 11962686510202880l, 13229323905400832l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 63ul) => i64vec3(-9223372036854775808l, -9223372036854775808l, 0l)
 * (i64vec3(167l, 66l, 187l) << 0ul) => i64vec3(167l, 66l, 187l)
 * (i64vec3(167l, 66l, 187l) << 1ul) => i64vec3(334l, 132l, 374l)
 * (i64vec3(167l, 66l, 187l) << 2ul) => i64vec3(668l, 264l, 748l)
 * (i64vec3(167l, 66l, 187l) << 5ul) => i64vec3(5344l, 2112l, 5984l)
 * (i64vec3(167l, 66l, 187l) << 25ul) => i64vec3(5603590144l, 2214592512l, 6274678784l)
 * (i64vec3(167l, 66l, 187l) << 31ul) => i64vec3(358629769216l, 141733920768l, 401579442176l)
 * (i64vec3(167l, 66l, 187l) << 32ul) => i64vec3(717259538432l, 283467841536l, 803158884352l)
 * (i64vec3(167l, 66l, 187l) << 47ul) => i64vec3(23503160555339776l, 9288674231451648l, 26317910322446336l)
 * (i64vec3(167l, 66l, 187l) << 63ul) => i64vec3(-9223372036854775808l, 0l, -9223372036854775808l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 0ul), i64vec3(-1333333333333333259l, 85l, 94l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 1ul), i64vec3(-2666666666666666518l, 170l, 188l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 2ul), i64vec3(-5333333333333333036l, 340l, 376l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 5ul), i64vec3(-5773178519247561056l, 2720l, 3008l))) ? 1 : -1] array3;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 25ul), i64vec3(-3776561488156688384l, 2852126720l, 3154116608l))) ? 1 : -1] array4;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 31ul), i64vec3(-1892262283803885568l, 182536110080l, 201863462912l))) ? 1 : -1] array5;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 32ul), i64vec3(-3784524567607771136l, 365072220160l, 403726925824l))) ? 1 : -1] array6;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 47ul), i64vec3(6159376177870929920l, 11962686510202880l, 13229323905400832l))) ? 1 : -1] array7;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 63ul), i64vec3(-9223372036854775808l, -9223372036854775808l, 0l))) ? 1 : -1] array8;
  float[all(equal((i64vec3(167l, 66l, 187l) << 0ul), i64vec3(167l, 66l, 187l))) ? 1 : -1] array9;
  float[all(equal((i64vec3(167l, 66l, 187l) << 1ul), i64vec3(334l, 132l, 374l))) ? 1 : -1] array10;
  float[all(equal((i64vec3(167l, 66l, 187l) << 2ul), i64vec3(668l, 264l, 748l))) ? 1 : -1] array11;
  float[all(equal((i64vec3(167l, 66l, 187l) << 5ul), i64vec3(5344l, 2112l, 5984l))) ? 1 : -1] array12;
  float[all(equal((i64vec3(167l, 66l, 187l) << 25ul), i64vec3(5603590144l, 2214592512l, 6274678784l))) ? 1 : -1] array13;
  float[all(equal((i64vec3(167l, 66l, 187l) << 31ul), i64vec3(358629769216l, 141733920768l, 401579442176l))) ? 1 : -1] array14;
  float[all(equal((i64vec3(167l, 66l, 187l) << 32ul), i64vec3(717259538432l, 283467841536l, 803158884352l))) ? 1 : -1] array15;
  float[all(equal((i64vec3(167l, 66l, 187l) << 47ul), i64vec3(23503160555339776l, 9288674231451648l, 26317910322446336l))) ? 1 : -1] array16;
  float[all(equal((i64vec3(167l, 66l, 187l) << 63ul), i64vec3(-9223372036854775808l, 0l, -9223372036854775808l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
