/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGBezierFigure
extends BezierFigure {
    private transient Rectangle2D.Double cachedDrawingArea;

    public SVGBezierFigure() {
        this(false);
    }

    public SVGBezierFigure(boolean bl) {
        super(bl);
        this.set(SVGAttributeKeys.UNCLOSED_PATH_FILLED, true);
    }

    public Collection<Handle> createHandles(SVGPathFigure sVGPathFigure, int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case 0: {
                int n2 = this.path.size();
                for (int i = 0; i < n2; ++i) {
                    linkedList.add(new BezierNodeHandle(this, i, sVGPathFigure));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
                break;
            }
        }
        return linkedList;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        if (mouseEvent.getClickCount() == 2) {
            int n;
            this.willChange();
            if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
                try {
                    double_ = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, new Point2D.Double());
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    System.err.println("Warning: SVGBezierFigure.handleMouseClick. Figure has noninvertible Transform.");
                }
            }
            if ((n = this.splitSegment(double_, (float)(5.0 / drawingView.getScaleFactor()))) != -1) {
                final BezierPath.Node node = this.getNode(n);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                        return resourceBundleUtil.getString("edit.bezierPath.splitSegment.text");
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        SVGBezierFigure.this.willChange();
                        SVGBezierFigure.this.addNode(n, node);
                        SVGBezierFigure.this.changed();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        SVGBezierFigure.this.willChange();
                        SVGBezierFigure.this.removeNode(n);
                        SVGBezierFigure.this.changed();
                    }
                });
                this.changed();
                mouseEvent.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (affineTransform.getType() & 1) != affineTransform.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                SVGAttributeKeys.TRANSFORM.setClone(this, affineTransform);
            } else {
                AffineTransform affineTransform2 = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                affineTransform2.preConcatenate(affineTransform);
                this.set(SVGAttributeKeys.TRANSFORM, affineTransform2);
            }
        } else {
            super.transform(affineTransform);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.cachedDrawingArea = this.path.getBounds2D();
            } else {
                BezierPath bezierPath = this.path.clone();
                bezierPath.transform((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM));
                this.cachedDrawingArea = bezierPath.getBounds2D();
            }
            double d = AttributeKeys.getStrokeTotalWidth(this);
            double d2 = d / 2.0;
            if ((Integer)this.get(SVGAttributeKeys.STROKE_JOIN) == 0) {
                d2 *= ((Double)this.get(SVGAttributeKeys.STROKE_MITER_LIMIT)).doubleValue();
            } else if ((Integer)this.get(SVGAttributeKeys.STROKE_CAP) != 0) {
                d2 += d * 2.0;
            }
            Geom.grow(this.cachedDrawingArea, d2, d2);
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public int findSegment(Point2D.Double double_, double d) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                double_ = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, new Point2D.Double());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("Warning: SVGBezierFigure.findSegment. Figure has noninvertible Transform.");
            }
        }
        return this.getBezierPath().findSegment(double_, d);
    }

    @Override
    public boolean joinSegments(Point2D.Double double_, double d) {
        int n;
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                double_ = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, new Point2D.Double());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("Warning: SVGBezierFigure.findSegment. Figure has noninvertible Transform.");
            }
        }
        if ((n = this.getBezierPath().findSegment(double_, d)) != -1 && n > 1) {
            this.removeNode(n);
            return true;
        }
        return false;
    }

    @Override
    public int splitSegment(Point2D.Double double_, double d) {
        int n;
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                double_ = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, new Point2D.Double());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("Warning: SVGBezierFigure.findSegment. Figure has noninvertible Transform.");
            }
        }
        if ((n = this.getBezierPath().findSegment(double_, d)) != -1) {
            this.addNode(n + 1, new BezierPath.Node(double_));
        }
        return n + 1;
    }

    public void flattenTransform() {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            this.path.transform((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM));
            this.set(SVGAttributeKeys.TRANSFORM, null);
        }
        this.invalidate();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedDrawingArea = null;
    }
}

