/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openssl.PEMDecryptor;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.impl.pem.MiscPEMGeneratorHelper;
import org.jruby.ext.openssl.util.ByteArrayOutputStream;
import org.jruby.ext.openssl.x509store.PEMInputOutput;

public abstract class PEMUtils {
    public static KeyPair readKeyPair(Reader reader) throws IOException {
        return PEMUtils.readKeyPair(reader, null);
    }

    public static KeyPair readKeyPair(Reader reader, char[] password) throws IOException {
        PEMKeyPair pemKeyPair = PEMUtils.readInternal(reader, password);
        return PEMUtils.toKeyPair(pemKeyPair);
    }

    static PEMKeyPair readInternal(Reader reader, char[] password) throws IOException {
        Object keyPair = new PEMParser(reader).readObject();
        if (keyPair instanceof PEMEncryptedKeyPair) {
            return ((PEMEncryptedKeyPair)keyPair).decryptKeyPair((PEMDecryptorProvider)new PEMDecryptorImpl(password));
        }
        return (PEMKeyPair)keyPair;
    }

    private static KeyPair toKeyPair(PEMKeyPair pemKeyPair) throws IOException {
        try {
            KeyFactory keyFactory = PEMInputOutput.getKeyFactory(pemKeyPair.getPrivateKeyInfo().getPrivateKeyAlgorithm());
            return new KeyPair(keyFactory.generatePublic(new X509EncodedKeySpec(pemKeyPair.getPublicKeyInfo().getEncoded())), keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pemKeyPair.getPrivateKeyInfo().getEncoded())));
        }
        catch (Exception e) {
            throw new PEMException("unable to convert key pair: " + e.getMessage(), e);
        }
    }

    public static void writePEM(Writer writer, Object obj, String algorithm, char[] password) throws IOException {
        PEMWriter pemWriter = new PEMWriter(writer);
        SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
        pemWriter.writeObject((PemObjectGenerator)MiscPEMGeneratorHelper.newGenerator(obj, algorithm, password, random));
        pemWriter.flush();
    }

    public static void writePEM(Writer writer, Object obj) throws IOException {
        PEMUtils.writePEM(writer, obj, null, null);
    }

    public static byte[] generatePKCS12(Reader keyReader, byte[] cert2, String aliasName, char[] password) throws IOException, GeneralSecurityException {
        Collection<? extends Certificate> certChain = SecurityHelper.getCertificateFactory("X.509").generateCertificates(new ByteArrayInputStream(cert2));
        PEMKeyPair pemKeyPair = PEMUtils.readInternal(keyReader, null);
        KeyFactory keyFactory = PEMInputOutput.getKeyFactory(pemKeyPair.getPrivateKeyInfo().getPrivateKeyAlgorithm());
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pemKeyPair.getPrivateKeyInfo().getEncoded()));
        KeyStore keyStore = SecurityHelper.getKeyStore("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry(aliasName, privateKey, null, certChain.toArray(new Certificate[certChain.size()]));
        ByteArrayOutputStream pkcs12Out = new ByteArrayOutputStream();
        keyStore.store(pkcs12Out, password == null ? new char[]{} : password);
        return pkcs12Out.toByteArray();
    }

    private static class PEMDecryptorImpl
    implements PEMDecryptorProvider,
    PEMDecryptor {
        private char[] password;
        private String dekAlgName;

        PEMDecryptorImpl(char[] password) {
            this.password = password;
        }

        public PEMDecryptor get(String dekAlgName) throws OperatorCreationException {
            this.dekAlgName = dekAlgName;
            return this;
        }

        public byte[] decrypt(byte[] keyBytes, byte[] iv) throws PEMException {
            return PEMDecryptorImpl.decrypt(keyBytes, this.password, this.dekAlgName, iv);
        }

        static byte[] decrypt(byte[] bytes, char[] password, String dekAlgName, byte[] iv) throws PEMException {
            return PEMDecryptorImpl.decrypt(SecurityHelper.getSecurityProvider(), bytes, password, dekAlgName, iv);
        }

        static byte[] decrypt(Provider provider, byte[] bytes, char[] password, String dekAlgName, byte[] iv) throws PEMException {
            SecretKey sKey;
            String alg;
            AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
            String blockMode = "CBC";
            String padding = "PKCS5Padding";
            if (dekAlgName.endsWith("-CFB")) {
                blockMode = "CFB";
                padding = "NoPadding";
            }
            if (dekAlgName.endsWith("-ECB") || "DES-EDE".equals(dekAlgName) || "DES-EDE3".equals(dekAlgName)) {
                blockMode = "ECB";
                paramSpec = null;
            }
            if (dekAlgName.endsWith("-OFB")) {
                blockMode = "OFB";
                padding = "NoPadding";
            }
            if (dekAlgName.startsWith("DES-EDE")) {
                alg = "DESede";
                boolean des2 = !dekAlgName.startsWith("DES-EDE3");
                sKey = PEMDecryptorImpl.secretKeySpec(password, alg, 24, iv, des2);
            } else if (dekAlgName.startsWith("DES-")) {
                alg = "DES";
                sKey = PEMDecryptorImpl.secretKeySpec(password, alg, 8, iv);
            } else if (dekAlgName.startsWith("BF-")) {
                alg = "Blowfish";
                sKey = PEMDecryptorImpl.secretKeySpec(password, alg, 16, iv);
            } else if (dekAlgName.startsWith("RC2-")) {
                alg = "RC2";
                int keyBits = 128;
                if (dekAlgName.startsWith("RC2-40-")) {
                    keyBits = 40;
                } else if (dekAlgName.startsWith("RC2-64-")) {
                    keyBits = 64;
                }
                sKey = PEMDecryptorImpl.secretKeySpec(password, alg, keyBits / 8, iv);
                paramSpec = paramSpec == null ? new RC2ParameterSpec(keyBits) : new RC2ParameterSpec(keyBits, iv);
            } else if (dekAlgName.startsWith("AES-")) {
                int keyBits;
                alg = "AES";
                byte[] salt = iv;
                if (salt.length > 8) {
                    salt = new byte[8];
                    System.arraycopy(iv, 0, salt, 0, 8);
                }
                if (dekAlgName.startsWith("AES-128-")) {
                    keyBits = 128;
                } else if (dekAlgName.startsWith("AES-192-")) {
                    keyBits = 192;
                } else if (dekAlgName.startsWith("AES-256-")) {
                    keyBits = 256;
                } else {
                    throw new PEMException("unknown AES encryption with private key");
                }
                sKey = PEMDecryptorImpl.secretKeySpec(password, "AES", keyBits / 8, salt);
            } else {
                throw new PEMException("unknown encryption with private key");
            }
            String transformation = alg + "/" + blockMode + "/" + padding;
            try {
                Cipher cipher2 = SecurityHelper.getCipher(transformation);
                int decryptMode = 2;
                if (paramSpec == null) {
                    cipher2.init(2, sKey);
                } else {
                    cipher2.init(2, (Key)sKey, paramSpec);
                }
                return cipher2.doFinal(bytes);
            }
            catch (Exception e) {
                throw new PEMException("exception using cipher - please check password and data.", e);
            }
        }

        private static SecretKey secretKeySpec(char[] password, String algorithm, int keyLength, byte[] salt) {
            return PEMDecryptorImpl.secretKeySpec(password, algorithm, keyLength, salt, false);
        }

        private static SecretKey secretKeySpec(char[] password, String algorithm, int keyLength, byte[] salt, boolean des2) {
            OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
            pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password), salt);
            KeyParameter keyParam = (KeyParameter)pGen.generateDerivedParameters(keyLength * 8);
            byte[] key = keyParam.getKey();
            if (des2 && key.length >= 24) {
                System.arraycopy(key, 0, key, 16, 8);
            }
            return new SecretKeySpec(key, algorithm);
        }
    }
}

