/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import org.jruby.MetaClass;
import org.jruby.RubyBasicObject;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.Compilable;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.MethodJITClassGenerator;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.collections.IntHashMap;

class MethodJITTask
extends JITCompiler.Task {
    private final String className;
    private final MixedModeIRMethod method;
    private final String methodName;

    public MethodJITTask(JITCompiler jitCompiler, MixedModeIRMethod method2, String className) {
        super(jitCompiler);
        this.method = method2;
        this.className = className;
        this.methodName = method2.getName();
    }

    @Override
    public void exec(ThreadContext context) throws NoSuchMethodException, IllegalAccessException {
        block4: {
            IntHashMap<MethodType> signatures;
            MethodHandle variable;
            Class<?> sourceClass;
            JVMVisitorMethodContext methodContext;
            block3: {
                String excludeModuleName = MethodJITTask.checkExcludedMethod(this.jitCompiler.config, this.className, this.methodName, this.method);
                if (excludeModuleName != null) {
                    this.method.setCallCount(-1);
                    if (this.jitCompiler.config.isJitLogging()) {
                        this.logImpl(context, "skipping method in " + excludeModuleName, new Object[0]);
                    }
                    return;
                }
                String key2 = SexpMaker.sha1(this.method.getIRScope());
                JVMVisitor visitor = JVMVisitor.newForJIT(context.runtime);
                MethodJITClassGenerator generator = new MethodJITClassGenerator(this.className, this.methodName, key2, context.runtime, this.method, visitor);
                methodContext = new JVMVisitorMethodContext();
                generator.compile(methodContext);
                sourceClass = this.defineClass(generator, visitor, this.method.getIRScope(), this.method.ensureInstrsReady());
                if (sourceClass == null) {
                    return;
                }
                String variableName = methodContext.getVariableName();
                variable = JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, variableName, methodContext.getNativeSignature(-1));
                signatures = methodContext.getNativeSignaturesExceptVariable();
                if (signatures.size() != 0) break block3;
                this.method.completeBuild(context, new CompiledIRMethod(variable, null, -1, this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), ArgumentDescriptor.encode(this.method.getArgumentDescriptors())));
                break block4;
            }
            Iterator<IntHashMap.Entry<MethodType>> iterator = signatures.entrySet().iterator();
            if (!iterator.hasNext()) break block4;
            IntHashMap.Entry<MethodType> entry = iterator.next();
            this.method.completeBuild(context, new CompiledIRMethod(variable, JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, methodContext.getSpecificName(), entry.getValue()), entry.getKey(), this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), ArgumentDescriptor.encode(this.method.getArgumentDescriptors())));
        }
    }

    @Override
    protected String getSourceFile() {
        return this.method.getFile();
    }

    @Override
    protected void logJitted(ThreadContext context) {
        this.logImpl(context, "method done jitting", new Object[0]);
    }

    @Override
    protected void logFailed(ThreadContext context, Throwable ex) {
        this.logImpl(context, "could not compile method; passes run: " + String.valueOf(this.method.getIRScope().getExecutedPasses()), ex);
    }

    @Override
    protected void logImpl(ThreadContext context, String message2, Object ... reason2) {
        JITCompiler.log(context, this.method, this.methodName, message2, reason2);
    }

    static String checkExcludedMethod(RubyInstanceConfig config, String className, String methodName, Compilable target2) {
        if (config.getExcludedMethods().size() > 0) {
            RubyBasicObject possibleRealClass;
            RubyModule implementationClass = target2.getImplementationClass();
            Object excludeModuleName = className;
            if (implementationClass.getMethodLocation().isSingleton() && (possibleRealClass = ((MetaClass)implementationClass).getAttached()) instanceof RubyModule) {
                RubyModule mod = (RubyModule)possibleRealClass;
                excludeModuleName = "Meta:" + mod.getName(mod.getRuntime().getCurrentContext());
            }
            if (config.getExcludedMethods().contains(excludeModuleName) || config.getExcludedMethods().contains(methodName) || config.getExcludedMethods().contains((String)excludeModuleName + "#" + methodName) || config.getExcludedMethods().contains(target2.getFile()) || config.getExcludedMethods().contains(target2.getFile() + ":" + target2.getLine())) {
                return excludeModuleName;
            }
        }
        return null;
    }
}

