/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileSystemProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JarFileSystemProvider
extends ZipFileSystemProvider {
    @Override
    public String getScheme() {
        return "jar";
    }

    @Override
    protected Path uriToPath(URI uRI) {
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            String string2 = uRI.toString();
            int n = string2.indexOf("!/");
            string2 = string2.substring(4, n == -1 ? string2.length() : n);
            uRI = new URI(string2);
            return Paths.get(new URI("file", uRI.getHost(), uRI.getPath(), null)).toAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    @Override
    public Path getPath(URI uRI) {
        String string;
        int n;
        FileSystem fileSystem = this.getFileSystem(uRI);
        String string2 = uRI.getFragment();
        if (string2 == null && (n = (string = uRI.toString()).indexOf("!/")) != -1) {
            string2 = string.substring(n + 2);
        }
        if (string2 != null) {
            return fileSystem.getPath(string2, new String[0]);
        }
        throw new IllegalArgumentException("URI: " + uRI + " does not contain path fragment ex. jar:///c:/foo.zip!/BAR");
    }
}

