/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Depth;
import sun.awt.X11.Native;
import sun.awt.X11.Visual;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Screen
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 80 : 128;
    }

    @Override
    public int getDataSize() {
        return Screen.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public Screen(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public Screen() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Screen.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(n * (XlibWrapper.dataModel == 32 ? 16 : 32))) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_display(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8)) + (long)(n * Native.getLongSize());
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_display(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_root(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), l);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24));
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24), n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 28));
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 28), n);
    }

    public int get_mwidth() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 32));
    }

    public void set_mwidth(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 32), n);
    }

    public int get_mheight() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 36));
    }

    public void set_mheight(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 36), n);
    }

    public int get_ndepths() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 40));
    }

    public void set_ndepths(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 40), n);
    }

    public Depth get_depths(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48)) != 0L ? new Depth(Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48)) + (long)(n * (XlibWrapper.dataModel == 32 ? 12 : 16))) : null;
    }

    public long get_depths() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48));
    }

    public void set_depths(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 48), l);
    }

    public int get_root_depth() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 56));
    }

    public void set_root_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 56), n);
    }

    public Visual get_root_visual(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64)) != 0L ? new Visual(Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64)) + (long)(n * (XlibWrapper.dataModel == 32 ? 32 : 56))) : null;
    }

    public long get_root_visual() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64));
    }

    public void set_root_visual(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 64), l);
    }

    public long get_default_gc() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 72));
    }

    public void set_default_gc(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 72), l);
    }

    public long get_cmap() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 80));
    }

    public void set_cmap(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 80), l);
    }

    public long get_white_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 88));
    }

    public void set_white_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 88), l);
    }

    public long get_black_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 96));
    }

    public void set_black_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 96), l);
    }

    public int get_max_maps() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 104));
    }

    public void set_max_maps(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 104), n);
    }

    public int get_min_maps() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 108));
    }

    public void set_min_maps(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 108), n);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 112));
    }

    public void set_backing_store(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 112), n);
    }

    public boolean get_save_unders() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 116));
    }

    public void set_save_unders(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 116), bl);
    }

    public long get_root_input_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 120));
    }

    public void set_root_input_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 120), l);
    }

    @Override
    String getName() {
        return "Screen";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(800);
        stringBuilder.append("ext_data = ").append(this.get_ext_data()).append(", ");
        stringBuilder.append("display = ").append(this.get_display()).append(", ");
        stringBuilder.append("root = ").append(this.get_root()).append(", ");
        stringBuilder.append("width = ").append(this.get_width()).append(", ");
        stringBuilder.append("height = ").append(this.get_height()).append(", ");
        stringBuilder.append("mwidth = ").append(this.get_mwidth()).append(", ");
        stringBuilder.append("mheight = ").append(this.get_mheight()).append(", ");
        stringBuilder.append("ndepths = ").append(this.get_ndepths()).append(", ");
        stringBuilder.append("depths = ").append(this.get_depths()).append(", ");
        stringBuilder.append("root_depth = ").append(this.get_root_depth()).append(", ");
        stringBuilder.append("root_visual = ").append(this.get_root_visual()).append(", ");
        stringBuilder.append("default_gc = ").append(this.get_default_gc()).append(", ");
        stringBuilder.append("cmap = ").append(this.get_cmap()).append(", ");
        stringBuilder.append("white_pixel = ").append(this.get_white_pixel()).append(", ");
        stringBuilder.append("black_pixel = ").append(this.get_black_pixel()).append(", ");
        stringBuilder.append("max_maps = ").append(this.get_max_maps()).append(", ");
        stringBuilder.append("min_maps = ").append(this.get_min_maps()).append(", ");
        stringBuilder.append("backing_store = ").append(this.get_backing_store()).append(", ");
        stringBuilder.append("save_unders = ").append(this.get_save_unders()).append(", ");
        stringBuilder.append("root_input_mask = ").append(this.get_root_input_mask()).append(", ");
        return stringBuilder.toString();
    }
}

