/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;

abstract class CramMD5Base {
    protected boolean completed = false;
    protected boolean aborted = false;
    protected byte[] pw;
    private static final int MD5_BLOCKSIZE = 64;
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    protected static Logger logger;

    protected CramMD5Base() {
        CramMD5Base.initLogger();
    }

    public String getMechanismName() {
        return "CRAM-MD5";
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 supports neither integrity nor privacy");
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 supports neither integrity nor privacy");
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public Object getNegotiatedProperty(String string) {
        if (this.completed) {
            if (string.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public void dispose() throws SaslException {
        this.clearPassword();
    }

    protected void clearPassword() {
        if (this.pw != null) {
            for (int i = 0; i < this.pw.length; ++i) {
                this.pw[i] = 0;
            }
            this.pw = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }

    static final String HMAC_MD5(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        if (byArray.length > 64) {
            byArray = messageDigest.digest(byArray);
        }
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[64];
        for (n = 0; n < byArray.length; ++n) {
            byArray3[n] = byArray[n];
            byArray4[n] = byArray[n];
        }
        n = 0;
        while (n < 64) {
            int n2 = n;
            byArray3[n2] = (byte)(byArray3[n2] ^ 0x36);
            int n3 = n++;
            byArray4[n3] = (byte)(byArray4[n3] ^ 0x5C);
        }
        messageDigest.update(byArray3);
        messageDigest.update(byArray2);
        byte[] byArray5 = messageDigest.digest();
        messageDigest.update(byArray4);
        messageDigest.update(byArray5);
        byArray5 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < byArray5.length; ++n) {
            if ((byArray5[n] & 0xFF) < 16) {
                stringBuffer.append("0" + Integer.toHexString(byArray5[n] & 0xFF));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray5[n] & 0xFF));
        }
        Arrays.fill(byArray3, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        byArray3 = null;
        byArray4 = null;
        return stringBuffer.toString();
    }

    private static synchronized void initLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SASL_LOGGER_NAME);
        }
    }
}

