/* **********************************************************
 * Copyright (C) 1998-2001 VMware, Inc.
 * All Rights Reserved
 * $Id: cpuid.c,v 1.3 2003/09/13 11:01:54 jdolecek Exp $
 * **********************************************************/
#ifdef VMX86_DEVEL
char rcsId_bt[] = "$Id: cpuid.c,v 1.3 2003/09/13 11:01:54 jdolecek Exp $";
#else
#define FILECODE "F(316)"
#endif 

#include "include/x86.h"
#include "include/vm_types.h"
#include "include/vm_assert.h"
#include "hostif.h"
#include "cpuid.h"
#ifdef linux
#include <linux/string.h>
#endif

static CPUOem oem;
static uint32 features;
static uint32 cpuversion;

void
CPUID_Init(void)
{
   uint32 regs[4];
   uint32 *ptr;
   char name[16];

   HostIF_GetCPUID(1, regs);
   cpuversion = regs[0];
   features = regs[3];

   HostIF_GetCPUID(0, regs);
   ptr = (uint32 *)name;
   ptr[0] = regs[1];
   ptr[1] = regs[3];
   ptr[2] = regs[2];
   ptr[3] = 0;

   if (strcmp(name, "GenuineIntel") == 0) {
      oem = CPUID_OEM_INTEL;
   } else if (strcmp(name, "AuthenticAMD") == 0) {
      oem = CPUID_OEM_AMD;
   } else if (strcmp(name, "CyrixInstead") == 0) {
      oem = CPUID_OEM_CYRIX;
   } else {
      Warning("VMMON CPUID: Unrecognized CPU\n");
      oem = CPUID_OEM_OTHER;
   }
}

CPUOem
CPUID_GetOEM(void)
{
   return oem;
}

uint32
CPUID_GetFeatures(void)
{
   return features;
}

uint32
CPUID_GetVersion(void)
{
   return cpuversion;
}

