/* **********************************************************
 * Copyright (C) 1999-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: memmgmt.h,v 1.3 2003/02/16 15:32:34 bad Exp $
 * **********************************************************/

/*
 * Memory management data structures passed between the user app
 * and the driver.
 */

#ifndef _MEMMGMT_H_
#define _MEMMGMT_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include "vm_types.h"


/*
 * Data structures for the GET_MEM_INFO and SET_MEM_INFO ioctls.
 *
 * For SET_MEM_INFO, if any value is < 0, then the value is not set.
 */

typedef struct VMMemMgmtInfo {
   int32   pageFaultRate;
   int32   lockFailRate;
   int32   maxLocked;
   int32   currentLocked;
   int32   highWaterMark;
   int32   waitingForMemoryTime;
   int32   poweringOn;
   int32   hasFocus;
} VMMemMgmtInfo;

typedef struct VMSetMemInfoArgs {
   VMMemMgmtInfo info;
} VMSetMemInfoArgs;

typedef struct VMGetMemInfoArgs {
   uint32         numVMs;
   uint32         numLockedPages;
   uint32         maxLockedPages;
   uint32         callerIndex;
   VMMemMgmtInfo  memMgmtInfo[1];
} VMGetMemInfoArgs;

#define VM_GET_MEM_INFO_SIZE(numVMs) \
   ((numVMs - 1) * sizeof (VMMemMgmtInfo) + sizeof (VMGetMemInfoArgs))


#endif // ifndef _MEMMGMT_H_
