/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: initblock.h,v 1.3 2003/02/16 15:32:33 bad Exp $
 * **********************************************************/



#ifndef _INITBLOCK_H
#define _INITBLOCK_H

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_MONITOR
#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"


#include "vm_types.h"


#define MAX_LOGFILE_NAME_LENGTH 256
#define MAX_MONITOR_REGIONS     8
#define INIT_BLOCK_MAGIC     (0x1789+1)

typedef struct InitBlock {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC) */
   uint32 flags;           /* option flags  (see below) */
   int logFD;
#ifdef _WIN32
   char logFileName[MAX_LOGFILE_NAME_LENGTH];
#endif
   void *sharedArea;
   void *crosspage;

   /*
    * output 
    */
   VmTimeStart st;

} InitBlock;


/*
 * Option flags 
 */
/* None yet */

#endif
