#ifndef __COMPAT_PGTABLE_H__
#   define __COMPAT_PGTABLE_H__


/* Appeared in 2.4.0 --hpreg */
#ifndef virt_to_page
#   define virt_to_page(_kvAddr) (mem_map + MAP_NR(_kvAddr))
#endif


/* pte_page() API modified in 2.3.23 to return a struct page * --hpreg */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 23)
#   define compat_pte_page pte_page
#else
#   define compat_pte_page(_pte) virt_to_page(pte_page(_pte))
#endif


/* Appeared in 2.5.5 --hpreg */
#ifndef pte_offset_map
/*  Appeared in SuSE 8.0's 2.4.18 --hpreg */
#   ifdef pte_offset_atomic
#      define pte_offset_map pte_offset_atomic
#      define pte_unmap pte_kunmap
#   else
#      define pte_offset_map pte_offset
#      define pte_unmap(_pte)
#   endif
#endif


/* A page_table_lock field is added to struct mm_struct in 2.3.10 --hpreg */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 3, 10)
#   define compat_get_page_table_lock(_mm) (&(_mm)->page_table_lock)
#else
#   define compat_get_page_table_lock(_mm) NULL
#endif


#endif /* __COMPAT_PGTABLE_H__ */
