/*	$NetBSD: rumpvnode_if.c,v 1.2 2009/09/29 11:54:52 pooka Exp $	*/

/*
 * Warning: DO NOT EDIT! This file is automatically generated!
 * (Modifications made here may easily be lost!)
 *
 * Created from the file:
 *	NetBSD: vnode_if.src,v 1.58 2008/11/15 19:08:12 pooka Exp
 * by the script:
 *	NetBSD: vnode_if.sh,v 1.52 2009/09/29 11:51:02 pooka Exp
 */

/*
 * Copyright (c) 1992, 1993, 1994, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: rumpvnode_if.c,v 1.2 2009/09/29 11:54:52 pooka Exp $");

#include <sys/param.h>
#include <sys/mount.h>
#include <sys/buf.h>
#include <sys/vnode.h>
#include <sys/lock.h>
#include <rump/rumpvnode_if.h>

const struct vnodeop_desc rump_vop_default_desc = {
	0,
	"default",
	0,
	NULL,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};


/* Special cases: */

const int rump_vop_bwrite_vp_offsets[] = {
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_bwrite_desc = {
	RUMP_VOP_BWRITE_DESCOFFSET,
	"rump_vop_bwrite",
	0,
	rump_vop_bwrite_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_BWRITE(struct buf *bp)
{
	int error;
	bool mpsafe;
	struct rump_vop_bwrite_args a;
	a.a_desc = VDESC(rump_vop_bwrite);
	a.a_bp = bp;
	mpsafe = (bp->b_vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(bp->b_vp, VOFFSET(rump_vop_bwrite), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

/* End of special cases */

const int rump_vop_lookup_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_lookup_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_lookup_desc = {
	RUMP_VOP_LOOKUP_DESCOFFSET,
	"rump_vop_lookup",
	0,
	rump_vop_lookup_vp_offsets,
	VOPARG_OFFSETOF(struct rump_vop_lookup_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_lookup_args, a_cnp),
	NULL,
};
int
RUMP_VOP_LOOKUP(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct rump_vop_lookup_args a;
	a.a_desc = VDESC(rump_vop_lookup);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_lookup), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int rump_vop_create_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_create_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_create_desc = {
	RUMP_VOP_CREATE_DESCOFFSET,
	"rump_vop_create",
	0 | VDESC_VP0_WILLPUT,
	rump_vop_create_vp_offsets,
	VOPARG_OFFSETOF(struct rump_vop_create_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_create_args, a_cnp),
	NULL,
};
int
RUMP_VOP_CREATE(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap)
{
	int error;
	bool mpsafe;
	struct rump_vop_create_args a;
	a.a_desc = VDESC(rump_vop_create);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_create), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int rump_vop_mknod_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_mknod_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_mknod_desc = {
	RUMP_VOP_MKNOD_DESCOFFSET,
	"rump_vop_mknod",
	0 | VDESC_VP0_WILLPUT,
	rump_vop_mknod_vp_offsets,
	VOPARG_OFFSETOF(struct rump_vop_mknod_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_mknod_args, a_cnp),
	NULL,
};
int
RUMP_VOP_MKNOD(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap)
{
	int error;
	bool mpsafe;
	struct rump_vop_mknod_args a;
	a.a_desc = VDESC(rump_vop_mknod);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_mknod), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int rump_vop_open_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_open_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_open_desc = {
	RUMP_VOP_OPEN_DESCOFFSET,
	"rump_vop_open",
	0,
	rump_vop_open_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_open_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_OPEN(struct vnode *vp,
    int mode,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_open_args a;
	a.a_desc = VDESC(rump_vop_open);
	a.a_vp = vp;
	a.a_mode = mode;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_open), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_close_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_close_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_close_desc = {
	RUMP_VOP_CLOSE_DESCOFFSET,
	"rump_vop_close",
	0,
	rump_vop_close_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_close_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_CLOSE(struct vnode *vp,
    int fflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_close_args a;
	a.a_desc = VDESC(rump_vop_close);
	a.a_vp = vp;
	a.a_fflag = fflag;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_close), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_access_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_access_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_access_desc = {
	RUMP_VOP_ACCESS_DESCOFFSET,
	"rump_vop_access",
	0,
	rump_vop_access_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_access_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_ACCESS(struct vnode *vp,
    int mode,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_access_args a;
	a.a_desc = VDESC(rump_vop_access);
	a.a_vp = vp;
	a.a_mode = mode;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_access), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_getattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_getattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_getattr_desc = {
	RUMP_VOP_GETATTR_DESCOFFSET,
	"rump_vop_getattr",
	0,
	rump_vop_getattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_getattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_GETATTR(struct vnode *vp,
    struct vattr *vap,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_getattr_args a;
	a.a_desc = VDESC(rump_vop_getattr);
	a.a_vp = vp;
	a.a_vap = vap;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_getattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_setattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_setattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_setattr_desc = {
	RUMP_VOP_SETATTR_DESCOFFSET,
	"rump_vop_setattr",
	0,
	rump_vop_setattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_setattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_SETATTR(struct vnode *vp,
    struct vattr *vap,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_setattr_args a;
	a.a_desc = VDESC(rump_vop_setattr);
	a.a_vp = vp;
	a.a_vap = vap;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_setattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_read_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_read_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_read_desc = {
	RUMP_VOP_READ_DESCOFFSET,
	"rump_vop_read",
	0,
	rump_vop_read_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_read_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_READ(struct vnode *vp,
    struct uio *uio,
    int ioflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_read_args a;
	a.a_desc = VDESC(rump_vop_read);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_ioflag = ioflag;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_read), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_write_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_write_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_write_desc = {
	RUMP_VOP_WRITE_DESCOFFSET,
	"rump_vop_write",
	0,
	rump_vop_write_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_write_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_WRITE(struct vnode *vp,
    struct uio *uio,
    int ioflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_write_args a;
	a.a_desc = VDESC(rump_vop_write);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_ioflag = ioflag;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_write), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_ioctl_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_ioctl_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_ioctl_desc = {
	RUMP_VOP_IOCTL_DESCOFFSET,
	"rump_vop_ioctl",
	0,
	rump_vop_ioctl_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_ioctl_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_IOCTL(struct vnode *vp,
    u_long command,
    void *data,
    int fflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_ioctl_args a;
	a.a_desc = VDESC(rump_vop_ioctl);
	a.a_vp = vp;
	a.a_command = command;
	a.a_data = data;
	a.a_fflag = fflag;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_ioctl), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_fcntl_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_fcntl_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_fcntl_desc = {
	RUMP_VOP_FCNTL_DESCOFFSET,
	"rump_vop_fcntl",
	0,
	rump_vop_fcntl_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_fcntl_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_FCNTL(struct vnode *vp,
    u_int command,
    void *data,
    int fflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_fcntl_args a;
	a.a_desc = VDESC(rump_vop_fcntl);
	a.a_vp = vp;
	a.a_command = command;
	a.a_data = data;
	a.a_fflag = fflag;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_fcntl), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_poll_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_poll_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_poll_desc = {
	RUMP_VOP_POLL_DESCOFFSET,
	"rump_vop_poll",
	0,
	rump_vop_poll_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_POLL(struct vnode *vp,
    int events)
{
	int error;
	bool mpsafe;
	struct rump_vop_poll_args a;
	a.a_desc = VDESC(rump_vop_poll);
	a.a_vp = vp;
	a.a_events = events;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_poll), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_kqfilter_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_kqfilter_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_kqfilter_desc = {
	RUMP_VOP_KQFILTER_DESCOFFSET,
	"rump_vop_kqfilter",
	0,
	rump_vop_kqfilter_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_KQFILTER(struct vnode *vp,
    struct knote *kn)
{
	int error;
	bool mpsafe;
	struct rump_vop_kqfilter_args a;
	a.a_desc = VDESC(rump_vop_kqfilter);
	a.a_vp = vp;
	a.a_kn = kn;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_kqfilter), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_revoke_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_revoke_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_revoke_desc = {
	RUMP_VOP_REVOKE_DESCOFFSET,
	"rump_vop_revoke",
	0,
	rump_vop_revoke_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_REVOKE(struct vnode *vp,
    int flags)
{
	int error;
	bool mpsafe;
	struct rump_vop_revoke_args a;
	a.a_desc = VDESC(rump_vop_revoke);
	a.a_vp = vp;
	a.a_flags = flags;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_revoke), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_mmap_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_mmap_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_mmap_desc = {
	RUMP_VOP_MMAP_DESCOFFSET,
	"rump_vop_mmap",
	0,
	rump_vop_mmap_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_mmap_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_MMAP(struct vnode *vp,
    int prot,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_mmap_args a;
	a.a_desc = VDESC(rump_vop_mmap);
	a.a_vp = vp;
	a.a_prot = prot;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_mmap), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_fsync_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_fsync_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_fsync_desc = {
	RUMP_VOP_FSYNC_DESCOFFSET,
	"rump_vop_fsync",
	0,
	rump_vop_fsync_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_fsync_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_FSYNC(struct vnode *vp,
    kauth_cred_t cred,
    int flags,
    off_t offlo,
    off_t offhi)
{
	int error;
	bool mpsafe;
	struct rump_vop_fsync_args a;
	a.a_desc = VDESC(rump_vop_fsync);
	a.a_vp = vp;
	a.a_cred = cred;
	a.a_flags = flags;
	a.a_offlo = offlo;
	a.a_offhi = offhi;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_fsync), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_seek_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_seek_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_seek_desc = {
	RUMP_VOP_SEEK_DESCOFFSET,
	"rump_vop_seek",
	0,
	rump_vop_seek_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_seek_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_SEEK(struct vnode *vp,
    off_t oldoff,
    off_t newoff,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_seek_args a;
	a.a_desc = VDESC(rump_vop_seek);
	a.a_vp = vp;
	a.a_oldoff = oldoff;
	a.a_newoff = newoff;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_seek), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_remove_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_remove_args,a_dvp),
	VOPARG_OFFSETOF(struct rump_vop_remove_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_remove_desc = {
	RUMP_VOP_REMOVE_DESCOFFSET,
	"rump_vop_remove",
	0 | VDESC_VP0_WILLPUT | VDESC_VP1_WILLPUT,
	rump_vop_remove_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_remove_args, a_cnp),
	NULL,
};
int
RUMP_VOP_REMOVE(struct vnode *dvp,
    struct vnode *vp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct rump_vop_remove_args a;
	a.a_desc = VDESC(rump_vop_remove);
	a.a_dvp = dvp;
	a.a_vp = vp;
	a.a_cnp = cnp;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_remove), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_link_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_link_args,a_dvp),
	VOPARG_OFFSETOF(struct rump_vop_link_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_link_desc = {
	RUMP_VOP_LINK_DESCOFFSET,
	"rump_vop_link",
	0 | VDESC_VP0_WILLPUT,
	rump_vop_link_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_link_args, a_cnp),
	NULL,
};
int
RUMP_VOP_LINK(struct vnode *dvp,
    struct vnode *vp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct rump_vop_link_args a;
	a.a_desc = VDESC(rump_vop_link);
	a.a_dvp = dvp;
	a.a_vp = vp;
	a.a_cnp = cnp;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_link), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_rename_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_rename_args,a_fdvp),
	VOPARG_OFFSETOF(struct rump_vop_rename_args,a_fvp),
	VOPARG_OFFSETOF(struct rump_vop_rename_args,a_tdvp),
	VOPARG_OFFSETOF(struct rump_vop_rename_args,a_tvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_rename_desc = {
	RUMP_VOP_RENAME_DESCOFFSET,
	"rump_vop_rename",
	0 | VDESC_VP0_WILLRELE | VDESC_VP1_WILLRELE | VDESC_VP2_WILLPUT | VDESC_VP3_WILLPUT,
	rump_vop_rename_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_rename_args, a_fcnp),
	NULL,
};
int
RUMP_VOP_RENAME(struct vnode *fdvp,
    struct vnode *fvp,
    struct componentname *fcnp,
    struct vnode *tdvp,
    struct vnode *tvp,
    struct componentname *tcnp)
{
	int error;
	bool mpsafe;
	struct rump_vop_rename_args a;
	a.a_desc = VDESC(rump_vop_rename);
	a.a_fdvp = fdvp;
	a.a_fvp = fvp;
	a.a_fcnp = fcnp;
	a.a_tdvp = tdvp;
	a.a_tvp = tvp;
	a.a_tcnp = tcnp;
	mpsafe = (fdvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(fdvp, VOFFSET(rump_vop_rename), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_mkdir_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_mkdir_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_mkdir_desc = {
	RUMP_VOP_MKDIR_DESCOFFSET,
	"rump_vop_mkdir",
	0 | VDESC_VP0_WILLPUT,
	rump_vop_mkdir_vp_offsets,
	VOPARG_OFFSETOF(struct rump_vop_mkdir_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_mkdir_args, a_cnp),
	NULL,
};
int
RUMP_VOP_MKDIR(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap)
{
	int error;
	bool mpsafe;
	struct rump_vop_mkdir_args a;
	a.a_desc = VDESC(rump_vop_mkdir);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_mkdir), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int rump_vop_rmdir_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_rmdir_args,a_dvp),
	VOPARG_OFFSETOF(struct rump_vop_rmdir_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_rmdir_desc = {
	RUMP_VOP_RMDIR_DESCOFFSET,
	"rump_vop_rmdir",
	0 | VDESC_VP0_WILLPUT | VDESC_VP1_WILLPUT,
	rump_vop_rmdir_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_rmdir_args, a_cnp),
	NULL,
};
int
RUMP_VOP_RMDIR(struct vnode *dvp,
    struct vnode *vp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct rump_vop_rmdir_args a;
	a.a_desc = VDESC(rump_vop_rmdir);
	a.a_dvp = dvp;
	a.a_vp = vp;
	a.a_cnp = cnp;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_rmdir), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_symlink_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_symlink_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_symlink_desc = {
	RUMP_VOP_SYMLINK_DESCOFFSET,
	"rump_vop_symlink",
	0 | VDESC_VP0_WILLPUT,
	rump_vop_symlink_vp_offsets,
	VOPARG_OFFSETOF(struct rump_vop_symlink_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_symlink_args, a_cnp),
	NULL,
};
int
RUMP_VOP_SYMLINK(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap,
    char *target)
{
	int error;
	bool mpsafe;
	struct rump_vop_symlink_args a;
	a.a_desc = VDESC(rump_vop_symlink);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	a.a_target = target;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_symlink), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int rump_vop_readdir_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_readdir_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_readdir_desc = {
	RUMP_VOP_READDIR_DESCOFFSET,
	"rump_vop_readdir",
	0,
	rump_vop_readdir_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_readdir_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_READDIR(struct vnode *vp,
    struct uio *uio,
    kauth_cred_t cred,
    int *eofflag,
    off_t **cookies,
    int *ncookies)
{
	int error;
	bool mpsafe;
	struct rump_vop_readdir_args a;
	a.a_desc = VDESC(rump_vop_readdir);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_cred = cred;
	a.a_eofflag = eofflag;
	a.a_cookies = cookies;
	a.a_ncookies = ncookies;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_readdir), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_readlink_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_readlink_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_readlink_desc = {
	RUMP_VOP_READLINK_DESCOFFSET,
	"rump_vop_readlink",
	0,
	rump_vop_readlink_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_readlink_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_READLINK(struct vnode *vp,
    struct uio *uio,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_readlink_args a;
	a.a_desc = VDESC(rump_vop_readlink);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_readlink), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_abortop_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_abortop_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_abortop_desc = {
	RUMP_VOP_ABORTOP_DESCOFFSET,
	"rump_vop_abortop",
	0,
	rump_vop_abortop_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_abortop_args, a_cnp),
	NULL,
};
int
RUMP_VOP_ABORTOP(struct vnode *dvp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct rump_vop_abortop_args a;
	a.a_desc = VDESC(rump_vop_abortop);
	a.a_dvp = dvp;
	a.a_cnp = cnp;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_abortop), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_inactive_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_inactive_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_inactive_desc = {
	RUMP_VOP_INACTIVE_DESCOFFSET,
	"rump_vop_inactive",
	0 | VDESC_VP0_WILLUNLOCK,
	rump_vop_inactive_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_INACTIVE(struct vnode *vp,
    bool *recycle)
{
	int error;
	bool mpsafe;
	struct rump_vop_inactive_args a;
	a.a_desc = VDESC(rump_vop_inactive);
	a.a_vp = vp;
	a.a_recycle = recycle;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_inactive), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_reclaim_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_reclaim_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_reclaim_desc = {
	RUMP_VOP_RECLAIM_DESCOFFSET,
	"rump_vop_reclaim",
	0,
	rump_vop_reclaim_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_RECLAIM(struct vnode *vp)
{
	int error;
	bool mpsafe;
	struct rump_vop_reclaim_args a;
	a.a_desc = VDESC(rump_vop_reclaim);
	a.a_vp = vp;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_reclaim), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_lock_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_lock_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_lock_desc = {
	RUMP_VOP_LOCK_DESCOFFSET,
	"rump_vop_lock",
	0,
	rump_vop_lock_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_LOCK(struct vnode *vp,
    int flags)
{
	int error;
	bool mpsafe;
	struct rump_vop_lock_args a;
	a.a_desc = VDESC(rump_vop_lock);
	a.a_vp = vp;
	a.a_flags = flags;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_lock), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_unlock_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_unlock_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_unlock_desc = {
	RUMP_VOP_UNLOCK_DESCOFFSET,
	"rump_vop_unlock",
	0,
	rump_vop_unlock_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_UNLOCK(struct vnode *vp,
    int flags)
{
	int error;
	bool mpsafe;
	struct rump_vop_unlock_args a;
	a.a_desc = VDESC(rump_vop_unlock);
	a.a_vp = vp;
	a.a_flags = flags;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_unlock), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_bmap_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_bmap_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_bmap_desc = {
	RUMP_VOP_BMAP_DESCOFFSET,
	"rump_vop_bmap",
	0,
	rump_vop_bmap_vp_offsets,
	VOPARG_OFFSETOF(struct rump_vop_bmap_args, a_vpp),
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_BMAP(struct vnode *vp,
    daddr_t bn,
    struct vnode **vpp,
    daddr_t *bnp,
    int *runp)
{
	int error;
	bool mpsafe;
	struct rump_vop_bmap_args a;
	a.a_desc = VDESC(rump_vop_bmap);
	a.a_vp = vp;
	a.a_bn = bn;
	a.a_vpp = vpp;
	a.a_bnp = bnp;
	a.a_runp = runp;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_bmap), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_strategy_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_strategy_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_strategy_desc = {
	RUMP_VOP_STRATEGY_DESCOFFSET,
	"rump_vop_strategy",
	0,
	rump_vop_strategy_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_STRATEGY(struct vnode *vp,
    struct buf *bp)
{
	int error;
	bool mpsafe;
	struct rump_vop_strategy_args a;
	a.a_desc = VDESC(rump_vop_strategy);
	a.a_vp = vp;
	a.a_bp = bp;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_strategy), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_print_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_print_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_print_desc = {
	RUMP_VOP_PRINT_DESCOFFSET,
	"rump_vop_print",
	0,
	rump_vop_print_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_PRINT(struct vnode *vp)
{
	int error;
	bool mpsafe;
	struct rump_vop_print_args a;
	a.a_desc = VDESC(rump_vop_print);
	a.a_vp = vp;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_print), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_islocked_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_islocked_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_islocked_desc = {
	RUMP_VOP_ISLOCKED_DESCOFFSET,
	"rump_vop_islocked",
	0,
	rump_vop_islocked_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_ISLOCKED(struct vnode *vp)
{
	int error;
	bool mpsafe;
	struct rump_vop_islocked_args a;
	a.a_desc = VDESC(rump_vop_islocked);
	a.a_vp = vp;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_islocked), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_pathconf_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_pathconf_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_pathconf_desc = {
	RUMP_VOP_PATHCONF_DESCOFFSET,
	"rump_vop_pathconf",
	0,
	rump_vop_pathconf_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_PATHCONF(struct vnode *vp,
    int name,
    register_t *retval)
{
	int error;
	bool mpsafe;
	struct rump_vop_pathconf_args a;
	a.a_desc = VDESC(rump_vop_pathconf);
	a.a_vp = vp;
	a.a_name = name;
	a.a_retval = retval;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_pathconf), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_advlock_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_advlock_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_advlock_desc = {
	RUMP_VOP_ADVLOCK_DESCOFFSET,
	"rump_vop_advlock",
	0,
	rump_vop_advlock_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_ADVLOCK(struct vnode *vp,
    void *id,
    int op,
    struct flock *fl,
    int flags)
{
	int error;
	bool mpsafe;
	struct rump_vop_advlock_args a;
	a.a_desc = VDESC(rump_vop_advlock);
	a.a_vp = vp;
	a.a_id = id;
	a.a_op = op;
	a.a_fl = fl;
	a.a_flags = flags;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_advlock), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_whiteout_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_whiteout_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_whiteout_desc = {
	RUMP_VOP_WHITEOUT_DESCOFFSET,
	"rump_vop_whiteout",
	0,
	rump_vop_whiteout_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_whiteout_args, a_cnp),
	NULL,
};
int
RUMP_VOP_WHITEOUT(struct vnode *dvp,
    struct componentname *cnp,
    int flags)
{
	int error;
	bool mpsafe;
	struct rump_vop_whiteout_args a;
	a.a_desc = VDESC(rump_vop_whiteout);
	a.a_dvp = dvp;
	a.a_cnp = cnp;
	a.a_flags = flags;
	mpsafe = (dvp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(dvp, VOFFSET(rump_vop_whiteout), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_getpages_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_getpages_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_getpages_desc = {
	RUMP_VOP_GETPAGES_DESCOFFSET,
	"rump_vop_getpages",
	0,
	rump_vop_getpages_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_GETPAGES(struct vnode *vp,
    off_t offset,
    struct vm_page **m,
    int *count,
    int centeridx,
    int access_type,
    int advice,
    int flags)
{
	int error;
	bool mpsafe;
	struct rump_vop_getpages_args a;
	a.a_desc = VDESC(rump_vop_getpages);
	a.a_vp = vp;
	a.a_offset = offset;
	a.a_m = m;
	a.a_count = count;
	a.a_centeridx = centeridx;
	a.a_access_type = access_type;
	a.a_advice = advice;
	a.a_flags = flags;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_getpages), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_putpages_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_putpages_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_putpages_desc = {
	RUMP_VOP_PUTPAGES_DESCOFFSET,
	"rump_vop_putpages",
	0,
	rump_vop_putpages_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_PUTPAGES(struct vnode *vp,
    off_t offlo,
    off_t offhi,
    int flags)
{
	int error;
	bool mpsafe;
	struct rump_vop_putpages_args a;
	a.a_desc = VDESC(rump_vop_putpages);
	a.a_vp = vp;
	a.a_offlo = offlo;
	a.a_offhi = offhi;
	a.a_flags = flags;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_putpages), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_closeextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_closeextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_closeextattr_desc = {
	RUMP_VOP_CLOSEEXTATTR_DESCOFFSET,
	"rump_vop_closeextattr",
	0,
	rump_vop_closeextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_closeextattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_CLOSEEXTATTR(struct vnode *vp,
    int commit,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_closeextattr_args a;
	a.a_desc = VDESC(rump_vop_closeextattr);
	a.a_vp = vp;
	a.a_commit = commit;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_closeextattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_getextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_getextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_getextattr_desc = {
	RUMP_VOP_GETEXTATTR_DESCOFFSET,
	"rump_vop_getextattr",
	0,
	rump_vop_getextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_getextattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_GETEXTATTR(struct vnode *vp,
    int attrnamespace,
    const char *name,
    struct uio *uio,
    size_t *size,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_getextattr_args a;
	a.a_desc = VDESC(rump_vop_getextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_name = name;
	a.a_uio = uio;
	a.a_size = size;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_getextattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_listextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_listextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_listextattr_desc = {
	RUMP_VOP_LISTEXTATTR_DESCOFFSET,
	"rump_vop_listextattr",
	0,
	rump_vop_listextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_listextattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_LISTEXTATTR(struct vnode *vp,
    int attrnamespace,
    struct uio *uio,
    size_t *size,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_listextattr_args a;
	a.a_desc = VDESC(rump_vop_listextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_uio = uio;
	a.a_size = size;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_listextattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_openextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_openextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_openextattr_desc = {
	RUMP_VOP_OPENEXTATTR_DESCOFFSET,
	"rump_vop_openextattr",
	0,
	rump_vop_openextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_openextattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_OPENEXTATTR(struct vnode *vp,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_openextattr_args a;
	a.a_desc = VDESC(rump_vop_openextattr);
	a.a_vp = vp;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_openextattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_deleteextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_deleteextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_deleteextattr_desc = {
	RUMP_VOP_DELETEEXTATTR_DESCOFFSET,
	"rump_vop_deleteextattr",
	0,
	rump_vop_deleteextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_deleteextattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_DELETEEXTATTR(struct vnode *vp,
    int attrnamespace,
    const char *name,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_deleteextattr_args a;
	a.a_desc = VDESC(rump_vop_deleteextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_name = name;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_deleteextattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

const int rump_vop_setextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct rump_vop_setextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc rump_vop_setextattr_desc = {
	RUMP_VOP_SETEXTATTR_DESCOFFSET,
	"rump_vop_setextattr",
	0,
	rump_vop_setextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct rump_vop_setextattr_args, a_cred),
	VDESC_NO_OFFSET,
	NULL,
};
int
RUMP_VOP_SETEXTATTR(struct vnode *vp,
    int attrnamespace,
    const char *name,
    struct uio *uio,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct rump_vop_setextattr_args a;
	a.a_desc = VDESC(rump_vop_setextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_name = name;
	a.a_uio = uio;
	a.a_cred = cred;
	mpsafe = (vp->v_vflag & VV_MPSAFE);
	if (!mpsafe) { KERNEL_LOCK(1, curlwp); }
	error = (VCALL(vp, VOFFSET(rump_vop_setextattr), &a));
	if (!mpsafe) { KERNEL_UNLOCK_ONE(curlwp); }
	return error;
}

/* End of special cases. */

const struct vnodeop_desc * const rump_vfs_op_descs[] = {
	&rump_vop_default_desc,	/* MUST BE FIRST */
	&rump_vop_bwrite_desc,	/* XXX: SPECIAL CASE */

	&rump_vop_lookup_desc,
	&rump_vop_create_desc,
	&rump_vop_mknod_desc,
	&rump_vop_open_desc,
	&rump_vop_close_desc,
	&rump_vop_access_desc,
	&rump_vop_getattr_desc,
	&rump_vop_setattr_desc,
	&rump_vop_read_desc,
	&rump_vop_write_desc,
	&rump_vop_ioctl_desc,
	&rump_vop_fcntl_desc,
	&rump_vop_poll_desc,
	&rump_vop_kqfilter_desc,
	&rump_vop_revoke_desc,
	&rump_vop_mmap_desc,
	&rump_vop_fsync_desc,
	&rump_vop_seek_desc,
	&rump_vop_remove_desc,
	&rump_vop_link_desc,
	&rump_vop_rename_desc,
	&rump_vop_mkdir_desc,
	&rump_vop_rmdir_desc,
	&rump_vop_symlink_desc,
	&rump_vop_readdir_desc,
	&rump_vop_readlink_desc,
	&rump_vop_abortop_desc,
	&rump_vop_inactive_desc,
	&rump_vop_reclaim_desc,
	&rump_vop_lock_desc,
	&rump_vop_unlock_desc,
	&rump_vop_bmap_desc,
	&rump_vop_strategy_desc,
	&rump_vop_print_desc,
	&rump_vop_islocked_desc,
	&rump_vop_pathconf_desc,
	&rump_vop_advlock_desc,
	&rump_vop_whiteout_desc,
	&rump_vop_getpages_desc,
	&rump_vop_putpages_desc,
	&rump_vop_closeextattr_desc,
	&rump_vop_getextattr_desc,
	&rump_vop_listextattr_desc,
	&rump_vop_openextattr_desc,
	&rump_vop_deleteextattr_desc,
	&rump_vop_setextattr_desc,
	NULL
};

